/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.util;

import gr.ekt.bte.core.DataLoader;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.Value;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.dspace.submit.lookup.SubmissionLookupService;
import org.dspace.submit.util.SubmissionLookupPublication;

public class ItemSubmissionLookupDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MERGED_PUBLICATION_PROVIDER = "merged";
    private static final String UNKNOWN_PROVIDER_STRING = "UNKNOWN-PROVIDER";
    private List<Record> publications;
    private String uuid = UUID.randomUUID().toString();

    public ItemSubmissionLookupDTO(List<Record> publications) {
        this.publications = publications;
    }

    public List<Record> getPublications() {
        return this.publications;
    }

    public Set<String> getProviders() {
        LinkedHashSet<String> orderedProviders = new LinkedHashSet<String>();
        for (Record p : this.publications) {
            orderedProviders.add(SubmissionLookupService.getProviderName(p));
        }
        return orderedProviders;
    }

    public String getUUID() {
        return this.uuid;
    }

    public Record getTotalPublication(List<DataLoader> providers) {
        if (this.publications == null) {
            return null;
        }
        if (this.publications.size() == 1) {
            return this.publications.get(0);
        }
        SubmissionLookupPublication pub = new SubmissionLookupPublication(MERGED_PUBLICATION_PROVIDER);
        for (Record p : this.publications) {
            for (String field : p.getFields()) {
                List values = p.getValues(field);
                if (values == null || values.size() <= 0 || pub.getFields().contains(field)) continue;
                for (Value v : values) {
                    pub.addValue(field, v);
                }
            }
        }
        return pub;
    }
}

