/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.license;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.license.CCLookup;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;

public class CreativeCommons {
    private static Logger log = Logger.getLogger(CreativeCommons.class);
    public static final String CC_BUNDLE_NAME = "CC-LICENSE";
    private static final String CC_BS_SOURCE = "org.dspace.license.CreativeCommons";
    @Deprecated
    private static final String BSN_LICENSE_URL = "license_url";
    @Deprecated
    private static final String BSN_LICENSE_TEXT = "license_text";
    private static final String BSN_LICENSE_RDF = "license_rdf";
    protected static final Templates templates;
    private static final String ccShib = "creativecommons";

    public static boolean isEnabled() {
        return true;
    }

    private static Bundle getCcBundle(Item item) throws SQLException, AuthorizeException, IOException {
        Bundle[] bundles = item.getBundles(CC_BUNDLE_NAME);
        if (bundles.length > 0 && bundles[0] != null) {
            item.removeBundle(bundles[0]);
        }
        return item.createBundle(CC_BUNDLE_NAME);
    }

    public static void setLicenseRDF(Context context, Item item, String licenseRdf) throws SQLException, IOException, AuthorizeException {
        Bundle bundle = CreativeCommons.getCcBundle(item);
        BitstreamFormat bs_rdf_format = BitstreamFormat.findByShortDescription(context, "RDF XML");
        CreativeCommons.setBitstreamFromBytes(item, bundle, BSN_LICENSE_RDF, bs_rdf_format, licenseRdf.getBytes());
    }

    public static void setLicense(Context context, Item item, InputStream licenseStm, String mimeType) throws SQLException, IOException, AuthorizeException {
        Bundle bundle = CreativeCommons.getCcBundle(item);
        BitstreamFormat bs_format = mimeType.equalsIgnoreCase("text/xml") ? BitstreamFormat.findByShortDescription(context, "CC License") : (mimeType.equalsIgnoreCase("text/rdf") ? BitstreamFormat.findByShortDescription(context, "RDF XML") : BitstreamFormat.findByShortDescription(context, "License"));
        Bitstream bs = bundle.createBitstream(licenseStm);
        bs.setSource(CC_BS_SOURCE);
        bs.setName(mimeType != null && (mimeType.equalsIgnoreCase("text/xml") || mimeType.equalsIgnoreCase("text/rdf")) ? BSN_LICENSE_RDF : BSN_LICENSE_TEXT);
        bs.setFormat(bs_format);
        bs.update();
    }

    public static void removeLicense(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        Bundle[] bundles = item.getBundles(CC_BUNDLE_NAME);
        if (bundles.length > 0 && bundles[0] != null) {
            item.removeBundle(bundles[0]);
        }
    }

    public static boolean hasLicense(Context context, Item item) throws SQLException, IOException {
        Bundle[] bundles = item.getBundles(CC_BUNDLE_NAME);
        if (bundles.length == 0) {
            return false;
        }
        try {
            if (CreativeCommons.getLicenseURL(item) == null) {
                return false;
            }
        }
        catch (AuthorizeException ae) {
            return false;
        }
        return true;
    }

    public static String getLicenseRDF(Item item) throws SQLException, IOException, AuthorizeException {
        return CreativeCommons.getStringFromBitstream(item, BSN_LICENSE_RDF);
    }

    public static Bitstream getLicenseRdfBitstream(Item item) throws SQLException, IOException, AuthorizeException {
        return CreativeCommons.getBitstream(item, BSN_LICENSE_RDF);
    }

    @Deprecated
    public static Bitstream getLicenseTextBitstream(Item item) throws SQLException, IOException, AuthorizeException {
        return CreativeCommons.getBitstream(item, BSN_LICENSE_TEXT);
    }

    public static String getLicenseText(Item item) throws SQLException, IOException, AuthorizeException {
        return CreativeCommons.getStringFromBitstream(item, BSN_LICENSE_TEXT);
    }

    public static String getLicenseURL(Item item) throws SQLException, IOException, AuthorizeException {
        String licenseUri = CreativeCommons.getCCField("uri").ccItemValue(item);
        if (StringUtils.isNotBlank((String)licenseUri)) {
            return licenseUri;
        }
        return CreativeCommons.getStringFromBitstream(item, BSN_LICENSE_URL);
    }

    public static String fetchLicenseRDF(Document license) {
        StringWriter result = new StringWriter();
        try {
            templates.newTransformer().transform((Source)new JDOMSource(license), new StreamResult(result));
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return result.getBuffer().toString();
    }

    private static void setBitstreamFromBytes(Item item, Bundle bundle, String bitstream_name, BitstreamFormat format, byte[] bytes) throws SQLException, IOException, AuthorizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Bitstream bs = bundle.createBitstream(bais);
        bs.setName(bitstream_name);
        bs.setSource(CC_BS_SOURCE);
        bs.setFormat(format);
        bs.update();
    }

    private static String getStringFromBitstream(Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        byte[] bytes = CreativeCommons.getBytesFromBitstream(item, bitstream_name);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    private static Bitstream getBitstream(Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        Bundle cc_bundle = null;
        try {
            Bundle[] bundles = item.getBundles(CC_BUNDLE_NAME);
            if (bundles == null || bundles.length <= 0) {
                return null;
            }
            cc_bundle = bundles[0];
        }
        catch (Exception exc) {
            return null;
        }
        return cc_bundle.getBitstreamByName(bitstream_name);
    }

    private static byte[] getBytesFromBitstream(Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        Bitstream bs = CreativeCommons.getBitstream(item, bitstream_name);
        if (bs == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utils.copy(bs.retrieve(), baos);
        return baos.toByteArray();
    }

    public static MdField getCCField(String fieldId) {
        return new MdField(ConfigurationManager.getProperty("cc.license." + fieldId));
    }

    public static void removeLicense(Context context, MdField uriField, MdField nameField, Item item) throws AuthorizeException, IOException, SQLException {
        String licenseUri = uriField.ccItemValue(item);
        if (licenseUri != null) {
            uriField.removeItemValue(item, licenseUri);
            if (ConfigurationManager.getBooleanProperty("cc.submit.setname")) {
                String licenseName = nameField.keyedItemValue(item, licenseUri);
                nameField.removeItemValue(item, licenseName);
            }
            if (ConfigurationManager.getBooleanProperty("cc.submit.addbitstream")) {
                CreativeCommons.removeLicense(context, item);
            }
        }
    }

    static {
        String proxyHost = ConfigurationManager.getProperty("http.proxy.host");
        String proxyPort = ConfigurationManager.getProperty("http.proxy.port");
        if (StringUtils.isNotBlank((String)proxyHost) && StringUtils.isNotBlank((String)proxyPort)) {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
        }
        try {
            templates = TransformerFactory.newInstance().newTemplates(new StreamSource(CreativeCommons.class.getResourceAsStream("CreativeCommons.xsl")));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static class MdField {
        private String[] params = new String[4];

        public MdField(String fieldName) {
            if (fieldName != null && fieldName.length() > 0) {
                String[] fParams = fieldName.split("\\.");
                for (int i = 0; i < fParams.length; ++i) {
                    this.params[i] = fParams[i];
                }
                this.params[3] = "*";
            }
        }

        public String ccItemValue(Item item) {
            Metadatum[] dcvalues;
            for (Metadatum dcvalue : dcvalues = item.getMetadata(this.params[0], this.params[1], this.params[2], this.params[3])) {
                if (dcvalue.value.indexOf(CreativeCommons.ccShib) == -1) continue;
                return dcvalue.value;
            }
            return null;
        }

        public String keyedItemValue(Item item, String key) throws AuthorizeException, IOException, SQLException {
            Metadatum[] dcvalues;
            CCLookup ccLookup = new CCLookup();
            ccLookup.issue(key);
            String matchValue = ccLookup.getLicenseName();
            for (Metadatum dcvalue : dcvalues = item.getMetadata(this.params[0], this.params[1], this.params[2], this.params[3])) {
                if (!dcvalue.value.equals(matchValue)) continue;
                return dcvalue.value;
            }
            return null;
        }

        public void removeItemValue(Item item, String value) throws AuthorizeException, IOException, SQLException {
            if (value != null) {
                Metadatum[] dcvalues = item.getMetadata(this.params[0], this.params[1], this.params[2], this.params[3]);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Metadatum dcvalue : dcvalues) {
                    if (dcvalue.value.equals(value)) continue;
                    arrayList.add(dcvalue.value);
                }
                String[] values = arrayList.toArray(new String[arrayList.size()]);
                item.clearMetadata(this.params[0], this.params[1], this.params[2], this.params[3]);
                item.addMetadata(this.params[0], this.params[1], this.params[2], this.params[3], values);
            }
        }

        public void addItemValue(Item item, String value) {
            item.addMetadata(this.params[0], this.params[1], this.params[2], this.params[3], value);
        }
    }
}

