/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import java.io.File;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.statistics.SolrLogger;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;

public class StatisticsDataGenerator {
    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("n", "nrlogs", true, "type: nr of logs to be generated");
        options.addOption("s", "startDate", true, "type: the start date from which we start generating our logs");
        options.addOption("e", "endDate", true, "type: the end date from which we start generating our logs");
        options.addOption("a", "cms", true, "The starting id of our community");
        options.addOption("b", "cme", true, "The end id of our community");
        options.addOption("c", "cls", true, "The starting id of our collection");
        options.addOption("d", "cle", true, "The end if of our collection");
        options.addOption("f", "is", true, "The starting id of our item");
        options.addOption("g", "ie", true, "The end id of our item");
        options.addOption("h", "bs", true, "The starting id of our bitstream");
        options.addOption("i", "be", true, "The end id of our bitstream");
        options.addOption("j", "ps", true, "The starting id of our epersons");
        options.addOption("k", "pe", true, "The end id of our epersons");
        CommandLine line = parser.parse(options, args);
        if (!line.hasOption("n")) {
            System.out.println("We need to know how many logs we need to create");
            return;
        }
        int nrLogs = Integer.parseInt(line.getOptionValue("n"));
        long startDate = line.hasOption("s") ? StatisticsDataGenerator.getDateInMiliseconds(line.getOptionValue("s")) : StatisticsDataGenerator.getDateInMiliseconds("01/01/2006");
        long endDate = line.hasOption("e") ? StatisticsDataGenerator.getDateInMiliseconds(line.getOptionValue("e")) : new Date().getTime();
        if (!line.hasOption("a")) {
            return;
        }
        long commStartId = Long.parseLong(line.getOptionValue("a"));
        if (!line.hasOption("b")) {
            return;
        }
        long commEndId = Long.parseLong(line.getOptionValue("b"));
        if (!line.hasOption("c")) {
            return;
        }
        long collStartId = Long.parseLong(line.getOptionValue("c"));
        if (!line.hasOption("d")) {
            return;
        }
        long collEndId = Long.parseLong(line.getOptionValue("d"));
        if (!line.hasOption("f")) {
            return;
        }
        long itemStartId = Long.parseLong(line.getOptionValue("f"));
        if (!line.hasOption("g")) {
            return;
        }
        long itemEndId = Long.parseLong(line.getOptionValue("g"));
        if (!line.hasOption("h")) {
            return;
        }
        long bitStartId = Long.parseLong(line.getOptionValue("h"));
        if (!line.hasOption("i")) {
            return;
        }
        long bitEndId = Long.parseLong(line.getOptionValue("i"));
        if (!line.hasOption("j")) {
            return;
        }
        long epersonStartId = Long.parseLong(line.getOptionValue("j"));
        if (!line.hasOption("k")) {
            return;
        }
        long epersonEndId = Long.parseLong(line.getOptionValue("k"));
        long maxIdTotal = Math.max(commEndId, collEndId);
        maxIdTotal = Math.max(maxIdTotal, itemEndId);
        maxIdTotal = Math.max(maxIdTotal, bitEndId);
        epersonEndId *= 4L;
        Context context = new Context();
        HttpSolrServer solr = new HttpSolrServer(ConfigurationManager.getProperty("solr-statistics", "server"));
        solr.deleteByQuery("*:*");
        solr.commit();
        String prevIp = null;
        String dbPath = ConfigurationManager.getProperty("usage-statistics", "dbfile");
        File dbFile = new File(dbPath);
        DatabaseReader cl = new DatabaseReader.Builder(dbFile).build();
        int countryErrors = 0;
        for (int i = 0; i < nrLogs; ++i) {
            Bitstream bit;
            String continent;
            CityResponse location;
            String ip = "";
            StringBuilder ipBuilder = new StringBuilder();
            for (int j = 0; j < 4; ++j) {
                ipBuilder.append(StatisticsDataGenerator.getRandomNumberInRange(0L, 254L));
                if (j == 3) continue;
                ipBuilder.append(".");
            }
            ip = ipBuilder.toString();
            try {
                InetAddress ipAddress = InetAddress.getByName(ip);
                location = cl.city(ipAddress);
            }
            catch (Exception e) {
                location = null;
            }
            if (location == null) {
                if (prevIp == null) continue;
                ip = prevIp;
                InetAddress ipAddress = InetAddress.getByName(ip);
                location = cl.city(ipAddress);
            }
            String city = location.getCity().getName();
            String countryCode = location.getCountry().getIsoCode();
            double longitude = location.getLocation().getLongitude();
            double latitude = location.getLocation().getLatitude();
            try {
                continent = LocationUtils.getContinentCode(countryCode);
            }
            catch (Exception e) {
                System.out.println("COUNTRY ERROR: " + countryCode);
                ++countryErrors;
                continue;
            }
            Date time = new Date(StatisticsDataGenerator.getRandomNumberInRange(startDate, endDate));
            int type = (int)StatisticsDataGenerator.getRandomNumberInRange(0L, 8L);
            if (type == 1 || type >= 5) {
                type = 2;
            }
            int dsoId = -1;
            switch (type) {
                case 4: {
                    dsoId = (int)StatisticsDataGenerator.getRandomNumberInRange(commStartId, commEndId);
                    break;
                }
                case 3: {
                    dsoId = (int)StatisticsDataGenerator.getRandomNumberInRange(collStartId, collEndId);
                    break;
                }
                case 2: {
                    dsoId = (int)StatisticsDataGenerator.getRandomNumberInRange(itemStartId, itemEndId);
                    break;
                }
                case 0: {
                    dsoId = (int)StatisticsDataGenerator.getRandomNumberInRange(bitStartId, bitEndId);
                }
            }
            DSpaceObject dso = DSpaceObject.find(context, type, dsoId);
            if (dso instanceof Bitstream && (bit = (Bitstream)dso).getFormat().isInternal()) {
                dso = null;
            }
            boolean substract = false;
            while (dso == null) {
                Bitstream bit2;
                if ((long)dsoId == maxIdTotal) {
                    substract = true;
                }
                dsoId = substract ? --dsoId : ++dsoId;
                dso = DSpaceObject.find(context, type, dsoId);
                if (!(dso instanceof Bitstream) || !(bit2 = (Bitstream)dso).getFormat().isInternal()) continue;
                dso = null;
            }
            int epersonId = (int)StatisticsDataGenerator.getRandomNumberInRange(epersonStartId, epersonEndId);
            EPerson eperson = EPerson.find(context, epersonId);
            if (eperson == null) {
                epersonId = -1;
            }
            String dns = null;
            try {
                dns = DnsLookup.reverseDns(ip);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(ip);
            System.out.println(dns);
            SolrInputDocument doc1 = new SolrInputDocument();
            doc1.addField("ip", (Object)ip);
            doc1.addField("type", (Object)dso.getType());
            doc1.addField("id", (Object)dso.getID());
            doc1.addField("time", (Object)DateFormatUtils.format((Date)time, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
            doc1.addField("continent", (Object)continent);
            doc1.addField("countryCode", (Object)countryCode);
            doc1.addField("city", (Object)city);
            doc1.addField("latitude", (Object)latitude);
            doc1.addField("longitude", (Object)longitude);
            if (epersonId > 0) {
                doc1.addField("epersonid", (Object)epersonId);
            }
            if (dns != null) {
                doc1.addField("dns", (Object)dns.toLowerCase());
            }
            SolrLogger.storeParents(doc1, dso);
            solr.add(doc1);
            prevIp = ip;
        }
        System.out.println("Nr of countryErrors: " + countryErrors);
        solr.commit();
    }

    private static long getRandomNumberInRange(long min, long max) {
        return min + (long)(Math.random() * (double)(max - min + 1L));
    }

    private static long getDateInMiliseconds(String dateString) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        return formatter.parse(dateString).getTime();
    }
}

