/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.TransformationEngine;
import gr.ekt.bte.core.TransformationSpec;
import gr.ekt.bte.exceptions.BadTransformationSpec;
import gr.ekt.bte.exceptions.MalformedSourceException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.submit.lookup.DSpaceWorkspaceItemOutputGenerator;
import org.dspace.submit.lookup.SubmissionItemDataLoader;
import org.dspace.submit.lookup.SubmissionLookupService;
import org.dspace.submit.util.ItemSubmissionLookupDTO;
import org.dspace.submit.util.SubmissionLookupDTO;
import org.dspace.submit.util.SubmissionLookupPublication;
import org.dspace.utils.DSpace;

public class StartSubmissionLookupStep
extends AbstractProcessingStep {
    public static final int STATUS_NO_COLLECTION = 1;
    public static final int STATUS_INVALID_COLLECTION = 2;
    public static final int STATUS_NO_SUUID = 3;
    public static final int STATUS_SUBMISSION_EXPIRED = 4;
    private SubmissionLookupService slService = (SubmissionLookupService)new DSpace().getServiceManager().getServiceByName(SubmissionLookupService.class.getCanonicalName(), SubmissionLookupService.class);
    private static Logger log = Logger.getLogger(StartSubmissionLookupStep.class);

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        int id = Util.getIntParameter(request, "collectionid");
        String titolo = request.getParameter("search_title");
        String date = request.getParameter("search_year");
        String autori = request.getParameter("search_authors");
        String uuidSubmission = request.getParameter("suuid");
        String uuidLookup = request.getParameter("iuuid");
        String fuuidLookup = request.getParameter("fuuid");
        if (StringUtils.isBlank((String)uuidSubmission)) {
            return 3;
        }
        SubmissionLookupDTO submissionDTO = this.slService.getSubmissionLookupDTO(request, uuidSubmission);
        if (submissionDTO == null) {
            return 4;
        }
        ItemSubmissionLookupDTO itemLookup = null;
        if ((fuuidLookup == null || fuuidLookup.isEmpty()) && StringUtils.isNotBlank((String)uuidLookup) && (itemLookup = submissionDTO.getLookupItem(uuidLookup)) == null) {
            return 4;
        }
        if (id < 0) {
            return 1;
        }
        Collection col = Collection.find(context, id);
        if (col == null) {
            return 2;
        }
        DCInputSet inputSet = null;
        try {
            inputSet = new DCInputsReader().getInputs(col.getHandle());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        ArrayList<ItemSubmissionLookupDTO> dto = new ArrayList<ItemSubmissionLookupDTO>();
        if (itemLookup != null) {
            dto.add(itemLookup);
        } else if (fuuidLookup != null && !fuuidLookup.isEmpty()) {
            String[] ss;
            for (String s : ss = fuuidLookup.split(",")) {
                itemLookup = submissionDTO.getLookupItem(s);
                if (itemLookup == null) {
                    return 4;
                }
                dto.add(itemLookup);
            }
        } else {
            SubmissionLookupPublication manualPub = new SubmissionLookupPublication("manual");
            manualPub.add("title", titolo);
            manualPub.add("year", date);
            manualPub.add("allauthors", autori);
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String parameterName = (String)e.nextElement();
                String parameterValue = request.getParameter(parameterName);
                if (!parameterName.startsWith("identifier_") || !StringUtils.isNotBlank((String)parameterValue)) continue;
                manualPub.add(parameterName.substring("identifier_".length()), parameterValue);
            }
            ArrayList<Record> publications = new ArrayList<Record>();
            publications.add((Record)manualPub);
            dto.add(new ItemSubmissionLookupDTO(publications));
        }
        List<WorkspaceItem> result = null;
        TransformationEngine transformationEngine = this.slService.getPhase2TransformationEngine();
        if (transformationEngine != null) {
            SubmissionItemDataLoader dataLoader = (SubmissionItemDataLoader)transformationEngine.getDataLoader();
            dataLoader.setDtoList(dto);
            DSpaceWorkspaceItemOutputGenerator outputGenerator = (DSpaceWorkspaceItemOutputGenerator)transformationEngine.getOutputGenerator();
            outputGenerator.setCollection(col);
            outputGenerator.setContext(context);
            outputGenerator.setFormName(inputSet.getFormName());
            outputGenerator.setDto((ItemSubmissionLookupDTO)dto.get(0));
            try {
                transformationEngine.transform(new TransformationSpec());
                result = outputGenerator.getWitems();
            }
            catch (BadTransformationSpec e1) {
                e1.printStackTrace();
            }
            catch (MalformedSourceException e1) {
                e1.printStackTrace();
            }
        }
        if (result != null && result.size() > 0) {
            subInfo.setSubmissionItem((InProgressSubmission)result.iterator().next());
        }
        context.commit();
        subInfo.reloadSubmissionConfig(request);
        this.slService.invalidateDTOs(request, uuidSubmission);
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }
}

