/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.Date;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.versioning.DefaultItemVersionProvider;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionDAO;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersionHistoryDAO;
import org.dspace.versioning.VersionHistoryImpl;
import org.dspace.versioning.VersionImpl;
import org.dspace.versioning.VersioningService;
import org.springframework.beans.factory.annotation.Required;

public class VersioningServiceImpl
implements VersioningService {
    private VersionHistoryDAO versionHistoryDAO;
    private VersionDAO versionDAO;
    private DefaultItemVersionProvider provider;

    @Override
    public Version createNewVersion(Context c, int itemId) {
        return this.createNewVersion(c, itemId, null);
    }

    @Override
    public Version createNewVersion(Context c, int itemId, String summary) {
        try {
            Item item = Item.find(c, itemId);
            VersionHistoryImpl vh = this.versionHistoryDAO.find(c, item.getID(), this.versionDAO);
            if (vh == null) {
                vh = this.versionHistoryDAO.create(c);
                Metadatum[] values = item.getMetadata("dc", "date", "accessioned", "*");
                Date versionDate = new Date();
                if (values != null && values.length > 0) {
                    String date = values[0].value;
                    versionDate = new DCDate(date).toDate();
                }
                this.createVersion(c, vh, item, "", versionDate);
            }
            Item itemNew = this.provider.createNewItemAndAddItInWorkspace(c, item);
            VersionImpl version = this.createVersion(c, vh, itemNew, summary, new Date());
            this.provider.updateItemState(c, itemNew, item);
            return version;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void removeVersion(Context c, int versionID) {
        VersionImpl version = this.versionDAO.find(c, versionID);
        if (version != null) {
            this.removeVersion(c, version);
        }
    }

    @Override
    public void removeVersion(Context c, Item item) {
        VersionImpl version = this.versionDAO.findByItem(c, item);
        if (version != null) {
            this.removeVersion(c, version);
        }
    }

    protected void removeVersion(Context c, Version version) {
        try {
            Collection[] collections;
            VersionHistoryImpl history = this.versionHistoryDAO.findById(c, version.getVersionHistoryID(), this.versionDAO);
            this.provider.deleteVersionedItem(c, version, history);
            this.versionDAO.delete(c, version.getVersionId());
            history.remove(version);
            if (history.isEmpty()) {
                this.versionHistoryDAO.delete(c, version.getVersionHistoryID(), this.versionDAO);
            }
            Item item = version.getItem();
            for (Collection collection : collections = item.getCollections()) {
                collection.removeItem(item);
            }
        }
        catch (Exception e) {
            c.abort();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Version getVersion(Context c, int versionID) {
        return this.versionDAO.find(c, versionID);
    }

    @Override
    public Version restoreVersion(Context c, int versionID) {
        return this.restoreVersion(c, versionID, null);
    }

    @Override
    public Version restoreVersion(Context c, int versionID, String summary) {
        return null;
    }

    @Override
    public VersionHistory findVersionHistory(Context c, int itemId) {
        return this.versionHistoryDAO.find(c, itemId, this.versionDAO);
    }

    @Override
    public Version updateVersion(Context c, int itemId, String summary) {
        VersionImpl version = this.versionDAO.findByItemId(c, itemId);
        version.setSummary(summary);
        this.versionDAO.update(version);
        return version;
    }

    @Override
    public Version getVersion(Context c, Item item) {
        return this.versionDAO.findByItemId(c, item.getID());
    }

    protected VersionImpl createVersion(Context c, VersionHistory vh, Item item, String summary, Date date) {
        try {
            VersionImpl version = this.versionDAO.create(c);
            version.setVersionNumber(this.getNextVersionNumer(vh.getLatestVersion()));
            version.setVersionDate(date);
            version.setEperson(item.getSubmitter());
            version.setItemID(item.getID());
            version.setSummary(summary);
            version.setVersionHistory(vh.getVersionHistoryId());
            this.versionDAO.update(version);
            vh.add(version);
            return version;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected int getNextVersionNumer(Version latest) {
        if (latest == null) {
            return 1;
        }
        return latest.getVersionNumber() + 1;
    }

    public VersionHistoryDAO getVersionHistoryDAO() {
        return this.versionHistoryDAO;
    }

    public void setVersionHistoryDAO(VersionHistoryDAO versionHistoryDAO) {
        this.versionHistoryDAO = versionHistoryDAO;
    }

    public VersionDAO getVersionDAO() {
        return this.versionDAO;
    }

    public void setVersionDAO(VersionDAO versionDAO) {
        this.versionDAO = versionDAO;
    }

    @Required
    public void setProvider(DefaultItemVersionProvider provider) {
        this.provider = provider;
    }
}

