/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.service.AuthorityValueService;

public class DSpaceCSVLine
implements Serializable {
    private final UUID id;
    private final Map<String, ArrayList> items;
    protected final transient AuthorityValueService authorityValueService = AuthorityServiceFactory.getInstance().getAuthorityValueService();
    private final transient Comparator<? super String> headerComparator = new Comparator<String>(){

        @Override
        public int compare(String md1, String md2) {
            AuthorityValue source1 = DSpaceCSVLine.this.authorityValueService.getAuthorityValueType(md1);
            AuthorityValue source2 = DSpaceCSVLine.this.authorityValueService.getAuthorityValueType(md2);
            int compare = source1 == null && source2 != null ? -1 : (source1 != null && source2 == null ? 1 : md1.compareTo(md2));
            return compare;
        }
    };

    public DSpaceCSVLine(UUID itemId) {
        this.id = itemId;
        this.items = new TreeMap<String, ArrayList>(this.headerComparator);
    }

    public DSpaceCSVLine() {
        this.id = null;
        this.items = new TreeMap<String, ArrayList>(this.headerComparator);
    }

    public UUID getID() {
        return this.id;
    }

    public void add(String key, String value) {
        if (this.items.get(key) == null) {
            this.items.put(key, new ArrayList());
        }
        if (value != null) {
            this.items.get(key).add(value);
        }
    }

    public List<String> get(String key) {
        return this.items.get(key);
    }

    public String getAction() {
        ArrayList actions;
        if (this.items.containsKey("action") && (actions = this.items.get("action")).size() > 0) {
            return ((String)actions.get(0)).trim();
        }
        return "";
    }

    public Set<String> keys() {
        return this.items.keySet();
    }

    protected String toCSV(List<String> headings, String fieldSeparator) {
        StringBuilder bits = new StringBuilder();
        bits.append("\"").append(this.id).append("\"").append(fieldSeparator);
        bits.append(this.valueToCSV(this.items.get("collection"), fieldSeparator));
        for (String heading : headings) {
            bits.append(fieldSeparator);
            List values = this.items.get(heading);
            if (values == null || "collection".equals(heading)) continue;
            bits.append(this.valueToCSV(values, fieldSeparator));
        }
        return bits.toString();
    }

    protected String valueToCSV(List<String> values, String valueSeparator) {
        String s;
        if (values == null) {
            return "";
        }
        if (values.size() == 1) {
            s = values.get(0);
        } else {
            StringBuilder str = new StringBuilder();
            for (String value : values) {
                if (str.length() > 0) {
                    str.append(valueSeparator);
                }
                str.append(value);
            }
            s = str.toString();
        }
        return "\"" + s.replaceAll("\"", "\"\"") + "\"";
    }
}

