/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.app.itemexport.factory.ItemExportServiceFactory;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class ItemExportCLITool {
    protected static ItemExportService itemExportService = ItemExportServiceFactory.getInstance().getItemExportService();
    protected static HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected static ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();

    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("t", "type", true, "type: COLLECTION or ITEM");
        options.addOption("i", "id", true, "ID or handle of thing to export");
        options.addOption("d", "dest", true, "destination where you want items to go");
        options.addOption("m", "migrate", false, "export for migration (remove handle and metadata that will be re-created in new system)");
        options.addOption("n", "number", true, "sequence number to begin exporting items with");
        options.addOption("z", "zip", true, "export as zip file (specify filename e.g. export.zip)");
        options.addOption("h", "help", false, "help");
        options.addOption("x", "exclude-bitstreams", false, "do not export bitstreams");
        CommandLine line = parser.parse(options, argv);
        String typeString = null;
        String destDirName = null;
        String myIDString = null;
        int seqStart = -1;
        int myType = -1;
        Item myItem = null;
        Collection mycollection = null;
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("ItemExport\n", options);
            System.out.println("\nfull collection: ItemExport -t COLLECTION -i ID -d dest -n number");
            System.out.println("singleitem:       ItemExport -t ITEM -i ID -d dest -n number");
            System.exit(0);
        }
        if (line.hasOption('t')) {
            typeString = line.getOptionValue('t');
            if ("ITEM".equals(typeString)) {
                myType = 2;
            } else if ("COLLECTION".equals(typeString)) {
                myType = 3;
            }
        }
        if (line.hasOption('i')) {
            myIDString = line.getOptionValue('i');
        }
        if (line.hasOption('d')) {
            destDirName = line.getOptionValue('d');
        }
        if (line.hasOption('n')) {
            seqStart = Integer.parseInt(line.getOptionValue('n'));
        }
        boolean migrate = false;
        if (line.hasOption('m')) {
            migrate = true;
        }
        boolean zip = false;
        String zipFileName = "";
        if (line.hasOption('z')) {
            zip = true;
            zipFileName = line.getOptionValue('z');
        }
        boolean excludeBitstreams = false;
        if (line.hasOption('x')) {
            excludeBitstreams = true;
        }
        if (myType == -1) {
            System.out.println("type must be either COLLECTION or ITEM (-h for help)");
            System.exit(1);
        }
        if (destDirName == null) {
            System.out.println("destination directory must be set (-h for help)");
            System.exit(1);
        }
        if (seqStart == -1) {
            System.out.println("sequence start number must be set (-h for help)");
            System.exit(1);
        }
        if (myIDString == null) {
            System.out.println("ID must be set to either a database ID or a handle (-h for help)");
            System.exit(1);
        }
        Context c = new Context();
        c.setIgnoreAuthorization(true);
        if (myType == 2) {
            if (myIDString.indexOf(47) != -1) {
                myItem = (Item)handleService.resolveToObject(c, myIDString);
                if (myItem == null || myItem.getType() != 2) {
                    myItem = null;
                }
            } else {
                myItem = (Item)itemService.find(c, UUID.fromString(myIDString));
            }
            if (myItem == null) {
                System.out.println("Error, item cannot be found: " + myIDString);
            }
        } else {
            if (myIDString.indexOf(47) != -1) {
                mycollection = (Collection)handleService.resolveToObject(c, myIDString);
                if (mycollection == null || mycollection.getType() != 3) {
                    mycollection = null;
                }
            } else if (myIDString != null) {
                mycollection = (Collection)collectionService.find(c, UUID.fromString(myIDString));
            }
            if (mycollection == null) {
                System.out.println("Error, collection cannot be found: " + myIDString);
                System.exit(1);
            }
        }
        if (zip) {
            Iterator<Item> items;
            if (myItem != null) {
                ArrayList<Item> myItems = new ArrayList<Item>();
                myItems.add(myItem);
                items = myItems.iterator();
            } else {
                System.out.println("Exporting from collection: " + myIDString);
                items = itemService.findByCollection(c, mycollection);
            }
            itemExportService.exportAsZip(c, items, destDirName, zipFileName, seqStart, migrate, excludeBitstreams);
        } else if (myItem != null) {
            itemExportService.exportItem(c, Collections.singletonList(myItem).iterator(), destDirName, seqStart, migrate, excludeBitstreams);
        } else {
            System.out.println("Exporting from collection: " + myIDString);
            Iterator<Item> i = itemService.findByCollection(c, mycollection);
            itemExportService.exportItem(c, i, destDirName, seqStart, migrate, excludeBitstreams);
        }
        c.complete();
    }
}

