/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.dao.ResourcePolicyDAO;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourcePolicyServiceImpl
implements ResourcePolicyService {
    private static Logger log = Logger.getLogger(ResourcePolicyServiceImpl.class);
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected ResourcePolicyDAO resourcePolicyDAO;

    protected ResourcePolicyServiceImpl() {
    }

    @Override
    public ResourcePolicy find(Context context, int id) throws SQLException {
        return (ResourcePolicy)this.resourcePolicyDAO.findByID(context, ResourcePolicy.class, id);
    }

    @Override
    public ResourcePolicy create(Context context) throws SQLException {
        ResourcePolicy resourcePolicy = this.resourcePolicyDAO.create(context, new ResourcePolicy());
        return resourcePolicy;
    }

    @Override
    public List<ResourcePolicy> find(Context c, DSpaceObject o) throws SQLException {
        return this.resourcePolicyDAO.findByDso(c, o);
    }

    @Override
    public List<ResourcePolicy> find(Context c, DSpaceObject o, String type) throws SQLException {
        return this.resourcePolicyDAO.findByDsoAndType(c, o, type);
    }

    @Override
    public List<ResourcePolicy> find(Context context, Group group) throws SQLException {
        return this.resourcePolicyDAO.findByGroup(context, group);
    }

    @Override
    public List<ResourcePolicy> find(Context c, DSpaceObject o, int actionId) throws SQLException {
        return this.resourcePolicyDAO.findByDSoAndAction(c, o, actionId);
    }

    @Override
    public List<ResourcePolicy> find(Context c, DSpaceObject dso, Group group, int action, int notPolicyID) throws SQLException {
        return this.resourcePolicyDAO.findByTypeIdGroupAction(c, dso, group, action, notPolicyID);
    }

    @Override
    public void delete(Context context, ResourcePolicy resourcePolicy) throws SQLException, AuthorizeException {
        if (resourcePolicy.getdSpaceObject() != null) {
            this.contentServiceFactory.getDSpaceObjectService(resourcePolicy.getdSpaceObject()).updateLastModified(context, resourcePolicy.getdSpaceObject());
        }
        this.resourcePolicyDAO.delete(context, resourcePolicy);
    }

    @Override
    public String getActionText(ResourcePolicy resourcePolicy) {
        int myAction = resourcePolicy.getAction();
        if (myAction == -1) {
            return "...";
        }
        return Constants.actionText[myAction];
    }

    @Override
    public boolean isDateValid(ResourcePolicy resourcePolicy) {
        Date sd = resourcePolicy.getStartDate();
        Date ed = resourcePolicy.getEndDate();
        if (sd == null && ed == null) {
            return true;
        }
        Date now = new Date();
        if (sd != null && now.before(sd)) {
            return false;
        }
        return ed == null || !now.after(ed);
    }

    @Override
    public ResourcePolicy clone(Context context, ResourcePolicy resourcePolicy) throws SQLException, AuthorizeException {
        ResourcePolicy clone = this.create(context);
        clone.setGroup(resourcePolicy.getGroup());
        clone.setEPerson(resourcePolicy.getEPerson());
        clone.setStartDate((Date)ObjectUtils.clone((Object)resourcePolicy.getStartDate()));
        clone.setEndDate((Date)ObjectUtils.clone((Object)resourcePolicy.getEndDate()));
        clone.setRpType((String)ObjectUtils.clone((Object)resourcePolicy.getRpType()));
        clone.setRpDescription((String)ObjectUtils.clone((Object)resourcePolicy.getRpDescription()));
        this.update(context, clone);
        return clone;
    }

    @Override
    public void removeAllPolicies(Context c, DSpaceObject o) throws SQLException, AuthorizeException {
        this.removeAllPolicies(c, o, true);
    }

    @Override
    public void removeAllPolicies(Context c, DSpaceObject o, boolean updateLastModified) throws SQLException, AuthorizeException {
        if (updateLastModified) {
            this.contentServiceFactory.getDSpaceObjectService(o).updateLastModified(c, o);
        }
        this.resourcePolicyDAO.deleteByDso(c, o);
    }

    @Override
    public void removePolicies(Context c, DSpaceObject o, String type) throws SQLException, AuthorizeException {
        this.contentServiceFactory.getDSpaceObjectService(o).updateLastModified(c, o);
        this.resourcePolicyDAO.deleteByDsoAndType(c, o, type);
    }

    @Override
    public void removeDsoGroupPolicies(Context context, DSpaceObject dso, Group group) throws SQLException, AuthorizeException {
        this.contentServiceFactory.getDSpaceObjectService(dso).updateLastModified(context, dso);
        this.resourcePolicyDAO.deleteByDsoGroupPolicies(context, dso, group);
    }

    @Override
    public void removeDsoEPersonPolicies(Context context, DSpaceObject dso, EPerson ePerson) throws SQLException, AuthorizeException {
        this.contentServiceFactory.getDSpaceObjectService(dso).updateLastModified(context, dso);
        this.resourcePolicyDAO.deleteByDsoEPersonPolicies(context, dso, ePerson);
    }

    @Override
    public void removeGroupPolicies(Context c, Group group) throws SQLException {
        this.resourcePolicyDAO.deleteByGroup(c, group);
    }

    @Override
    public void removePolicies(Context c, DSpaceObject o, int actionId) throws SQLException, AuthorizeException {
        if (actionId == -1) {
            this.removeAllPolicies(c, o);
        } else {
            this.contentServiceFactory.getDSpaceObjectService(o).updateLastModified(c, o);
            this.resourcePolicyDAO.deleteByDsoAndAction(c, o, actionId);
        }
    }

    @Override
    public void removeDsoAndTypeNotEqualsToPolicies(Context c, DSpaceObject o, String type) throws SQLException, AuthorizeException {
        this.contentServiceFactory.getDSpaceObjectService(o).updateLastModified(c, o);
        this.resourcePolicyDAO.deleteByDsoAndTypeNotEqualsTo(c, o, type);
    }

    @Override
    public void update(Context context, ResourcePolicy resourcePolicy) throws SQLException, AuthorizeException {
        if (resourcePolicy.getdSpaceObject() != null) {
            this.contentServiceFactory.getDSpaceObjectService(resourcePolicy.getdSpaceObject()).updateLastModified(context, resourcePolicy.getdSpaceObject());
        }
        this.resourcePolicyDAO.save(context, resourcePolicy);
    }
}

