/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.dao.ResourcePolicyDAO;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ResourcePolicyDAOImpl
extends AbstractHibernateDAO<ResourcePolicy>
implements ResourcePolicyDAO {
    protected ResourcePolicyDAOImpl() {
    }

    @Override
    public List<ResourcePolicy> findByDso(Context context, DSpaceObject dso) throws SQLException {
        Criteria criteria = this.createCriteria(context, ResourcePolicy.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"dSpaceObject", (Object)dso)}));
        return this.list(criteria);
    }

    @Override
    public List<ResourcePolicy> findByDsoAndType(Context context, DSpaceObject dso, String type) throws SQLException {
        Criteria criteria = this.createCriteria(context, ResourcePolicy.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"dSpaceObject", (Object)dso), (Criterion)Restrictions.eq((String)"rptype", (Object)type)));
        return this.list(criteria);
    }

    @Override
    public List<ResourcePolicy> findByGroup(Context context, Group group) throws SQLException {
        Criteria criteria = this.createCriteria(context, ResourcePolicy.class);
        criteria.add((Criterion)Restrictions.eq((String)"epersonGroup", (Object)group));
        return this.list(criteria);
    }

    @Override
    public List<ResourcePolicy> findByDSoAndAction(Context context, DSpaceObject dso, int actionId) throws SQLException {
        Criteria criteria = this.createCriteria(context, ResourcePolicy.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"dSpaceObject", (Object)dso), (Criterion)Restrictions.eq((String)"actionId", (Object)actionId)));
        return this.list(criteria);
    }

    @Override
    public List<ResourcePolicy> findByTypeIdGroupAction(Context context, DSpaceObject dso, Group group, int action, int notPolicyID) throws SQLException {
        Criteria criteria = this.createCriteria(context, ResourcePolicy.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"dSpaceObject", (Object)dso), Restrictions.eq((String)"epersonGroup", (Object)group), Restrictions.eq((String)"actionId", (Object)action)}));
        criteria.setMaxResults(1);
        if (notPolicyID != -1) {
            criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.not((Criterion)Restrictions.eq((String)"id", (Object)action))}));
        }
        return this.list(criteria);
    }

    @Override
    public void deleteByDso(Context context, DSpaceObject dso) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject= :dSpaceObject";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dSpaceObject", (Object)dso);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoAndAction(Context context, DSpaceObject dso, int actionId) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject= :dSpaceObject AND actionId= :actionId";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dSpaceObject", (Object)dso);
        query.setInteger("actionId", actionId);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoAndType(Context context, DSpaceObject dso, String type) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject= :dso AND rptype = :rptype";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dso", (Object)dso);
        query.setString("rptype", type);
        query.executeUpdate();
    }

    @Override
    public void deleteByGroup(Context context, Group group) throws SQLException {
        String queryString = "delete from ResourcePolicy where epersonGroup= :epersonGroup";
        Query query = this.createQuery(context, queryString);
        query.setParameter("epersonGroup", (Object)group);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoGroupPolicies(Context context, DSpaceObject dso, Group group) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject = :dso AND epersonGroup= :epersonGroup";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dso", (Object)dso);
        query.setParameter("epersonGroup", (Object)group);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoEPersonPolicies(Context context, DSpaceObject dso, EPerson ePerson) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject= :dso AND eperson= :eperson";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dso", (Object)dso);
        query.setParameter("eperson", (Object)ePerson);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoAndTypeNotEqualsTo(Context context, DSpaceObject dso, String type) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject=:dso AND rptype <> :rptype";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dso", (Object)dso);
        query.setParameter("rptype", (Object)type);
        query.executeUpdate();
    }
}

