/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountDAOFactory;
import org.dspace.browse.ItemCountException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ItemCounter {
    private static Logger log = Logger.getLogger(ItemCounter.class);
    private ItemCountDAO dao;
    private Context context;
    protected ItemService itemService;
    protected ConfigurationService configurationService;

    public ItemCounter(Context context) throws ItemCountException {
        this.context = context;
        this.dao = ItemCountDAOFactory.getInstance(this.context);
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    public int getCount(DSpaceObject dso) throws ItemCountException {
        boolean useCache = this.configurationService.getBooleanProperty("webui.strengths.cache", true);
        if (useCache) {
            return this.dao.getCount(dso);
        }
        if (dso instanceof Collection) {
            try {
                return this.itemService.countItems(this.context, (Collection)dso);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new ItemCountException(e);
            }
        }
        if (dso instanceof Community) {
            try {
                return this.itemService.countItems(this.context, (Community)dso);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new ItemCountException(e);
            }
        }
        return 0;
    }
}

