/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.checker.ChecksumResultsCollector;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;

public class ResultsLogger
implements ChecksumResultsCollector {
    private static final Logger LOG = Logger.getLogger(ResultsLogger.class);
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        }
    };
    Date startDate = null;

    private ResultsLogger() {
    }

    public ResultsLogger(Date startDt) {
        LOG.info((Object)(this.msg("run-start-time") + ": " + DATE_FORMAT.get().format(startDt)));
    }

    protected String msg(String key) {
        return I18nUtil.getMessage("org.dspace.checker.ResultsLogger." + key);
    }

    @Override
    public void collect(Context context, MostRecentChecksum info) throws SQLException {
        Bitstream bitstream = info.getBitstream();
        LOG.info((Object)"******************************************************");
        LOG.info((Object)(this.msg("bitstream-id") + ": " + bitstream.getID()));
        LOG.info((Object)(this.msg("bitstream-info-found") + ": " + info.isInfoFound()));
        LOG.info((Object)(this.msg("bitstream-marked-deleted") + ": " + bitstream.isDeleted()));
        LOG.info((Object)(this.msg("bitstream-found") + ": " + info.isBitstreamFound()));
        LOG.info((Object)(this.msg("to-be-processed") + ": " + info.isToBeProcessed()));
        LOG.info((Object)(this.msg("internal-id") + ": " + bitstream.getInternalId()));
        LOG.info((Object)(this.msg("name") + ": " + bitstream.getName()));
        LOG.info((Object)(this.msg("store-number") + ": " + bitstream.getStoreNumber()));
        LOG.info((Object)(this.msg("size") + ": " + bitstream.getSize()));
        LOG.info((Object)(this.msg("bitstream-format") + ": " + (bitstream.getFormat(context) != null ? Integer.valueOf(bitstream.getFormat(context).getID()) : "-1")));
        LOG.info((Object)(this.msg("user-format-description") + ": " + bitstream.getUserFormatDescription()));
        LOG.info((Object)(this.msg("source") + ": " + bitstream.getSource()));
        LOG.info((Object)(this.msg("checksum-algorithm") + ": " + info.getChecksumAlgorithm()));
        LOG.info((Object)(this.msg("previous-checksum") + ": " + info.getExpectedChecksum()));
        LOG.info((Object)(this.msg("previous-checksum-date") + ": " + (info.getProcessEndDate() != null ? DATE_FORMAT.get().format(info.getProcessEndDate()) : "unknown")));
        LOG.info((Object)(this.msg("new-checksum") + ": " + info.getCurrentChecksum()));
        LOG.info((Object)(this.msg("checksum-comparison-result") + ": " + (Object)((Object)info.getChecksumResult().getResultCode())));
        LOG.info((Object)"\n\n");
    }
}

