/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.dao.BitstreamFormatDAO;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamFormatServiceImpl
implements BitstreamFormatService {
    private static Logger log = Logger.getLogger(BitstreamFormat.class);
    @Autowired(required=true)
    protected BitstreamFormatDAO bitstreamFormatDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    protected final String[] supportLevelText = new String[]{"UNKNOWN", "KNOWN", "SUPPORTED"};

    protected BitstreamFormatServiceImpl() {
    }

    @Override
    public BitstreamFormat find(Context context, int id) throws SQLException {
        BitstreamFormat bitstreamFormat = (BitstreamFormat)this.bitstreamFormatDAO.findByID(context, BitstreamFormat.class, id);
        if (bitstreamFormat == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_bitstream_format", "not_found,bitstream_format_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bitstream_format", "bitstream_format_id=" + id));
        }
        return bitstreamFormat;
    }

    @Override
    public BitstreamFormat findByMIMEType(Context context, String mimeType) throws SQLException {
        return this.bitstreamFormatDAO.findByMIMEType(context, mimeType, false);
    }

    @Override
    public BitstreamFormat findByShortDescription(Context context, String desc) throws SQLException {
        return this.bitstreamFormatDAO.findByShortDescription(context, desc);
    }

    @Override
    public BitstreamFormat findUnknown(Context context) throws SQLException {
        BitstreamFormat bf = this.findByShortDescription(context, "Unknown");
        if (bf == null) {
            throw new IllegalStateException("No `Unknown' bitstream format in registry");
        }
        return bf;
    }

    @Override
    public List<BitstreamFormat> findAll(Context context) throws SQLException {
        return this.bitstreamFormatDAO.findAll(context, BitstreamFormat.class);
    }

    @Override
    public List<BitstreamFormat> findNonInternal(Context context) throws SQLException {
        return this.bitstreamFormatDAO.findNonInternal(context);
    }

    @Override
    public BitstreamFormat create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can create bitstream formats");
        }
        BitstreamFormat bitstreamFormat = this.bitstreamFormatDAO.create(context, new BitstreamFormat());
        log.info((Object)LogManager.getHeader(context, "create_bitstream_format", "bitstream_format_id=" + bitstreamFormat.getID()));
        return bitstreamFormat;
    }

    @Override
    public void setShortDescription(Context context, BitstreamFormat bitstreamFormat, String shortDescription) throws SQLException {
        BitstreamFormat unknown = null;
        try {
            unknown = this.findUnknown(context);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (unknown == null || unknown.getID() != bitstreamFormat.getID()) {
            bitstreamFormat.setShortDescriptionInternal(shortDescription);
        }
    }

    @Override
    public String getSupportLevelText(BitstreamFormat bitstreamFormat) {
        return this.supportLevelText[bitstreamFormat.getSupportLevel()];
    }

    @Override
    public void setSupportLevel(BitstreamFormat bitstreamFormat, int supportLevel) {
        if (supportLevel < 0 || supportLevel > 2) {
            throw new IllegalArgumentException("Invalid support level");
        }
        bitstreamFormat.setSupportLevelInternal(supportLevel);
    }

    @Override
    public void update(Context context, BitstreamFormat bitstreamFormat) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify bitstream formats");
        }
        log.info((Object)LogManager.getHeader(context, "update_bitstream_format", "bitstream_format_id=" + bitstreamFormat.getID()));
        this.bitstreamFormatDAO.save(context, bitstreamFormat);
    }

    @Override
    public void delete(Context context, BitstreamFormat bitstreamFormat) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can delete bitstream formats");
        }
        BitstreamFormat unknown = this.findUnknown(context);
        if (unknown.getID() == bitstreamFormat.getID()) {
            throw new IllegalArgumentException("The Unknown bitstream format may not be deleted.");
        }
        int numberChanged = this.bitstreamFormatDAO.updateRemovedBitstreamFormat(context, bitstreamFormat, unknown);
        this.bitstreamFormatDAO.delete(context, bitstreamFormat);
        log.info((Object)LogManager.getHeader(context, "delete_bitstream_format", "bitstream_format_id=" + bitstreamFormat.getID() + ",bitstreams_changed=" + numberChanged));
    }

    @Override
    public int getSupportLevelID(String supportLevel) {
        for (int i = 0; i < this.supportLevelText.length; ++i) {
            if (!this.supportLevelText[i].equals(supportLevel)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BitstreamFormat guessFormat(Context context, Bitstream bitstream) throws SQLException {
        String filename = bitstream.getName();
        if (filename == null) {
            return null;
        }
        String extension = filename = filename.toLowerCase();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot != -1) {
            extension = filename.substring(lastDot + 1);
        }
        if (extension.equals("")) {
            return null;
        }
        List<BitstreamFormat> bitstreamFormats = this.bitstreamFormatDAO.findByFileExtension(context, extension);
        if (CollectionUtils.isNotEmpty(bitstreamFormats)) {
            return bitstreamFormats.get(0);
        }
        return null;
    }
}

