/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.dao.MetadataSchemaDAO;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataSchemaServiceImpl
implements MetadataSchemaService {
    private static Logger log = Logger.getLogger(MetadataSchemaServiceImpl.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected MetadataSchemaDAO metadataSchemaDAO;

    protected MetadataSchemaServiceImpl() {
    }

    @Override
    public MetadataSchema create(Context context, String name, String namespace) throws SQLException, AuthorizeException, NonUniqueMetadataException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (!this.uniqueShortName(context, -1, name)) {
            throw new NonUniqueMetadataException("Please make the name " + name + " unique");
        }
        if (!this.uniqueNamespace(context, -1, namespace)) {
            throw new NonUniqueMetadataException("Please make the namespace " + namespace + " unique");
        }
        MetadataSchema metadataSchema = this.metadataSchemaDAO.create(context, new MetadataSchema());
        metadataSchema.setNamespace(namespace);
        metadataSchema.setName(name);
        this.metadataSchemaDAO.save(context, metadataSchema);
        log.info((Object)LogManager.getHeader(context, "create_metadata_schema", "metadata_schema_id=" + metadataSchema.getSchemaID()));
        return metadataSchema;
    }

    @Override
    public MetadataSchema findByNamespace(Context context, String namespace) throws SQLException {
        return this.metadataSchemaDAO.findByNamespace(context, namespace);
    }

    @Override
    public void update(Context context, MetadataSchema metadataSchema) throws SQLException, AuthorizeException, NonUniqueMetadataException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (!this.uniqueShortName(context, metadataSchema.getSchemaID(), metadataSchema.getName())) {
            throw new NonUniqueMetadataException("Please make the name " + metadataSchema.getName() + " unique");
        }
        if (!this.uniqueNamespace(context, metadataSchema.getSchemaID(), metadataSchema.getNamespace())) {
            throw new NonUniqueMetadataException("Please make the namespace " + metadataSchema.getNamespace() + " unique");
        }
        this.metadataSchemaDAO.save(context, metadataSchema);
        log.info((Object)LogManager.getHeader(context, "update_metadata_schema", "metadata_schema_id=" + metadataSchema.getSchemaID() + "namespace=" + metadataSchema.getNamespace() + "name=" + metadataSchema.getName()));
    }

    @Override
    public void delete(Context context, MetadataSchema metadataSchema) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        log.info((Object)LogManager.getHeader(context, "delete_metadata_schema", "metadata_schema_id=" + metadataSchema.getSchemaID()));
        this.metadataSchemaDAO.delete(context, metadataSchema);
    }

    @Override
    public List<MetadataSchema> findAll(Context context) throws SQLException {
        return this.metadataSchemaDAO.findAll(context, MetadataSchema.class);
    }

    @Override
    public MetadataSchema find(Context context, int id) throws SQLException {
        return (MetadataSchema)this.metadataSchemaDAO.findByID(context, MetadataSchema.class, id);
    }

    @Override
    public MetadataSchema find(Context context, String shortName) throws SQLException {
        if (shortName == null) {
            return null;
        }
        return this.metadataSchemaDAO.find(context, shortName);
    }

    protected boolean uniqueNamespace(Context context, int metadataSchemaId, String namespace) throws SQLException {
        return this.metadataSchemaDAO.uniqueNamespace(context, metadataSchemaId, namespace);
    }

    protected boolean uniqueShortName(Context context, int metadataSchemaId, String name) throws SQLException {
        return this.metadataSchemaDAO.uniqueShortName(context, metadataSchemaId, name);
    }
}

