/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.sql.SQLException;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class CrosswalkUtils {
    protected static final MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected static final MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();

    public static void checkMetadata(Context context, String schema, String element, String qualifier, boolean forceCreate) throws SQLException, AuthorizeException, CrosswalkException {
        MetadataField mdField;
        MetadataSchema mdSchema;
        String fieldChoice;
        String schemaChoice = ConfigurationManager.getProperty("oai", "harvester.unknownSchema");
        if (schemaChoice == null) {
            schemaChoice = "fail";
        }
        if ((fieldChoice = ConfigurationManager.getProperty("oai", "harvester.unknownField")) == null) {
            fieldChoice = "fail";
        }
        if ((mdSchema = metadataSchemaService.find(context, schema)) == null) {
            if (forceCreate && schemaChoice.equals("add")) {
                try {
                    mdSchema = metadataSchemaService.create(context, schema, String.valueOf(new Date().getTime()));
                    mdSchema.setNamespace("unknown" + mdSchema.getSchemaID());
                    metadataSchemaService.update(context, mdSchema);
                }
                catch (NonUniqueMetadataException e) {
                    e.printStackTrace();
                }
            } else if (!schemaChoice.equals("ignore")) {
                throw new CrosswalkException("The '" + schema + "' schema has not been defined in this DSpace instance. ");
            }
        }
        if (mdSchema != null && (mdField = metadataFieldService.findByElement(context, mdSchema, element, qualifier)) == null) {
            if (forceCreate && fieldChoice.equals("add")) {
                try {
                    metadataFieldService.create(context, mdSchema, element, qualifier, null);
                }
                catch (NonUniqueMetadataException e) {
                    e.printStackTrace();
                }
            } else if (!fieldChoice.equals("ignore")) {
                throw new CrosswalkException("The '" + element + "." + qualifier + "' element has not been defined in this DSpace instance. ");
            }
        }
    }
}

