/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class DIMDisseminationCrosswalk
implements DisseminationCrosswalk {
    public static final String DIM_XSD = "null";
    public static final Namespace DIM_NS = Namespace.getNamespace((String)"dim", (String)"http://www.dspace.org/xmlns/dspace/dim");
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final Namespace[] namespaces = new Namespace[]{DIM_NS};

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return DIM_NS.getURI() + " " + DIM_XSD;
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("DIMDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        List<MetadataValue> dc = this.itemService.getMetadata(item, "*", "*", "*", "*");
        Element dim = new Element("dim", DIM_NS);
        for (MetadataValue aDc : dc) {
            MetadataField metadataField = aDc.getMetadataField();
            MetadataSchema metadataSchema = metadataField.getMetadataSchema();
            Element field = new Element("field", DIM_NS);
            field.setAttribute("mdschema", metadataSchema.getName());
            field.setAttribute("element", metadataField.getElement());
            if (metadataField.getQualifier() != null) {
                field.setAttribute("qualifier", metadataField.getQualifier());
            }
            if (aDc.getLanguage() != null) {
                field.setAttribute("lang", aDc.getLanguage());
            }
            if (aDc.getValue() != null) {
                field.setText(aDc.getValue());
            }
            dim.addContent((Content)field);
        }
        return dim;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(context, dso));
        return result;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    @Override
    public boolean preferList() {
        return false;
    }
}

