/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.dao.CollectionDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;

public class CollectionDAOImpl
extends AbstractHibernateDSODAO<Collection>
implements CollectionDAO {
    protected CollectionDAOImpl() {
    }

    @Override
    public List<Collection> findAll(Context context, MetadataField order) throws SQLException {
        return this.findAll(context, order, null, null);
    }

    @Override
    public List<Collection> findAll(Context context, MetadataField order, Integer limit, Integer offset) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ").append(Collection.class.getSimpleName()).append(" FROM Collection as ").append(Collection.class.getSimpleName()).append(" ");
        this.addMetadataLeftJoin(query, Collection.class.getSimpleName(), Arrays.asList(order));
        this.addMetadataSortQuery(query, Arrays.asList(order), null);
        Query hibernateQuery = this.createQuery(context, query.toString());
        if (offset != null) {
            hibernateQuery.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            hibernateQuery.setMaxResults(limit.intValue());
        }
        hibernateQuery.setParameter(order.toString(), (Object)order.getFieldID());
        return this.list(hibernateQuery);
    }

    @Override
    public Collection findByTemplateItem(Context context, Item item) throws SQLException {
        Criteria criteria = this.createCriteria(context, Collection.class);
        criteria.add((Criterion)Restrictions.eq((String)"template_item", (Object)item));
        return (Collection)this.uniqueResult(criteria);
    }

    @Override
    public Collection findByGroup(Context context, Group group) throws SQLException {
        Criteria criteria = this.createCriteria(context, Collection.class);
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.eq((String)"workflowStep1", (Object)group), Restrictions.eq((String)"workflowStep2", (Object)group), Restrictions.eq((String)"workflowStep3", (Object)group), Restrictions.eq((String)"submitters", (Object)group), Restrictions.eq((String)"admins", (Object)group)}));
        return (Collection)this.singleResult(criteria);
    }

    @Override
    public List<Collection> findAuthorized(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        Criteria criteria = this.createCriteria(context, Collection.class);
        criteria.createAlias("resourcePolicies", "resourcePolicy");
        Disjunction actionQuery = Restrictions.or((Criterion[])new Criterion[0]);
        for (Integer action : actions) {
            actionQuery.add((Criterion)Restrictions.eq((String)"resourcePolicy.actionId", (Object)action));
        }
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"resourcePolicy.resourceTypeId", (Object)3), Restrictions.eq((String)"resourcePolicy.eperson", (Object)ePerson), actionQuery}));
        return this.list(criteria);
    }

    @Override
    public List<Collection> findAuthorizedByGroup(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select c from Collection c join c.resourcePolicies rp join rp.epersonGroup rpGroup WHERE ");
        for (int i = 0; i < actions.size(); ++i) {
            Integer action = actions.get(i);
            if (i != 0) {
                query.append(" AND ");
            }
            query.append("rp.actionId=").append(action);
        }
        query.append(" AND rp.resourceTypeId=").append(3);
        query.append(" AND rp.epersonGroup.id IN (select g.id from Group g where (from EPerson e where e.id = :eperson_id) in elements(epeople))");
        Query hibernateQuery = this.createQuery(context, query.toString());
        hibernateQuery.setParameter("eperson_id", (Object)ePerson.getID());
        return this.list(hibernateQuery);
    }

    @Override
    public List<Collection> findCollectionsWithSubscribers(Context context) throws SQLException {
        return this.list(this.createQuery(context, "SELECT DISTINCT col FROM Subscription s join  s.collection col"));
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Collection"));
    }

    @Override
    public List<Map.Entry<Collection, Long>> getCollectionsWithBitstreamSizesTotal(Context context) throws SQLException {
        String q = "select col as collection, sum(bit.sizeBytes) as totalBytes from Item i join i.collections col join i.bundles bun join bun.bitstreams bit group by col";
        Query query = this.createQuery(context, q);
        query.setResultTransformer((ResultTransformer)new BasicTransformerAdapter(){

            public Object transformTuple(Object[] tuple, String[] aliases) {
                return new AbstractMap.SimpleImmutableEntry<Collection, Long>((Collection)tuple[0], (Long)tuple[1]);
            }
        });
        return query.list();
    }
}

