/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dspace.core.DBConnection;
import org.dspace.storage.rdbms.DatabaseConfigVO;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate4.SessionFactoryUtils;

public class HibernateDBConnection
implements DBConnection<Session> {
    @Autowired(required=true)
    @Qualifier(value="sessionFactory")
    private SessionFactory sessionFactory;

    @Override
    public Session getSession() throws SQLException {
        if (!this.isTransActionAlive()) {
            this.sessionFactory.getCurrentSession().beginTransaction();
        }
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public boolean isTransActionAlive() {
        Transaction transaction = this.getTransaction();
        return transaction != null && transaction.isActive();
    }

    protected Transaction getTransaction() {
        return this.sessionFactory.getCurrentSession().getTransaction();
    }

    @Override
    public boolean isSessionAlive() {
        return this.sessionFactory.getCurrentSession() != null && this.sessionFactory.getCurrentSession().getTransaction() != null && this.sessionFactory.getCurrentSession().getTransaction().isActive();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.isTransActionAlive()) {
            this.getTransaction().rollback();
        }
    }

    @Override
    public void closeDBConnection() throws SQLException {
        if (this.sessionFactory.getCurrentSession() != null && this.sessionFactory.getCurrentSession().isOpen()) {
            this.sessionFactory.getCurrentSession().close();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.isTransActionAlive() && !this.getTransaction().wasRolledBack()) {
            this.getTransaction().commit();
        }
    }

    @Override
    public synchronized void shutdown() {
        this.sessionFactory.close();
    }

    @Override
    public String getType() {
        return ((SessionFactoryImplementor)this.sessionFactory).getDialect().toString();
    }

    @Override
    public DataSource getDataSource() {
        return SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory);
    }

    @Override
    public DatabaseConfigVO getDatabaseConfig() throws SQLException {
        DatabaseConfigVO databaseConfigVO = new DatabaseConfigVO();
        try (Connection connection = this.getDataSource().getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            databaseConfigVO.setDatabaseDriver(metaData.getDriverName());
            databaseConfigVO.setDatabaseUrl(metaData.getURL());
            databaseConfigVO.setSchema(metaData.getSchemaTerm());
            databaseConfigVO.setMaxConnections(metaData.getMaxConnections());
            databaseConfigVO.setUserName(metaData.getUserName());
        }
        return databaseConfigVO;
    }

    @Override
    public void clearCache() throws SQLException {
        this.getSession().clear();
    }
}

