/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceResourceRestrictionPlugin
implements SolrServiceIndexPlugin,
SolrServiceSearchPlugin {
    private static final Logger log = Logger.getLogger(SolrServiceResourceRestrictionPlugin.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected GroupService groupService;

    @Override
    public void additionalIndex(Context context, DSpaceObject dso, SolrInputDocument document) {
        try {
            List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, dso, 0);
            for (ResourcePolicy resourcePolicy : policies) {
                String fieldValue = resourcePolicy.getGroup() != null ? "g" + resourcePolicy.getGroup().getID() : "e" + resourcePolicy.getEPerson().getID();
                document.addField("read", (Object)fieldValue);
            }
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader(context, "Error while indexing resource policies", "DSpace object: (id " + dso.getID() + " type " + dso.getType() + ")"));
        }
    }

    @Override
    public void additionalSearchParameters(Context context, DiscoverQuery discoveryQuery, SolrQuery solrQuery) {
        try {
            if (!this.authorizeService.isAdmin(context)) {
                StringBuilder resourceQuery = new StringBuilder();
                resourceQuery.append("read:(g0");
                EPerson currentUser = context.getCurrentUser();
                if (currentUser != null) {
                    resourceQuery.append(" OR e").append(currentUser.getID());
                }
                List<Group> groups = this.groupService.allMemberGroups(context, currentUser);
                for (Group group : groups) {
                    resourceQuery.append(" OR g").append(group.getID());
                }
                resourceQuery.append(")");
                solrQuery.addFilterQuery(new String[]{resourceQuery.toString()});
            }
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader(context, "Error while adding resource policy information to query", ""), (Throwable)e);
        }
    }
}

