/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dspace.content.MetadataField;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.dao.GroupDAO;
import org.hibernate.Query;
import org.hibernate.SQLQuery;

public class GroupDAOImpl
extends AbstractHibernateDSODAO<Group>
implements GroupDAO {
    protected GroupDAOImpl() {
    }

    @Override
    public List<Group> findByMetadataField(Context context, String searchValue, MetadataField metadataField) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        String groupTableName = "g";
        queryBuilder.append("SELECT ").append(groupTableName).append(" FROM Group as ").append(groupTableName);
        this.addMetadataLeftJoin(queryBuilder, groupTableName, Collections.singletonList(metadataField));
        this.addMetadataValueWhereQuery(queryBuilder, Collections.singletonList(metadataField), "=", null);
        Query query = this.createQuery(context, queryBuilder.toString());
        query.setParameter(metadataField.toString(), (Object)metadataField.getFieldID());
        query.setParameter("queryParam", (Object)searchValue);
        return this.list(query);
    }

    @Override
    public List<Group> findAll(Context context, List<MetadataField> sortMetadataFields) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        String groupTableName = "g";
        queryBuilder.append("SELECT ").append(groupTableName).append(" FROM Group as ").append(groupTableName);
        this.addMetadataLeftJoin(queryBuilder, groupTableName, sortMetadataFields);
        this.addMetadataSortQuery(queryBuilder, sortMetadataFields, null);
        Query query = this.createQuery(context, queryBuilder.toString());
        for (MetadataField sortField : sortMetadataFields) {
            query.setParameter(sortField.toString(), (Object)sortField.getFieldID());
        }
        return this.list(query);
    }

    @Override
    public List<Group> findAll(Context context) throws SQLException {
        Query query = this.createQuery(context, "SELECT g FROM Group g ORDER BY g.name ASC");
        query.setCacheable(true);
        return this.list(query);
    }

    @Override
    public List<Group> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        Query query = this.createQuery(context, "from Group where (from EPerson e where e.id = :eperson_id) in elements(epeople)");
        query.setParameter("eperson_id", (Object)ePerson.getID());
        query.setCacheable(true);
        return this.list(query);
    }

    @Override
    public Group findByName(Context context, String name) throws SQLException {
        Query query = this.createQuery(context, "SELECT g from Group g where g.name = :name ");
        query.setParameter("name", (Object)name);
        query.setCacheable(true);
        return (Group)this.uniqueResult(query);
    }

    @Override
    public Group findByNameAndEPerson(Context context, String groupName, EPerson ePerson) throws SQLException {
        if (groupName == null || ePerson == null) {
            return null;
        }
        Query query = this.createQuery(context, "SELECT DISTINCT g FROM Group g LEFT JOIN g.epeople p WHERE g.name = :name AND (p.id = :eperson_id OR EXISTS ( SELECT 1 FROM Group2GroupCache gc JOIN gc.parent p JOIN gc.child c JOIN c.epeople cp WHERE p.id = g.id AND cp.id = :eperson_id ) )");
        query.setParameter("name", (Object)groupName);
        query.setParameter("eperson_id", (Object)ePerson.getID());
        query.setCacheable(true);
        return (Group)this.uniqueResult(query);
    }

    @Override
    public List<Group> findByNameLike(Context context, String groupName, int offset, int limit) throws SQLException {
        Query query = this.createQuery(context, "SELECT g FROM Group g WHERE lower(g.name) LIKE lower(:name)");
        query.setParameter("name", (Object)("%" + StringUtils.trimToEmpty((String)groupName) + "%"));
        if (0 <= offset) {
            query.setFirstResult(offset);
        }
        if (0 <= limit) {
            query.setMaxResults(limit);
        }
        return this.list(query);
    }

    @Override
    public int countByNameLike(Context context, String groupName) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM Group g WHERE lower(g.name) LIKE lower(:name)");
        query.setParameter("name", (Object)("%" + groupName + "%"));
        return this.count(query);
    }

    @Override
    public void delete(Context context, Group group) throws SQLException {
        SQLQuery query = this.getHibernateSession(context).createSQLQuery("DELETE FROM group2group WHERE parent_id=:groupId or child_id=:groupId");
        query.setParameter("groupId", (Object)group.getID());
        query.executeUpdate();
        super.delete(context, group);
    }

    @Override
    public List<Pair<UUID, UUID>> getGroup2GroupResults(Context context, boolean flushQueries) throws SQLException {
        Query query = this.createQuery(context, "SELECT new org.apache.commons.lang3.tuple.ImmutablePair(g.id, c.id) FROM Group g JOIN g.groups c ");
        List results = query.list();
        return results;
    }

    @Override
    public List<Group> getEmptyGroups(Context context) throws SQLException {
        return this.list(this.createQuery(context, "SELECT g from Group g where g.epeople is EMPTY"));
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Group"));
    }
}

