/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.handle.Handle;
import org.dspace.handle.dao.HandleDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class HandleDAOImpl
extends AbstractHibernateDAO<Handle>
implements HandleDAO {
    protected HandleDAOImpl() {
    }

    @Override
    public List<Handle> getHandlesByDSpaceObject(Context context, DSpaceObject dso) throws SQLException {
        Criteria criteria = this.createCriteria(context, Handle.class);
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"dso", (Object)dso)}));
        return this.list(criteria);
    }

    @Override
    public Handle findByHandle(Context context, String handle) throws SQLException {
        Criteria criteria = this.createCriteria(context, Handle.class);
        criteria.add((Criterion)Restrictions.eq((String)"handle", (Object)handle));
        return (Handle)this.uniqueResult(criteria);
    }

    @Override
    public List<Handle> findByPrefix(Context context, String prefix) throws SQLException {
        Criteria criteria = this.createCriteria(context, Handle.class);
        criteria.add((Criterion)Restrictions.like((String)"handle", (Object)(prefix + "%")));
        return this.list(criteria);
    }

    @Override
    public long countHandlesByPrefix(Context context, String prefix) throws SQLException {
        Criteria criteria = this.createCriteria(context, Handle.class);
        criteria.add((Criterion)Restrictions.like((String)"handle", (Object)(prefix + "%")));
        return this.countLong(criteria);
    }

    @Override
    public int updateHandlesWithNewPrefix(Context context, String newPrefix, String oldPrefix) throws SQLException {
        String hql = "UPDATE handle set handle = concat(:newPrefix,'/',id WHERE handle like :oldPrefix%";
        Query query = this.createQuery(context, hql);
        query.setString("newPrefix", newPrefix);
        query.setString("oldPrefix", oldPrefix);
        return query.executeUpdate();
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Handle"));
    }
}

