/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.dspace.content.Item;

@Entity
@Table(name="harvested_item")
public class HarvestedItem {
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="harvested_item_seq")
    @SequenceGenerator(name="harvested_item_seq", sequenceName="harvested_item_seq", allocationSize=1)
    private int id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id", unique=true)
    private Item item;
    @Column(name="last_harvested", columnDefinition="timestamp with time zone")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastHarvested;
    @Column(name="oai_id")
    private String oaiId;

    protected HarvestedItem() {
    }

    public int getId() {
        return this.id;
    }

    void setItem(Item item) {
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    void setOaiId(String oaiId) {
        this.oaiId = oaiId;
    }

    public String getOaiID() {
        return this.oaiId;
    }

    public void setOaiID(String itemOaiID) {
        this.oaiId = itemOaiID;
    }

    public void setHarvestDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.lastHarvested = date;
    }

    public Date getHarvestDate() {
        return this.lastHarvested;
    }
}

