/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.health;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.dspace.core.ConfigurationManager;
import org.dspace.health.Check;
import org.dspace.health.ReportInfo;
import org.dspace.storage.bitstore.DSBitStoreService;
import org.dspace.utils.DSpace;

public class InfoCheck
extends Check {
    @Override
    public String run(ReportInfo ri) {
        StringBuilder sb = new StringBuilder();
        sb.append("Generated: ").append(new Date().toString()).append("\n");
        sb.append("From - Till: ").append(new SimpleDateFormat("yyyy-MM-dd").format(ri.from().getTime())).append(" - ").append(new SimpleDateFormat("yyyy-MM-dd").format(ri.till().getTime())).append("\n");
        sb.append("Url: ").append(ConfigurationManager.getProperty("dspace.url")).append("\n");
        sb.append("\n");
        DSBitStoreService localStore = (DSBitStoreService)new DSpace().getServiceManager().getServicesByType(DSBitStoreService.class).get(0);
        for (String[] ss : new String[][]{{localStore.getBaseDir().toString(), "Assetstore size"}, {ConfigurationManager.getProperty("search.dir"), "Search dir size"}, {ConfigurationManager.getProperty("log.dir"), "Log dir size"}}) {
            try {
                File dir = new File(ss[0]);
                if (dir.exists()) {
                    long dir_size = FileUtils.sizeOfDirectory((File)dir);
                    sb.append(String.format("%-20s: %s\n", ss[1], FileUtils.byteCountToDisplaySize((long)dir_size)));
                    continue;
                }
                sb.append(String.format("Directory [%s] does not exist!\n", ss[0]));
            }
            catch (Exception e) {
                this.error(e, "directory - " + ss[0]);
            }
        }
        return sb.toString();
    }
}

