/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.dspace.content.DSpaceObject;
import org.dspace.identifier.Identifier;

@Entity
@Table(name="Doi")
public class DOI
implements Identifier {
    public static final String SCHEME = "doi:";
    public static final String RESOLVER = "http://dx.doi.org";
    @Id
    @Column(name="doi_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="doi_seq")
    @SequenceGenerator(name="doi_seq", sequenceName="doi_seq", allocationSize=1)
    private Integer id;
    @Column(name="doi", unique=true, length=256)
    private String doi;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="dspace_object")
    private DSpaceObject dSpaceObject;
    @Column(name="resource_type_id")
    private Integer resourceTypeId;
    @Column(name="status")
    private Integer status;

    protected DOI() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getDoi() {
        return this.doi;
    }

    public void setDoi(String doi) {
        this.doi = doi;
    }

    public DSpaceObject getDSpaceObject() {
        return this.dSpaceObject;
    }

    public void setDSpaceObject(DSpaceObject dSpaceObject) {
        this.dSpaceObject = dSpaceObject;
        if (dSpaceObject != null) {
            this.resourceTypeId = dSpaceObject.getType();
        }
    }

    public Integer getResourceTypeId() {
        return this.resourceTypeId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}

