/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.doi.DOIConnector;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class VersionedDOIIdentifierProvider
extends DOIIdentifierProvider {
    private static Logger log = Logger.getLogger(VersionedDOIIdentifierProvider.class);
    protected DOIConnector connector;
    static final char DOT = '.';
    protected static final String pattern = "\\d+\\" + String.valueOf('.') + "\\d+";
    @Autowired(required=true)
    protected VersioningService versioningService;
    @Autowired(required=true)
    protected VersionHistoryService versionHistoryService;

    @Override
    public String mint(Context context, DSpaceObject dso) throws IdentifierException {
        if (!(dso instanceof Item)) {
            throw new IdentifierException("Currently only Items are supported for DOIs.");
        }
        Item item = (Item)dso;
        VersionHistory history = null;
        try {
            history = this.versionHistoryService.findByItem(context, item);
        }
        catch (SQLException ex) {
            throw new RuntimeException("A problem occured while accessing the database.", ex);
        }
        String doi = null;
        try {
            doi = this.getDOIByObject(context, dso);
            if (doi != null) {
                return doi;
            }
        }
        catch (SQLException ex) {
            log.error((Object)("Error while attemping to retrieve information about a DOI for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + "."), (Throwable)ex);
            throw new RuntimeException("Error while attempting to retrieve information about a DOI for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", ex);
        }
        String metadataDOI = this.getDOIOutOfObject(dso);
        if (metadataDOI != null) {
            int versionNumber;
            String bareDOI = this.getBareDOI(metadataDOI);
            try {
                versionNumber = this.versionHistoryService.getVersion(context, history, item).getVersionNumber();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            String versionedDOI = bareDOI;
            if (versionNumber > 1) {
                versionedDOI = bareDOI.concat(String.valueOf('.')).concat(String.valueOf(versionNumber));
            }
            if (!metadataDOI.equalsIgnoreCase(versionedDOI)) {
                log.debug((Object)("Will remove DOI " + metadataDOI + " from item metadata, as it should become " + versionedDOI + "."));
                try {
                    this.removePreviousVersionDOIsOutOfObject(context, item, metadataDOI);
                }
                catch (AuthorizeException ex) {
                    throw new RuntimeException("Trying to remove an old DOI from a versioned item, but wasn't authorized to.", ex);
                }
            }
            log.debug((Object)("DOI " + doi + " matches version number " + versionNumber + "."));
            try {
                this.loadOrCreateDOI(context, dso, versionedDOI);
            }
            catch (SQLException ex) {
                log.error((Object)("A problem with the database connection occurd while processing DOI " + versionedDOI + "."), (Throwable)ex);
                throw new RuntimeException("A problem with the database connection occured.", ex);
            }
            return versionedDOI;
        }
        try {
            doi = history != null ? this.makeIdentifierBasedOnHistory(context, dso, history) : this.loadOrCreateDOI(context, dso, null).getDoi();
        }
        catch (SQLException ex) {
            log.error((Object)"SQLException while creating a new DOI: ", (Throwable)ex);
            throw new IdentifierException(ex);
        }
        catch (AuthorizeException ex) {
            log.error((Object)"AuthorizationException while creating a new DOI: ", (Throwable)ex);
            throw new IdentifierException(ex);
        }
        return doi;
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        if (!(dso instanceof Item)) {
            throw new IdentifierException("Currently only Items are supported for DOIs.");
        }
        Item item = (Item)dso;
        if (StringUtils.isEmpty((String)identifier)) {
            identifier = this.mint(context, dso);
        }
        String doiIdentifier = this.doiService.formatIdentifier(identifier);
        DOI doi = null;
        try {
            doi = this.loadOrCreateDOI(context, dso, doiIdentifier);
        }
        catch (SQLException ex) {
            log.error((Object)("Error in databse connection: " + ex.getMessage()), (Throwable)ex);
            throw new RuntimeException("Error in database conncetion.", ex);
        }
        if (DELETED.equals(doi.getStatus()) || TO_BE_DELETED.equals(doi.getStatus())) {
            throw new DOIIdentifierException("You tried to register a DOI that is marked as DELETED.", 13);
        }
        if (IS_REGISTERED.equals(doi.getStatus())) {
            return;
        }
        String metadataDOI = this.getDOIOutOfObject(dso);
        if (!StringUtils.isEmpty((String)metadataDOI) && !metadataDOI.equalsIgnoreCase(doiIdentifier)) {
            try {
                this.removePreviousVersionDOIsOutOfObject(context, item, metadataDOI);
            }
            catch (AuthorizeException ex) {
                throw new RuntimeException("Trying to remove an old DOI from a versioned item, but wasn't authorized to.", ex);
            }
        }
        doi.setStatus(TO_BE_REGISTERED);
        try {
            this.doiService.update(context, doi);
        }
        catch (SQLException ex) {
            log.warn((Object)"SQLException while changing status of DOI {} to be registered.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected String getBareDOI(String identifier) throws DOIIdentifierException {
        this.doiService.formatIdentifier(identifier);
        String doiPrefix = "doi:".concat(this.getPrefix()).concat(String.valueOf('/')).concat(this.getNamespaceSeparator());
        String doiPostfix = identifier.substring(doiPrefix.length());
        if (doiPostfix.matches(pattern) && doiPostfix.lastIndexOf(46) != -1) {
            return doiPrefix.concat(doiPostfix.substring(0, doiPostfix.lastIndexOf(46)));
        }
        return identifier;
    }

    protected String getDOIPostfix(String identifier) throws DOIIdentifierException {
        String doiPrefix = "doi:".concat(this.getPrefix()).concat(String.valueOf('/')).concat(this.getNamespaceSeparator());
        String doiPostfix = null;
        if (null != identifier) {
            doiPostfix = identifier.substring(doiPrefix.length());
        }
        return doiPostfix;
    }

    protected String makeIdentifierBasedOnHistory(Context context, DSpaceObject dso, VersionHistory history) throws AuthorizeException, SQLException, DOIIdentifierException {
        Version v;
        if (!(dso instanceof Item)) {
            throw new IllegalArgumentException("Cannot create versioned handle for objects other then item: Currently versioning supports items only.");
        }
        Item item = (Item)dso;
        Version version = this.versionHistoryService.getVersion(context, history, item);
        String previousVersionDOI = null;
        Iterator<Version> i$ = this.versioningService.getVersionsByHistory(context, history).iterator();
        while (i$.hasNext() && null == (previousVersionDOI = this.getDOIByObject(context, (v = i$.next()).getItem()))) {
        }
        if (previousVersionDOI == null) {
            DOI doi = this.doiService.create(context);
            String identifier = this.getPrefix() + "/" + this.getNamespaceSeparator() + doi.getId().toString();
            if (version.getVersionNumber() > 1) {
                identifier.concat(String.valueOf('.').concat(String.valueOf(version.getVersionNumber())));
            }
            doi.setDoi(identifier);
            doi.setDSpaceObject(dso);
            doi.setStatus(null);
            this.doiService.update(context, doi);
            return doi.getDoi();
        }
        assert (previousVersionDOI != null);
        String identifier = this.getBareDOI(previousVersionDOI);
        if (version.getVersionNumber() > 1) {
            identifier = identifier.concat(String.valueOf('.')).concat(String.valueOf(this.versionHistoryService.getVersion(context, history, item).getVersionNumber()));
        }
        this.loadOrCreateDOI(context, dso, identifier);
        return identifier;
    }

    void removePreviousVersionDOIsOutOfObject(Context c, Item item, String oldDoi) throws IdentifierException, AuthorizeException {
        if (StringUtils.isEmpty((String)oldDoi)) {
            throw new IllegalArgumentException("Old DOI must be neither empty nor null!");
        }
        String bareDoi = this.getBareDOI(this.doiService.formatIdentifier(oldDoi));
        String bareDoiRef = this.doiService.DOIToExternalForm(bareDoi);
        List<MetadataValue> identifiers = this.itemService.getMetadata(item, "dc", "identifier", "uri", "*");
        ArrayList<String> newIdentifiers = new ArrayList<String>(identifiers.size());
        boolean changed = false;
        for (MetadataValue identifier : identifiers) {
            if (!StringUtils.startsWithIgnoreCase((String)identifier.getValue(), (String)bareDoiRef)) {
                newIdentifiers.add(identifier.getValue());
                continue;
            }
            changed = true;
        }
        if (changed) {
            try {
                this.itemService.clearMetadata(c, item, "dc", "identifier", "uri", "*");
                this.itemService.addMetadata(c, item, "dc", "identifier", "uri", null, newIdentifiers);
                this.itemService.update(c, item);
            }
            catch (SQLException ex) {
                throw new RuntimeException("A problem with the database connection occured.", ex);
            }
        }
    }

    @Override
    @Required
    public void setDOIConnector(DOIConnector connector) {
        super.setDOIConnector(connector);
        this.connector = connector;
    }

    @Override
    @Required
    public void setConfigurationService(ConfigurationService configurationService) {
        super.setConfigurationService(configurationService);
        this.configurationService = configurationService;
    }
}

