/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.doi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.ParameterizedDisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.doi.DOIConnector;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.services.ConfigurationService;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class DataCiteConnector
implements DOIConnector {
    private static final Logger log = LoggerFactory.getLogger(DataCiteConnector.class);
    static final String CFG_USER = "identifier.doi.user";
    static final String CFG_PASSWORD = "identifier.doi.password";
    private static final String CFG_PREFIX = "identifier.doi.prefix";
    private static final String CFG_PUBLISHER = "crosswalk.dissemination.DataCite.publisher";
    private static final String CFG_DATAMANAGER = "crosswalk.dissemination.DataCite.dataManager";
    private static final String CFG_HOSTINGINSTITUTION = "crosswalk.dissemination.DataCite.hostingInstitution";
    protected String SCHEME;
    protected String HOST;
    protected String DOI_PATH;
    protected String METADATA_PATH;
    protected String CROSSWALK_NAME;
    protected ParameterizedDisseminationCrosswalk xwalk = null;
    protected ConfigurationService configurationService;
    protected String USERNAME = null;
    protected String PASSWORD = null;
    @Autowired
    protected HandleService handleService;

    @Required
    public void setDATACITE_SCHEME(String DATACITE_SCHEME) {
        this.SCHEME = DATACITE_SCHEME;
    }

    @Required
    public void setDATACITE_HOST(String DATACITE_HOST) {
        this.HOST = DATACITE_HOST;
    }

    @Required
    public void setDATACITE_DOI_PATH(String DATACITE_DOI_PATH) {
        if (!DATACITE_DOI_PATH.startsWith("/")) {
            DATACITE_DOI_PATH = "/" + DATACITE_DOI_PATH;
        }
        if (!DATACITE_DOI_PATH.endsWith("/")) {
            DATACITE_DOI_PATH = DATACITE_DOI_PATH + "/";
        }
        this.DOI_PATH = DATACITE_DOI_PATH;
    }

    @Required
    public void setDATACITE_METADATA_PATH(String DATACITE_METADATA_PATH) {
        if (!DATACITE_METADATA_PATH.startsWith("/")) {
            DATACITE_METADATA_PATH = "/" + DATACITE_METADATA_PATH;
        }
        if (!DATACITE_METADATA_PATH.endsWith("/")) {
            DATACITE_METADATA_PATH = DATACITE_METADATA_PATH + "/";
        }
        this.METADATA_PATH = DATACITE_METADATA_PATH;
    }

    @Autowired
    @Required
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Required
    public void setDisseminationCrosswalkName(String CROSSWALK_NAME) {
        this.CROSSWALK_NAME = CROSSWALK_NAME;
    }

    protected void prepareXwalk() {
        if (null != this.xwalk) {
            return;
        }
        this.xwalk = (ParameterizedDisseminationCrosswalk)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(DisseminationCrosswalk.class, this.CROSSWALK_NAME);
        if (this.xwalk == null) {
            throw new RuntimeException("Can't find crosswalk '" + this.CROSSWALK_NAME + "'!");
        }
    }

    protected String getUsername() {
        if (null == this.USERNAME) {
            this.USERNAME = this.configurationService.getProperty(CFG_USER);
            if (null == this.USERNAME) {
                throw new RuntimeException("Unable to load username from configuration. Cannot find property identifier.doi.user.");
            }
        }
        return this.USERNAME;
    }

    protected String getPassword() {
        if (null == this.PASSWORD) {
            this.PASSWORD = this.configurationService.getProperty(CFG_PASSWORD);
            if (null == this.PASSWORD) {
                throw new RuntimeException("Unable to load password from configuration. Cannot find property identifier.doi.password.");
            }
        }
        return this.PASSWORD;
    }

    @Override
    public boolean isDOIReserved(Context context, String doi) throws DOIIdentifierException {
        DataCiteResponse resp = this.sendMetadataGetRequest(doi);
        switch (resp.getStatusCode()) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
            case 410: {
                return true;
            }
        }
        log.warn("While checking if the DOI {} is registered, we got a http status code {} and the message \"{}\".", (Object[])new String[]{doi, Integer.toString(resp.statusCode), resp.getContent()});
        throw new DOIIdentifierException("Unable to parse an answer from DataCite API. Please have a look into DSpace logs.", 4);
    }

    @Override
    public boolean isDOIRegistered(Context context, String doi) throws DOIIdentifierException {
        DataCiteResponse response = this.sendDOIGetRequest(doi);
        switch (response.getStatusCode()) {
            case 200: {
                return true;
            }
            case 204: {
                return false;
            }
            case 404: {
                return false;
            }
        }
        log.warn("While checking if the DOI {} is registered, we got a http status code {} and the message \"{}\".", (Object[])new String[]{doi, Integer.toString(response.statusCode), response.getContent()});
        throw new DOIIdentifierException("Unable to parse an answer from DataCite API. Please have a look into DSpace logs.", 4);
    }

    @Override
    public void deleteDOI(Context context, String doi) throws DOIIdentifierException {
        if (!this.isDOIReserved(context, doi)) {
            return;
        }
        DataCiteResponse resp = this.sendMetadataDeleteRequest(doi);
        switch (resp.getStatusCode()) {
            case 200: {
                return;
            }
            case 404: {
                log.error("DOI {} is at least reserved, but a delete request told us that it is unknown!", (Object)doi);
                return;
            }
        }
        log.warn("While deleting metadata of DOI {}, we got a http status code {} and the message \"{}\".", (Object[])new String[]{doi, Integer.toString(resp.statusCode), resp.getContent()});
        throw new DOIIdentifierException("Unable to parse an answer from DataCite API. Please have a look into DSpace logs.", 4);
    }

    @Override
    public void reserveDOI(Context context, DSpaceObject dso, String doi) throws DOIIdentifierException {
        this.prepareXwalk();
        DSpaceObjectService<DSpaceObject> dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(dso);
        if (!this.xwalk.canDisseminate(dso)) {
            log.error("Crosswalk " + this.CROSSWALK_NAME + " cannot disseminate DSO with type " + dso.getType() + " and ID " + dso.getID() + ". Giving up reserving the DOI " + doi + ".");
            throw new DOIIdentifierException("Cannot disseminate " + dSpaceObjectService.getTypeText(dso) + "/" + dso.getID() + " using crosswalk " + this.CROSSWALK_NAME + ".", 9);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.configurationService.hasProperty(CFG_PREFIX)) {
            parameters.put("prefix", this.configurationService.getProperty(CFG_PREFIX));
        }
        if (this.configurationService.hasProperty(CFG_PUBLISHER)) {
            parameters.put("publisher", this.configurationService.getProperty(CFG_PUBLISHER));
        }
        if (this.configurationService.hasProperty(CFG_DATAMANAGER)) {
            parameters.put("datamanager", this.configurationService.getProperty(CFG_DATAMANAGER));
        }
        if (this.configurationService.hasProperty(CFG_HOSTINGINSTITUTION)) {
            parameters.put("hostinginstitution", this.configurationService.getProperty(CFG_HOSTINGINSTITUTION));
        }
        Element root = null;
        try {
            root = this.xwalk.disseminateElement(context, dso, parameters);
        }
        catch (AuthorizeException ae) {
            log.error("Caught an AuthorizeException while disseminating DSO with type " + dso.getType() + " and ID " + dso.getID() + ". Giving up to reserve DOI " + doi + ".", (Throwable)ae);
            throw new DOIIdentifierException("AuthorizeException occured while converting " + dSpaceObjectService.getTypeText(dso) + "/" + dso.getID() + " using crosswalk " + this.CROSSWALK_NAME + ".", ae, 9);
        }
        catch (CrosswalkException ce) {
            log.error("Caught an CrosswalkException while reserving a DOI (" + doi + ") for DSO with type " + dso.getType() + " and ID " + dso.getID() + ". Won't reserve the doi.", (Throwable)ce);
            throw new DOIIdentifierException("CrosswalkException occured while converting " + dSpaceObjectService.getTypeText(dso) + "/" + dso.getID() + " using crosswalk " + this.CROSSWALK_NAME + ".", ce, 9);
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
        String metadataDOI = this.extractDOI(root);
        if (null == metadataDOI) {
            root = this.addDOI(doi, root);
        } else if (!metadataDOI.equals(doi.substring("doi:".length()))) {
            log.error("While reserving a DOI, the crosswalk to generate the metadata used another DOI than the DOI we're reserving. Cannot reserve DOI " + doi + " for " + dSpaceObjectService.getTypeText(dso) + " " + dso.getID() + ".");
            throw new IllegalStateException("An internal error occured while generating the metadata. Unable to reserve doi, see logs for further information.");
        }
        DataCiteResponse resp = this.sendMetadataPostRequest(doi, root);
        switch (resp.getStatusCode()) {
            case 201: {
                return;
            }
            case 400: {
                log.warn("DataCite was unable to understand the XML we send.");
                log.warn("DataCite Metadata API returned a http status code 400: " + resp.getContent());
                Format format = Format.getCompactFormat();
                format.setEncoding("UTF-8");
                XMLOutputter xout = new XMLOutputter(format);
                log.info("We send the following XML:\n" + xout.outputString(root));
                throw new DOIIdentifierException("Unable to reserve DOI " + doi + ". Please inform your administrator or take a look " + " into the log files.", 5);
            }
        }
        log.warn("While reserving the DOI {}, we got a http status code {} and the message \"{}\".", (Object[])new String[]{doi, Integer.toString(resp.statusCode), resp.getContent()});
        throw new DOIIdentifierException("Unable to parse an answer from DataCite API. Please have a look into DSpace logs.", 4);
    }

    @Override
    public void registerDOI(Context context, DSpaceObject dso, String doi) throws DOIIdentifierException {
        if (!this.isDOIReserved(context, doi)) {
            throw new DOIIdentifierException("You need to reserve a DOI before you can register it.", 6);
        }
        DataCiteResponse resp = null;
        try {
            resp = this.sendDOIPostRequest(doi, this.handleService.resolveToURL(context, dso.getHandle()));
        }
        catch (SQLException e) {
            log.error("Caught SQL-Exception while resolving handle to URL: " + e.getMessage());
            throw new RuntimeException(e);
        }
        switch (resp.statusCode) {
            case 201: {
                return;
            }
            case 400: {
                log.warn("We send an irregular request to DataCite. While registering a DOI they told us: " + resp.getContent());
                throw new DOIIdentifierException("Currently we cannot register DOIs. Please inform the administrator or take a look  in the DSpace log file.", 5);
            }
            case 412: {
                log.error("We tried to register a DOI {} that was not reserved before! The registration agency told us: {}.", (Object)doi, (Object)resp.getContent());
                throw new DOIIdentifierException("There was an error in handling of DOIs. The DOI we wanted to register had not been reserved in advance. Please contact the administrator or take a look in DSpace log file.", 6);
            }
        }
        log.warn("While registration of DOI {}, we got a http status code {} and the message \"{}\".", (Object[])new String[]{doi, Integer.toString(resp.statusCode), resp.getContent()});
        throw new DOIIdentifierException("Unable to parse an answer from DataCite API. Please have a look into DSpace logs.", 4);
    }

    @Override
    public void updateMetadata(Context context, DSpaceObject dso, String doi) throws DOIIdentifierException {
        this.reserveDOI(context, dso, doi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataCiteResponse sendDOIPostRequest(String doi, String url) throws DOIIdentifierException {
        DataCiteResponse dataCiteResponse;
        URIBuilder uribuilder = new URIBuilder();
        uribuilder.setScheme(this.SCHEME).setHost(this.HOST).setPath(this.DOI_PATH);
        HttpPost httppost = null;
        try {
            httppost = new HttpPost(uribuilder.build());
        }
        catch (URISyntaxException e) {
            log.error("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!");
            log.error("The URL was {}.", (Object)(this.SCHEME + "://" + this.HOST + this.DOI_PATH + "/" + doi.substring("doi:".length())));
            throw new RuntimeException("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!", e);
        }
        StringEntity reqEntity = null;
        try {
            String req = "doi=" + doi.substring("doi:".length()) + "\n" + "url=" + url + "\n";
            ContentType contentType = ContentType.create((String)"text/plain", (String)"UTF-8");
            reqEntity = new StringEntity(req, contentType);
            httppost.setEntity((HttpEntity)reqEntity);
            dataCiteResponse = this.sendHttpRequest((HttpUriRequest)httppost, doi);
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume(reqEntity);
            }
            catch (IOException ioe) {
                log.info("Caught an IOException while releasing a HTTPEntity:" + ioe.getMessage());
            }
            throw throwable;
        }
        try {
            EntityUtils.consume((HttpEntity)reqEntity);
        }
        catch (IOException ioe) {
            log.info("Caught an IOException while releasing a HTTPEntity:" + ioe.getMessage());
        }
        return dataCiteResponse;
    }

    protected DataCiteResponse sendMetadataDeleteRequest(String doi) throws DOIIdentifierException {
        URIBuilder uribuilder = new URIBuilder();
        uribuilder.setScheme(this.SCHEME).setHost(this.HOST).setPath(this.METADATA_PATH + doi.substring("doi:".length()));
        HttpDelete httpdelete = null;
        try {
            httpdelete = new HttpDelete(uribuilder.build());
        }
        catch (URISyntaxException e) {
            log.error("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!");
            log.error("The URL was {}.", (Object)(this.SCHEME + "://" + this.HOST + this.DOI_PATH + "/" + doi.substring("doi:".length())));
            throw new RuntimeException("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!", e);
        }
        return this.sendHttpRequest((HttpUriRequest)httpdelete, doi);
    }

    protected DataCiteResponse sendDOIGetRequest(String doi) throws DOIIdentifierException {
        return this.sendGetRequest(doi, this.DOI_PATH);
    }

    protected DataCiteResponse sendMetadataGetRequest(String doi) throws DOIIdentifierException {
        return this.sendGetRequest(doi, this.METADATA_PATH);
    }

    protected DataCiteResponse sendGetRequest(String doi, String path) throws DOIIdentifierException {
        URIBuilder uribuilder = new URIBuilder();
        uribuilder.setScheme(this.SCHEME).setHost(this.HOST).setPath(path + doi.substring("doi:".length()));
        HttpGet httpget = null;
        try {
            httpget = new HttpGet(uribuilder.build());
        }
        catch (URISyntaxException e) {
            log.error("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!");
            log.error("The URL was {}.", (Object)(this.SCHEME + "://" + this.HOST + this.DOI_PATH + "/" + doi.substring("doi:".length())));
            throw new RuntimeException("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!", e);
        }
        return this.sendHttpRequest((HttpUriRequest)httpget, doi);
    }

    protected DataCiteResponse sendMetadataPostRequest(String doi, Element metadataRoot) throws DOIIdentifierException {
        Format format = Format.getCompactFormat();
        format.setEncoding("UTF-8");
        XMLOutputter xout = new XMLOutputter(format);
        return this.sendMetadataPostRequest(doi, xout.outputString(new Document(metadataRoot)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataCiteResponse sendMetadataPostRequest(String doi, String metadata) throws DOIIdentifierException {
        DataCiteResponse dataCiteResponse;
        URIBuilder uribuilder = new URIBuilder();
        uribuilder.setScheme(this.SCHEME).setHost(this.HOST).setPath(this.METADATA_PATH);
        HttpPost httppost = null;
        try {
            httppost = new HttpPost(uribuilder.build());
        }
        catch (URISyntaxException e) {
            log.error("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!");
            log.error("The URL was {}.", (Object)(this.SCHEME + "://" + this.HOST + this.DOI_PATH + "/" + doi.substring("doi:".length())));
            throw new RuntimeException("The URL we constructed to check a DOI produced a URISyntaxException. Please check the configuration parameters!", e);
        }
        StringEntity reqEntity = null;
        try {
            ContentType contentType = ContentType.create((String)"application/xml", (String)"UTF-8");
            reqEntity = new StringEntity(metadata, contentType);
            httppost.setEntity((HttpEntity)reqEntity);
            dataCiteResponse = this.sendHttpRequest((HttpUriRequest)httppost, doi);
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume(reqEntity);
            }
            catch (IOException ioe) {
                log.info("Caught an IOException while releasing an HTTPEntity:" + ioe.getMessage());
            }
            throw throwable;
        }
        try {
            EntityUtils.consume((HttpEntity)reqEntity);
        }
        catch (IOException ioe) {
            log.info("Caught an IOException while releasing an HTTPEntity:" + ioe.getMessage());
        }
        return dataCiteResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataCiteResponse sendHttpRequest(HttpUriRequest req, String doi) throws DOIIdentifierException {
        DataCiteResponse dataCiteResponse;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getCredentialsProvider().setCredentials(new AuthScope(this.HOST, 443), (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
        HttpEntity entity = null;
        try {
            CloseableHttpResponse response = httpclient.execute(req);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            String content = null;
            entity = response.getEntity();
            if (null != entity) {
                content = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            switch (statusCode) {
                case 401: {
                    log.info("We were unable to authenticate against the DOI registry agency.");
                    log.info("The response was: {}", (Object)content);
                    throw new DOIIdentifierException("Cannot authenticate at the DOI registry agency. Please check if username and password are set correctly.", 7);
                }
                case 403: {
                    log.info("Managing a DOI ({}) was prohibited by the DOI registration agency: {}", (Object)doi, (Object)content);
                    throw new DOIIdentifierException("We can check, register or reserve DOIs that belong to us only.", 3);
                }
                case 500: {
                    log.warn("Caught an http status code 500 while managing DOI {}. Message was: " + content);
                    throw new DOIIdentifierException("DataCite API has an internal error. It is temporarily impossible to manage DOIs. Further information can be found in DSpace log file.", 8);
                }
            }
            dataCiteResponse = new DataCiteResponse(statusCode, content);
        }
        catch (IOException e) {
            try {
                log.warn("Caught an IOException: " + e.getMessage());
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (null == entity) throw throwable;
                    EntityUtils.consume(entity);
                    throw throwable;
                }
                catch (IOException e2) {
                    log.warn("Can't release HTTP-Entity: " + e2.getMessage());
                }
                throw throwable;
            }
        }
        try {
            if (null == entity) return dataCiteResponse;
            EntityUtils.consume((HttpEntity)entity);
            return dataCiteResponse;
        }
        catch (IOException e) {
            log.warn("Can't release HTTP-Entity: " + e.getMessage());
        }
        return dataCiteResponse;
    }

    protected String extractAlternateIdentifier(Context context, String content) throws SQLException, DOIIdentifierException {
        if (content == null) {
            return null;
        }
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = null;
        try {
            doc = saxBuilder.build((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Got an IOException while reading from a string?!", ioe);
        }
        catch (JDOMException jde) {
            throw new DOIIdentifierException("Got a JDOMException while parsing a response from the DataCite API.", jde, 4);
        }
        String handle = null;
        Iterator it = doc.getDescendants((Filter)new ElementFilter("alternateIdentifier"));
        while (handle == null && it.hasNext()) {
            Element alternateIdentifier = (Element)it.next();
            handle = this.handleService.resolveUrlToHandle(context, alternateIdentifier.getText());
        }
        return handle;
    }

    protected String extractDOI(Element root) {
        Element doi = root.getChild("identifier", root.getNamespace());
        return null == doi ? null : doi.getTextTrim();
    }

    protected Element addDOI(String doi, Element root) {
        if (null != this.extractDOI(root)) {
            return root;
        }
        Element identifier = new Element("identifier", "http://datacite.org/schema/kernel-3");
        identifier.setAttribute("identifierType", "DOI");
        identifier.addContent(doi.substring("doi:".length()));
        return root.addContent(0, (Content)identifier);
    }

    protected class DataCiteResponse {
        private final int statusCode;
        private final String content;

        protected DataCiteResponse(int statusCode, String content) {
            this.statusCode = statusCode;
            this.content = content;
        }

        protected int getStatusCode() {
            return this.statusCode;
        }

        protected String getContent() {
            return this.content;
        }
    }
}

