/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.pubmed.metadatamapping;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.DCDate;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.springframework.beans.factory.annotation.Required;

public class PubmedDateMetadatumContributor<T>
implements MetadataContributor<T> {
    Logger log = Logger.getLogger(PubmedDateMetadatumContributor.class);
    private MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping;
    private List<String> dateFormatsToAttempt;
    private MetadataFieldConfig field;
    private MetadataContributor day;
    private MetadataContributor month;
    private MetadataContributor year;

    public List<String> getDateFormatsToAttempt() {
        return this.dateFormatsToAttempt;
    }

    @Required
    public void setDateFormatsToAttempt(List<String> dateFormatsToAttempt) {
        this.dateFormatsToAttempt = dateFormatsToAttempt;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
        this.day.setMetadataFieldMapping(metadataFieldMapping);
        this.month.setMetadataFieldMapping(metadataFieldMapping);
        this.year.setMetadataFieldMapping(metadataFieldMapping);
    }

    public PubmedDateMetadatumContributor() {
    }

    public PubmedDateMetadatumContributor(MetadataFieldConfig field, MetadataContributor day, MetadataContributor month, MetadataContributor year) {
        this.field = field;
        this.day = day;
        this.month = month;
        this.year = year;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(T t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        try {
            LinkedList yearList = (LinkedList)this.year.contributeMetadata(t);
            LinkedList monthList = (LinkedList)this.month.contributeMetadata(t);
            LinkedList dayList = (LinkedList)this.day.contributeMetadata(t);
            for (int i = 0; i < yearList.size(); ++i) {
                DCDate dcDate = null;
                String dateString = "";
                dateString = monthList.size() > i && dayList.size() > i ? ((MetadatumDTO)yearList.get(i)).getValue() + "-" + ((MetadatumDTO)monthList.get(i)).getValue() + "-" + ((MetadatumDTO)dayList.get(i)).getValue() : (monthList.size() > i ? ((MetadatumDTO)yearList.get(i)).getValue() + "-" + ((MetadatumDTO)monthList.get(i)).getValue() : ((MetadatumDTO)yearList.get(i)).getValue());
                for (String dateFormat : this.dateFormatsToAttempt) {
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                        Date date = formatter.parse(dateString);
                        dcDate = new DCDate(date);
                    }
                    catch (ParseException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (dcDate == null) continue;
                values.add(this.metadataFieldMapping.toDCValue(this.field, dcDate.toString()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error", (Throwable)e);
        }
        return values;
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public MetadataContributor getDay() {
        return this.day;
    }

    public void setDay(MetadataContributor day) {
        this.day = day;
    }

    public MetadataContributor getMonth() {
        return this.month;
    }

    public void setMonth(MetadataContributor month) {
        this.month = month;
    }

    public MetadataContributor getYear() {
        return this.year;
    }

    public void setYear(MetadataContributor year) {
        this.year = year;
    }
}

