/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.rdf.ItemNotArchivedException;
import org.dspace.rdf.ItemNotDiscoverableException;
import org.dspace.rdf.ItemWithdrawnException;
import org.dspace.rdf.RDFConfiguration;
import org.dspace.rdf.RDFMissingIdentifierException;

public class RDFUtil {
    private static final Logger log = Logger.getLogger(RDFUtil.class);
    private static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    public static Model loadModel(String identifier) {
        return RDFConfiguration.getRDFStorage().load(identifier);
    }

    public static String generateIdentifier(Context context, DSpaceObject dso) throws SQLException {
        return RDFConfiguration.getURIGenerator().generateIdentifier(context, dso);
    }

    public static String generateIdentifier(Context context, int type, UUID id, String handle, List<String> identifier) throws SQLException {
        return RDFConfiguration.getURIGenerator().generateIdentifier(context, type, id, handle, identifier);
    }

    public static Model convert(Context context, DSpaceObject dso) throws RDFMissingIdentifierException, SQLException, ItemNotArchivedException, ItemWithdrawnException, ItemNotDiscoverableException, AuthorizeException, IllegalArgumentException {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            throw new IllegalArgumentException(ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getTypeText(dso) + " is currently not supported as independent entity.");
        }
        if (!RDFConfiguration.isConvertType(ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getTypeText(dso))) {
            return null;
        }
        RDFUtil.isPublic(context, dso);
        return RDFConfiguration.getRDFConverter().convert(context, dso);
    }

    public static Model convertAndStore(Context context, DSpaceObject dso) throws RDFMissingIdentifierException, SQLException, ItemNotArchivedException, ItemWithdrawnException, ItemNotDiscoverableException, AuthorizeException, IllegalArgumentException {
        Model convertedData = RDFUtil.convert(context, dso);
        String identifier = RDFUtil.generateIdentifier(context, dso);
        if (StringUtils.isEmpty((String)identifier)) {
            log.error((Object)("Cannot generate identifier for dso from type " + ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getTypeText(dso) + " (id: " + dso.getID() + ")."));
            if (convertedData != null) {
                convertedData.close();
            }
            throw new RDFMissingIdentifierException(dso.getType(), dso.getID());
        }
        if (convertedData == null) {
            RDFConfiguration.getRDFStorage().delete(identifier);
            return null;
        }
        RDFConfiguration.getRDFStorage().store(identifier, convertedData);
        return convertedData;
    }

    public static void isPublic(Context context, DSpaceObject dso) throws SQLException, ItemNotArchivedException, ItemWithdrawnException, ItemNotDiscoverableException, AuthorizeException {
        if (dso instanceof Site) {
            return;
        }
        authorizeService.authorizeAction(context, dso, 0);
        if (dso instanceof Item) {
            Item item = (Item)dso;
            if (!item.isArchived()) {
                throw new ItemNotArchivedException();
            }
            if (!item.isDiscoverable()) {
                throw new ItemNotDiscoverableException();
            }
            if (item.isWithdrawn()) {
                throw new ItemWithdrawnException();
            }
        }
    }

    public static boolean isPublicBoolean(Context context, DSpaceObject dso) throws SQLException {
        try {
            RDFUtil.isPublic(context, dso);
        }
        catch (AuthorizeException | ItemNotArchivedException | ItemNotDiscoverableException | ItemWithdrawnException ex) {
            return false;
        }
        return true;
    }

    public static void delete(String uri) {
        RDFConfiguration.getRDFStorage().delete(uri);
    }

    public static void delete(Context ctx, int type, UUID id, String handle, List<String> identifiers) throws SQLException, RDFMissingIdentifierException {
        String uri = RDFConfiguration.getURIGenerator().generateIdentifier(ctx, type, id, handle, identifiers);
        if (uri == null) {
            throw new RDFMissingIdentifierException(type, id);
        }
        RDFConfiguration.getRDFStorage().delete(uri);
    }
}

