/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.storage;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.rdf.storage.LocalURIGenerator;
import org.dspace.rdf.storage.URIGenerator;

public class DOIURIGenerator
implements URIGenerator {
    private static final Logger log = Logger.getLogger(DOIURIGenerator.class);
    protected static final URIGenerator fallback = new LocalURIGenerator();
    protected final DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();

    @Override
    public String generateIdentifier(Context context, int type, UUID id, String handle, List<String> identifiers) throws SQLException {
        if (type != 5 && type != 4 && type != 3 && type != 2) {
            return null;
        }
        String doi = null;
        for (String identifier : identifiers) {
            try {
                doi = this.doiService.DOIToExternalForm(identifier);
            }
            catch (IdentifierException identifierException) {}
        }
        if (doi != null) {
            return doi;
        }
        log.info((Object)("Didn't find a DOI for " + Constants.typeText[type] + ", id " + id.toString() + ", will use fallback URIGenerator."));
        return fallback.generateIdentifier(context, type, id, handle, identifiers);
    }

    @Override
    public String generateIdentifier(Context context, DSpaceObject dso) throws SQLException {
        return this.generateIdentifier(context, dso.getType(), dso.getID(), dso.getHandle(), ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getIdentifiers(context, dso));
    }
}

