/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.storage;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.apache.jena.web.DatasetGraphAccessor;
import org.apache.jena.web.DatasetGraphAccessorHTTP;
import org.apache.log4j.Logger;
import org.dspace.rdf.RDFConfiguration;
import org.dspace.rdf.storage.RDFStorage;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class RDFStorageImpl
implements RDFStorage {
    private static final Logger log = Logger.getLogger(RDFStorageImpl.class);
    private final String GRAPHSTORE_ENDPOINT;
    private final String GRAPHSTORE_LOGIN;
    private final String GRAPHSTORE_PASSWORD;
    private final String SPARQL_ENDPOINT;
    private final String SPARQL_LOGIN;
    private final String SPARQL_PASSWORD;
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public RDFStorageImpl() {
        this.GRAPHSTORE_ENDPOINT = this.configurationService.getProperty("rdf.storage.graphstore.endpoint");
        if (StringUtils.isEmpty((String)this.GRAPHSTORE_ENDPOINT)) {
            log.warn((Object)"Cannot load Graph Store HTTP Protocol endpoint! Property rdf.storage.graphstore.endpoint does not exist or is empty.");
            throw new RuntimeException("Cannot load Graph Store HTTP Protocol endpoint! Property rdf.storage.graphstore.endpoint does not exist or is empty.");
        }
        boolean graphstore_use_auth = (Boolean)this.configurationService.getPropertyAsType("rdf.storage.graphstore.authentication", (Object)false);
        String graphstore_login = this.configurationService.getProperty("rdf.storage.graphstore.login");
        String graphstore_password = this.configurationService.getProperty("rdf.storage.graphstore.password");
        if (!graphstore_use_auth || graphstore_use_auth && StringUtils.isEmpty((String)graphstore_login) || graphstore_use_auth && StringUtils.isEmpty((String)graphstore_password)) {
            this.GRAPHSTORE_LOGIN = null;
            this.GRAPHSTORE_PASSWORD = null;
            if (graphstore_use_auth) {
                log.warn((Object)"The rdf storage is configured to use authentication to connect to the Graph Store HTTP Protocol endpoint, but no credentials are configured.");
            }
        } else {
            this.GRAPHSTORE_LOGIN = graphstore_login;
            this.GRAPHSTORE_PASSWORD = graphstore_password;
        }
        this.SPARQL_ENDPOINT = RDFConfiguration.getInternalSparqlEndpointAddress();
        if (StringUtils.isEmpty((String)this.SPARQL_ENDPOINT)) {
            log.warn((Object)"Cannot load internal or public SPARQL endpoint!");
            throw new RuntimeException("Cannot load internal or public SPARQL endpoint!");
        }
        boolean sparql_use_auth = (Boolean)this.configurationService.getPropertyAsType("rdf.storage.sparql.authentication", (Object)false);
        String sparql_login = this.configurationService.getProperty("rdf.storage.sparql.login");
        String sparql_password = this.configurationService.getProperty("rdf.storage.sparql.password");
        if (!sparql_use_auth || sparql_use_auth && StringUtils.isEmpty((String)sparql_login) || sparql_use_auth && StringUtils.isEmpty((String)sparql_password)) {
            this.SPARQL_LOGIN = null;
            this.SPARQL_PASSWORD = null;
            if (sparql_use_auth) {
                log.warn((Object)"The rdf storage is configured to use authentication for sparql quries, but no credentials are configured.");
            }
        } else {
            this.SPARQL_LOGIN = sparql_login;
            this.SPARQL_PASSWORD = sparql_password;
        }
    }

    @Override
    public void store(String uri, Model model) {
        Node graphNode = NodeFactory.createURI((String)uri);
        DatasetGraphAccessor accessor = this.getAccessor();
        Dataset ds = DatasetFactory.create((Model)model);
        DatasetGraph dsg = ds.asDatasetGraph();
        Graph g = dsg.getDefaultGraph();
        accessor.httpPut(graphNode, g);
    }

    @Override
    public Model load(String uri) {
        Node graphNode = NodeFactory.createURI((String)uri);
        DatasetGraphAccessor accessor = this.getAccessor();
        Graph g = accessor.httpGet(graphNode);
        if (g == null || g.isEmpty()) {
            return null;
        }
        GraphStore gs = GraphStoreFactory.create((Graph)g);
        Dataset ds = gs.toDataset();
        Model m = ds.getDefaultModel();
        return m;
    }

    protected DatasetGraphAccessor getAccessor() {
        DatasetGraphAccessorHTTP accessor;
        if (this.GRAPHSTORE_LOGIN != null) {
            SimpleAuthenticator httpAuthenticator = new SimpleAuthenticator(this.GRAPHSTORE_LOGIN, this.GRAPHSTORE_PASSWORD.toCharArray());
            accessor = new DatasetGraphAccessorHTTP(this.GRAPHSTORE_ENDPOINT, (HttpAuthenticator)httpAuthenticator);
        } else {
            accessor = new DatasetGraphAccessorHTTP(this.GRAPHSTORE_ENDPOINT);
        }
        return accessor;
    }

    @Override
    public void delete(String uri) {
        this.getAccessor().httpDelete(NodeFactory.createURI((String)uri));
    }

    @Override
    public void deleteAll() {
        for (String graph : this.getAllStoredGraphs()) {
            this.delete(graph);
        }
        this.getAccessor().httpDelete();
    }

    @Override
    public List<String> getAllStoredGraphs() {
        QueryExecution qexec;
        String queryString = "SELECT DISTINCT ?g WHERE { GRAPH ?g { ?s ?p ?o } }";
        if (this.SPARQL_LOGIN != null) {
            SimpleAuthenticator httpAuthenticator = new SimpleAuthenticator(this.SPARQL_LOGIN, this.SPARQL_PASSWORD.toCharArray());
            qexec = QueryExecutionFactory.sparqlService((String)this.SPARQL_ENDPOINT, (String)queryString, (HttpAuthenticator)httpAuthenticator);
        } else {
            qexec = QueryExecutionFactory.sparqlService((String)this.SPARQL_ENDPOINT, (String)queryString);
        }
        ResultSet rs = qexec.execSelect();
        List<String> graphs = Collections.synchronizedList(new ArrayList());
        while (rs.hasNext()) {
            QuerySolution solution = rs.next();
            if (!solution.contains("g")) continue;
            graphs.add(solution.get("g").asResource().getURI());
        }
        qexec.close();
        return graphs;
    }
}

