/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.sort.SortException;

public class SortOption {
    private static final Logger log = Logger.getLogger(SortOption.class);
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DESC";
    private int number;
    private String name;
    private String metadata;
    private String type;
    private String[] mdBits;
    private boolean visible;
    private static Set<SortOption> sortOptionsSet = null;

    public SortOption(int number, String name, String md, String type) throws SortException {
        this.name = name;
        this.type = type;
        this.metadata = md;
        this.number = number;
        this.visible = true;
        this.generateMdBits();
    }

    public SortOption(int number, String definition) throws SortException {
        this.number = number;
        String rx = "(\\w+):([\\w\\.\\*]+):(\\w+):?(\\w*)";
        Pattern pattern = Pattern.compile(rx);
        Matcher matcher = pattern.matcher(definition);
        if (!matcher.matches()) {
            throw new SortException("Sort Order configuration is not valid: webui.itemlist.sort-option." + number + " = " + definition);
        }
        this.name = matcher.group(1);
        this.metadata = matcher.group(2);
        this.type = matcher.group(3);
        this.visible = matcher.groupCount() <= 3 || !"hide".equalsIgnoreCase(matcher.group(4));
        this.generateMdBits();
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String[] getMdBits() {
        return (String[])ArrayUtils.clone((Object[])this.mdBits);
    }

    private void generateMdBits() throws SortException {
        try {
            this.mdBits = this.interpretField(this.metadata, null);
        }
        catch (IOException e) {
            throw new SortException(e);
        }
    }

    public final String[] interpretField(String mfield, String init) throws IOException {
        StringTokenizer sta = new StringTokenizer(mfield, ".");
        String[] field = new String[]{init, init, init};
        int i = 0;
        while (sta.hasMoreTokens()) {
            field[i++] = sta.nextToken();
        }
        if (field[0] == null || field[1] == null) {
            throw new IOException("at least a schema and element be specified in configuration.  You supplied: " + mfield);
        }
        return field;
    }

    public boolean isDate() {
        return "date".equals(this.type);
    }

    public boolean isDefault() {
        return this.number == 0;
    }

    public static Set<SortOption> getSortOptions() throws SortException {
        if (sortOptionsSet == null) {
            throw new SortException("Sort options not loaded");
        }
        return sortOptionsSet;
    }

    public static SortOption getSortOption(int number) throws SortException {
        for (SortOption so : SortOption.getSortOptions()) {
            if (so.getNumber() != number) continue;
            return so;
        }
        return null;
    }

    public static SortOption getDefaultSortOption() throws SortException {
        Iterator<SortOption> i$ = SortOption.getSortOptions().iterator();
        if (i$.hasNext()) {
            SortOption so = i$.next();
            return so;
        }
        return null;
    }

    static {
        try {
            String option;
            TreeSet<SortOption> newSortOptionsSet = new TreeSet<SortOption>(new Comparator<SortOption>(){

                @Override
                public int compare(SortOption sortOption, SortOption sortOption1) {
                    return Integer.valueOf(sortOption.getNumber()).compareTo(sortOption1.getNumber());
                }
            });
            int idx = 1;
            while ((option = ConfigurationManager.getProperty("webui.itemlist.sort-option." + idx)) != null) {
                SortOption so = new SortOption(idx, option);
                newSortOptionsSet.add(so);
                ++idx;
            }
            sortOptionsSet = newSortOptionsSet;
        }
        catch (SortException se) {
            log.fatal((Object)"Unable to load SortOptions", (Throwable)se);
        }
    }
}

