/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.DSpaceObjectLegacySupportService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.service.SolrLoggerService;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;
import org.dspace.statistics.util.SpiderDetector;
import org.dspace.usage.UsageWorkflowEvent;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrLoggerServiceImpl
implements SolrLoggerService,
InitializingBean {
    private static final Logger log = Logger.getLogger(SolrLoggerServiceImpl.class);
    protected HttpSolrServer solr;
    public static final String DATE_FORMAT_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_DCDATE = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected LookupService locationService;
    protected boolean useProxies;
    private static List<String> statisticYearCores = new ArrayList<String>();
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    private ConfigurationService configurationService;
    protected String filterQuery = null;

    protected SolrLoggerServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        log.info((Object)("solr-statistics.spidersfile:" + this.configurationService.getProperty("solr-statistics.spidersfile")));
        log.info((Object)("solr-statistics.server:" + this.configurationService.getProperty("solr-statistics.server")));
        log.info((Object)("usage-statistics.dbfile:" + this.configurationService.getProperty("usage-statistics.dbfile")));
        HttpSolrServer server = null;
        if (this.configurationService.getProperty("solr-statistics.server") != null) {
            try {
                server = new HttpSolrServer(this.configurationService.getProperty("solr-statistics.server"));
                File solrDir = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "solr" + File.separator);
                File[] solrCoreFiles = solrDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().matches("statistics-\\d\\d\\d\\d");
                    }
                });
                String baseSolrUrl = server.getBaseURL().replace("statistics", "");
                for (File solrCoreFile : solrCoreFiles) {
                    log.info((Object)("Loading core with name: " + solrCoreFile.getName()));
                    this.createCore(server, solrCoreFile.getName());
                    statisticYearCores.add(baseSolrUrl.replace("http://", "").replace("https://", "") + solrCoreFile.getName());
                }
                statisticYearCores.add(server.getBaseURL().replace("http://", "").replace("https://", ""));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.solr = server;
        LookupService service = null;
        String dbfile = this.configurationService.getProperty("usage-statistics.dbfile");
        if (dbfile != null) {
            try {
                service = new LookupService(dbfile, 0);
            }
            catch (FileNotFoundException fe) {
                log.error((Object)("The GeoLite Database file is missing (" + dbfile + ")! Solr Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file."), (Throwable)fe);
            }
            catch (IOException e) {
                log.error((Object)("Unable to load GeoLite Database file (" + dbfile + ")! You may need to reinstall it. See the DSpace installation instructions for more details."), (Throwable)e);
            }
        } else {
            log.error((Object)"The required 'dbfile' configuration is missing in solr-statistics.cfg!");
        }
        this.locationService = service;
        this.useProxies = this.configurationService.getBooleanProperty("useProxies");
        log.info((Object)("useProxies=" + this.useProxies));
    }

    @Override
    public void post(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        this.postView(dspaceObject, request, currentUser);
    }

    @Override
    public void postView(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        if (this.solr == null || this.locationService == null) {
            return;
        }
        try {
            SolrInputDocument doc1 = this.getCommonSolrDoc(dspaceObject, request, currentUser);
            if (doc1 == null) {
                return;
            }
            if (dspaceObject instanceof Bitstream) {
                Bitstream bit = (Bitstream)dspaceObject;
                List<Bundle> bundles = bit.getBundles();
                for (Bundle bundle : bundles) {
                    doc1.addField("bundleName", (Object)bundle.getName());
                }
            }
            doc1.addField("statistics_type", (Object)StatisticsType.VIEW.text());
            this.solr.add(doc1);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void postView(DSpaceObject dspaceObject, String ip, String userAgent, String xforwardedfor, EPerson currentUser) {
        if (this.solr == null || this.locationService == null) {
            return;
        }
        try {
            SolrInputDocument doc1 = this.getCommonSolrDoc(dspaceObject, ip, userAgent, xforwardedfor, currentUser);
            if (doc1 == null) {
                return;
            }
            if (dspaceObject instanceof Bitstream) {
                Bitstream bit = (Bitstream)dspaceObject;
                List<Bundle> bundles = bit.getBundles();
                for (Bundle bundle : bundles) {
                    doc1.addField("bundleName", (Object)bundle.getName());
                }
            }
            doc1.addField("statistics_type", (Object)StatisticsType.VIEW.text());
            this.solr.add(doc1);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected SolrInputDocument getCommonSolrDoc(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) throws SQLException {
        boolean isSpiderBot;
        boolean bl = isSpiderBot = request != null && SpiderDetector.isSpider(request);
        if (isSpiderBot && !this.configurationService.getBooleanProperty("usage-statistics.logBots", true)) {
            return null;
        }
        SolrInputDocument doc1 = new SolrInputDocument();
        if (request != null) {
            Location location;
            String ip = request.getRemoteAddr();
            if (this.isUseProxies() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            doc1.addField("ip", (Object)ip);
            if (request.getHeader("referer") != null) {
                doc1.addField("referrer", (Object)request.getHeader("referer"));
            }
            try {
                String dns = DnsLookup.reverseDns(ip);
                doc1.addField("dns", (Object)dns.toLowerCase());
            }
            catch (Exception e) {
                log.info((Object)("Failed DNS Lookup for IP:" + ip));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            if (request.getHeader("User-Agent") != null) {
                doc1.addField("userAgent", (Object)request.getHeader("User-Agent"));
            }
            doc1.addField("isBot", (Object)isSpiderBot);
            if (!(this.locationService == null || (location = this.locationService.getLocation(ip)) == null || "--".equals(location.countryCode) && location.latitude == -180.0f && location.longitude == -180.0f)) {
                try {
                    doc1.addField("continent", (Object)LocationUtils.getContinentCode(location.countryCode));
                }
                catch (Exception e) {
                    System.out.println("COUNTRY ERROR: " + location.countryCode);
                }
                doc1.addField("countryCode", (Object)location.countryCode);
                doc1.addField("city", (Object)location.city);
                doc1.addField("latitude", (Object)Float.valueOf(location.latitude));
                doc1.addField("longitude", (Object)Float.valueOf(location.longitude));
            }
        }
        if (dspaceObject != null) {
            doc1.addField("id", (Object)dspaceObject.getID());
            doc1.addField("type", (Object)dspaceObject.getType());
            this.storeParents(doc1, dspaceObject);
        }
        doc1.addField("time", (Object)DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
        if (currentUser != null) {
            doc1.addField("epersonid", (Object)currentUser.getID());
        }
        return doc1;
    }

    protected SolrInputDocument getCommonSolrDoc(DSpaceObject dspaceObject, String ip, String userAgent, String xforwardedfor, EPerson currentUser) throws SQLException {
        boolean isSpiderBot = SpiderDetector.isSpider(ip);
        if (isSpiderBot && !this.configurationService.getBooleanProperty("usage-statistics.logBots", true)) {
            return null;
        }
        SolrInputDocument doc1 = new SolrInputDocument();
        if (this.isUseProxies() && xforwardedfor != null) {
            Location location;
            for (String xfip : xforwardedfor.split(",")) {
                if (xforwardedfor.contains(ip)) continue;
                ip = xfip.trim();
            }
            doc1.addField("ip", (Object)ip);
            try {
                String dns = DnsLookup.reverseDns(ip);
                doc1.addField("dns", (Object)dns.toLowerCase());
            }
            catch (Exception e) {
                log.info((Object)("Failed DNS Lookup for IP:" + ip));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            if (userAgent != null) {
                doc1.addField("userAgent", (Object)userAgent);
            }
            doc1.addField("isBot", (Object)isSpiderBot);
            if (!(this.locationService == null || (location = this.locationService.getLocation(ip)) == null || "--".equals(location.countryCode) && location.latitude == -180.0f && location.longitude == -180.0f)) {
                try {
                    doc1.addField("continent", (Object)LocationUtils.getContinentCode(location.countryCode));
                }
                catch (Exception e) {
                    System.out.println("COUNTRY ERROR: " + location.countryCode);
                }
                doc1.addField("countryCode", (Object)location.countryCode);
                doc1.addField("city", (Object)location.city);
                doc1.addField("latitude", (Object)Float.valueOf(location.latitude));
                doc1.addField("longitude", (Object)Float.valueOf(location.longitude));
            }
        }
        if (dspaceObject != null) {
            doc1.addField("id", (Object)dspaceObject.getID());
            doc1.addField("type", (Object)dspaceObject.getType());
            this.storeParents(doc1, dspaceObject);
        }
        doc1.addField("time", (Object)DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
        if (currentUser != null) {
            doc1.addField("epersonid", (Object)currentUser.getID());
        }
        return doc1;
    }

    @Override
    public void postSearch(DSpaceObject resultObject, HttpServletRequest request, EPerson currentUser, List<String> queries, int rpp, String sortBy, String order, int page, DSpaceObject scope) {
        try {
            SolrInputDocument solrDoc = this.getCommonSolrDoc(resultObject, request, currentUser);
            if (solrDoc == null) {
                return;
            }
            for (String query : queries) {
                solrDoc.addField("query", (Object)query);
            }
            if (resultObject != null) {
                solrDoc.addField("statistics_type", (Object)StatisticsType.SEARCH_RESULT.text());
            } else {
                solrDoc.addField("statistics_type", (Object)StatisticsType.SEARCH.text());
            }
            if (scope != null) {
                solrDoc.addField("scopeId", (Object)scope.getID());
                solrDoc.addField("scopeType", (Object)scope.getType());
            }
            if (rpp != -1) {
                solrDoc.addField("rpp", (Object)rpp);
            }
            if (sortBy != null) {
                solrDoc.addField("sortBy", (Object)sortBy);
                if (order != null) {
                    solrDoc.addField("sortOrder", (Object)order);
                }
            }
            if (page != -1) {
                solrDoc.addField("page", (Object)page);
            }
            this.solr.add(solrDoc);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void postWorkflow(UsageWorkflowEvent usageWorkflowEvent) throws SQLException {
        try {
            int i;
            SolrInputDocument solrDoc = this.getCommonSolrDoc(usageWorkflowEvent.getObject(), null, null);
            solrDoc.addField("owningColl", (Object)usageWorkflowEvent.getScope().getID());
            this.storeParents(solrDoc, usageWorkflowEvent.getScope());
            if (usageWorkflowEvent.getWorkflowStep() != null) {
                solrDoc.addField("workflowStep", (Object)usageWorkflowEvent.getWorkflowStep());
            }
            if (usageWorkflowEvent.getOldState() != null) {
                solrDoc.addField("previousWorkflowStep", (Object)usageWorkflowEvent.getOldState());
            }
            if (usageWorkflowEvent.getGroupOwners() != null) {
                for (i = 0; i < usageWorkflowEvent.getGroupOwners().length; ++i) {
                    Group group = usageWorkflowEvent.getGroupOwners()[i];
                    solrDoc.addField("owner", (Object)("g" + group.getID()));
                }
            }
            if (usageWorkflowEvent.getEpersonOwners() != null) {
                for (i = 0; i < usageWorkflowEvent.getEpersonOwners().length; ++i) {
                    EPerson ePerson = usageWorkflowEvent.getEpersonOwners()[i];
                    solrDoc.addField("owner", (Object)("e" + ePerson.getID()));
                }
            }
            solrDoc.addField("workflowItemId", (Object)usageWorkflowEvent.getWorkflowItem().getID());
            EPerson submitter = ((Item)usageWorkflowEvent.getObject()).getSubmitter();
            if (submitter != null) {
                solrDoc.addField("submitter", (Object)submitter.getID());
            }
            solrDoc.addField("statistics_type", (Object)StatisticsType.WORKFLOW.text());
            if (usageWorkflowEvent.getActor() != null) {
                solrDoc.addField("actor", (Object)usageWorkflowEvent.getActor().getID());
            }
            this.solr.add(solrDoc);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void storeParents(SolrInputDocument doc1, DSpaceObject dso) throws SQLException {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(dso instanceof Community)) break block5;
                        Community comm = (Community)dso;
                        List<Community> parentCommunities = comm.getParentCommunities();
                        for (Community parent : parentCommunities) {
                            doc1.addField("owningComm", (Object)parent.getID());
                            this.storeParents(doc1, parent);
                        }
                        break block6;
                    }
                    if (!(dso instanceof org.dspace.content.Collection)) break block7;
                    org.dspace.content.Collection coll = (org.dspace.content.Collection)dso;
                    List<Community> communities = coll.getCommunities();
                    for (Community community : communities) {
                        doc1.addField("owningComm", (Object)community.getID());
                        this.storeParents(doc1, community);
                    }
                    break block6;
                }
                if (!(dso instanceof Item)) break block8;
                Item item = (Item)dso;
                List<org.dspace.content.Collection> collections = item.getCollections();
                for (org.dspace.content.Collection collection : collections) {
                    doc1.addField("owningColl", (Object)collection.getID());
                    this.storeParents(doc1, collection);
                }
                break block6;
            }
            if (!(dso instanceof Bitstream)) break block6;
            Bitstream bitstream = (Bitstream)dso;
            List<Bundle> bundles = bitstream.getBundles();
            for (Bundle bundle : bundles) {
                List<Item> items = bundle.getItems();
                for (Item item : items) {
                    doc1.addField("owningItem", (Object)item.getID());
                    this.storeParents(doc1, item);
                }
            }
        }
    }

    @Override
    public boolean isUseProxies() {
        return this.useProxies;
    }

    @Override
    public void removeIndex(String query) throws IOException, SolrServerException {
        this.solr.deleteByQuery(query);
        this.solr.commit();
    }

    @Override
    public Map<String, List<String>> queryField(String query, List oldFieldVals, String field) {
        HashMap<String, List<String>> currentValsStored = new HashMap<String, List<String>>();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "1");
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = this.solr.query((SolrParams)solrParams);
            if (response.getResults().getNumFound() == 0L) {
                return currentValsStored;
            }
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        return currentValsStored;
    }

    @Override
    public void markRobotsByIP() {
        for (String ip : SpiderDetector.getSpiderIpAddresses()) {
            try {
                ResultProcessor processor = new ResultProcessor(){

                    @Override
                    public void process(SolrDocument doc) throws IOException, SolrServerException {
                        doc.removeFields("isBot");
                        doc.addField("isBot", (Object)true);
                        SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)doc);
                        SolrLoggerServiceImpl.this.solr.add(newInput);
                        log.info((Object)("Marked " + doc.getFieldValue("ip") + " as bot"));
                    }
                };
                processor.execute("ip:" + ip + "* AND -isBot:true");
                this.solr.commit();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void markRobotByUserAgent(String agent) {
        try {
            ResultProcessor processor = new ResultProcessor(){

                @Override
                public void process(SolrDocument doc) throws IOException, SolrServerException {
                    doc.removeFields("isBot");
                    doc.addField("isBot", (Object)true);
                    SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)doc);
                    SolrLoggerServiceImpl.this.solr.add(newInput);
                }
            };
            processor.execute("userAgent:" + agent + " AND -isBot:true");
            this.solr.commit();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteRobotsByIsBotFlag() {
        try {
            this.solr.deleteByQuery("isBot:true");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteIP(String ip) {
        try {
            this.solr.deleteByQuery("ip:" + ip + "*");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteRobotsByIP() {
        for (String ip : SpiderDetector.getSpiderIpAddresses()) {
            this.deleteIP(ip);
        }
    }

    @Override
    public void update(String query, String action, List<String> fieldNames, List<List<Object>> fieldValuesList) throws SolrServerException, IOException {
        final ArrayList docsToUpdate = new ArrayList();
        ResultProcessor processor = new ResultProcessor(){

            @Override
            public void process(List<SolrDocument> docs) throws IOException, SolrServerException {
                docsToUpdate.addAll(docs);
            }
        };
        processor.execute(query);
        this.solr.deleteByQuery(query);
        for (int i = 0; i < docsToUpdate.size(); ++i) {
            SolrDocument solrDocument = (SolrDocument)docsToUpdate.get(i);
            for (int j = 0; j < fieldNames.size(); ++j) {
                String fieldName = fieldNames.get(j);
                List<Object> fieldValues = fieldValuesList.get(j);
                if (action.equals("addOne") || action.equals("replace")) {
                    if (action.equals("replace")) {
                        solrDocument.removeFields(fieldName);
                    }
                    for (Object fieldValue : fieldValues) {
                        solrDocument.addField(fieldName, fieldValue);
                    }
                    continue;
                }
                if (!action.equals("remOne")) continue;
                Collection values = solrDocument.getFieldValues(fieldName);
                solrDocument.removeFields(fieldName);
                for (Object value : values) {
                    if (fieldValues.contains(value)) continue;
                    solrDocument.addField(fieldName, value);
                }
            }
            SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)solrDocument);
            this.solr.add(newInput);
        }
        this.solr.commit();
    }

    @Override
    public void query(String query, int max) throws SolrServerException {
        this.query(query, null, null, 0, max, null, null, null, null, null, false);
    }

    @Override
    public ObjectCount[] queryFacetField(String query, String filterQuery, String facetField, int max, boolean showTotal, List<String> facetQueries) throws SolrServerException {
        QueryResponse queryResponse = this.query(query, filterQuery, facetField, 0, max, null, null, null, facetQueries, null, false);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        FacetField field = queryResponse.getFacetField(facetField);
        if (0 < field.getValueCount()) {
            ObjectCount[] result = new ObjectCount[field.getValueCount() + (showTotal ? 1 : 0)];
            for (int i = 0; i < field.getValues().size(); ++i) {
                FacetField.Count fieldCount = (FacetField.Count)field.getValues().get(i);
                result[i] = new ObjectCount();
                result[i].setCount(fieldCount.getCount());
                result[i].setValue(fieldCount.getName());
            }
            if (showTotal) {
                result[result.length - 1] = new ObjectCount();
                result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
                result[result.length - 1].setValue("total");
            }
            return result;
        }
        return new ObjectCount[0];
    }

    @Override
    public ObjectCount[] queryFacetDate(String query, String filterQuery, int max, String dateType, String dateStart, String dateEnd, boolean showTotal, Context context) throws SolrServerException {
        QueryResponse queryResponse = this.query(query, filterQuery, null, 0, max, dateType, dateStart, dateEnd, null, null, false);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        FacetField dateFacet = queryResponse.getFacetDate("time");
        ObjectCount[] result = new ObjectCount[dateFacet.getValueCount() + (showTotal ? 1 : 0)];
        for (int i = 0; i < dateFacet.getValues().size(); ++i) {
            FacetField.Count dateCount = (FacetField.Count)dateFacet.getValues().get(i);
            result[i] = new ObjectCount();
            result[i].setCount(dateCount.getCount());
            result[i].setValue(this.getDateView(dateCount.getName(), dateType, context));
        }
        if (showTotal) {
            result[result.length - 1] = new ObjectCount();
            result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
            result[result.length - 1].setValue("total");
        }
        return result;
    }

    @Override
    public Map<String, Integer> queryFacetQuery(String query, String filterQuery, List<String> facetQueries) throws SolrServerException {
        QueryResponse response = this.query(query, filterQuery, null, 0, 1, null, null, null, facetQueries, null, false);
        return response.getFacetQuery();
    }

    @Override
    public ObjectCount queryTotal(String query, String filterQuery) throws SolrServerException {
        QueryResponse queryResponse = this.query(query, filterQuery, null, 0, -1, null, null, null, null, null, false);
        ObjectCount objCount = new ObjectCount();
        objCount.setCount(queryResponse.getResults().getNumFound());
        return objCount;
    }

    protected String getDateView(String name, String type, Context context) {
        if (name != null && name.matches("^[0-9]{4}\\-[0-9]{2}.*")) {
            Date date = null;
            try {
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_8601, context.getCurrentLocale());
                date = format.parse(name);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DCDATE, context.getCurrentLocale());
                    date = format.parse(name);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            String dateformatString = "dd-MM-yyyy";
            if ("DAY".equals(type)) {
                dateformatString = "dd-MM-yyyy";
            } else if ("MONTH".equals(type)) {
                dateformatString = "MMMM yyyy";
            } else if ("YEAR".equals(type)) {
                dateformatString = "yyyy";
            }
            SimpleDateFormat simpleFormat = new SimpleDateFormat(dateformatString, context.getCurrentLocale());
            if (date != null) {
                name = simpleFormat.format(date);
            }
        }
        return name;
    }

    @Override
    public QueryResponse query(String query, String filterQuery, String facetField, int rows, int max, String dateType, String dateStart, String dateEnd, List<String> facetQueries, String sort, boolean ascending) throws SolrServerException {
        QueryResponse response;
        String[] bundles;
        if (this.solr == null) {
            return null;
        }
        SolrQuery solrQuery = new SolrQuery().setRows(Integer.valueOf(rows)).setQuery(query).setFacetMinCount(1);
        this.addAdditionalSolrYearCores(solrQuery);
        if (dateType != null) {
            solrQuery.setParam("facet.date", new String[]{"time"}).setParam("facet.date.end", new String[]{"NOW/" + dateType + dateEnd + dateType}).setParam("facet.date.gap", new String[]{"+1" + dateType}).setParam("facet.date.start", new String[]{"NOW/" + dateType + dateStart + dateType + "S"}).setFacet(true);
        }
        if (facetQueries != null) {
            for (int i = 0; i < facetQueries.size(); ++i) {
                String facetQuery = facetQueries.get(i);
                solrQuery.addFacetQuery(facetQuery);
            }
            if (0 < facetQueries.size()) {
                solrQuery.setFacet(true);
            }
        }
        if (facetField != null) {
            solrQuery.addFacetField(new String[]{facetField});
        }
        if (max != -1) {
            solrQuery.setFacetLimit(max);
        }
        if (this.configurationService.getBooleanProperty("solr-statistics.query.filter.spiderIp", false)) {
            solrQuery.addFilterQuery(new String[]{this.getIgnoreSpiderIPs()});
        }
        if (this.configurationService.getBooleanProperty("solr-statistics.query.filter.isBot", true)) {
            solrQuery.addFilterQuery(new String[]{"-isBot:true"});
        }
        if (sort != null) {
            solrQuery.setSortField(sort, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
        if ((bundles = this.configurationService.getArrayProperty("solr-statistics.query.filter.bundles")) != null && bundles.length > 0) {
            StringBuffer bundleQuery = new StringBuffer();
            bundleQuery.append("-(bundleName:[* TO *]");
            for (int i = 0; i < bundles.length; ++i) {
                String bundle = bundles[i].trim();
                bundleQuery.append("-bundleName:").append(bundle);
                if (i == bundles.length - 1) continue;
                bundleQuery.append(" AND ");
            }
            bundleQuery.append(")");
            solrQuery.addFilterQuery(new String[]{bundleQuery.toString()});
        }
        if (filterQuery != null) {
            solrQuery.addFilterQuery(new String[]{filterQuery});
        }
        try {
            response = this.solr.query((SolrParams)solrQuery);
        }
        catch (SolrServerException e) {
            System.err.println("Error using query " + query);
            throw e;
        }
        return response;
    }

    @Override
    public String getIgnoreSpiderIPs() {
        if (this.filterQuery == null) {
            StringBuilder query = new StringBuilder();
            boolean first = true;
            for (String ip : SpiderDetector.getSpiderIpAddresses()) {
                if (first) {
                    query.append(" AND ");
                    first = false;
                }
                query.append(" NOT(ip: ").append(ip).append(")");
            }
            this.filterQuery = query.toString();
        }
        return this.filterQuery;
    }

    @Override
    public void optimizeSOLR() {
        try {
            long start = System.currentTimeMillis();
            System.out.println("SOLR Optimize -- Process Started:" + start);
            this.solr.optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (SolrServerException sse) {
            System.err.println(sse.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    @Override
    public void shardSolrIndex() throws IOException, SolrServerException {
        SolrQuery yearRangeQuery = new SolrQuery();
        yearRangeQuery.setQuery("*:*");
        yearRangeQuery.setRows(Integer.valueOf(0));
        yearRangeQuery.setFacet(true);
        yearRangeQuery.add("facet.range", new String[]{"time"});
        yearRangeQuery.add("facet.range.start", new String[]{"NOW/YEAR-" + (Calendar.getInstance().get(1) - 2000) + "YEARS"});
        yearRangeQuery.add("facet.range.end", new String[]{"NOW/YEAR+0YEARS"});
        yearRangeQuery.add("facet.range.gap", new String[]{"+1YEAR"});
        yearRangeQuery.add("facet.mincount", new String[]{String.valueOf(1)});
        File tempDirectory = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
        tempDirectory.mkdirs();
        QueryResponse queryResponse = this.solr.query((SolrParams)yearRangeQuery);
        List yearResults = ((RangeFacet)queryResponse.getFacetRanges().get(0)).getCounts();
        for (RangeFacet.Count count : yearResults) {
            long totalRecords = count.getCount();
            DCDate dcStart = new DCDate(count.getValue());
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(dcStart.toDate());
            endDate.add(1, 1);
            DCDate dcEndDate = new DCDate(endDate.getTime());
            StringBuilder filterQuery = new StringBuilder();
            filterQuery.append("time:([");
            filterQuery.append(ClientUtils.escapeQueryChars((String)dcStart.toString()));
            filterQuery.append(" TO ");
            filterQuery.append(ClientUtils.escapeQueryChars((String)dcEndDate.toString()));
            filterQuery.append("]");
            filterQuery.append(" NOT ").append(ClientUtils.escapeQueryChars((String)dcEndDate.toString()));
            filterQuery.append(")");
            HashMap<String, String> yearQueryParams = new HashMap<String, String>();
            yearQueryParams.put("q", "*:*");
            yearQueryParams.put("rows", String.valueOf(10000));
            yearQueryParams.put("fq", filterQuery.toString());
            yearQueryParams.put("wt", "csv");
            String coreName = "statistics-" + dcStart.getYear();
            HttpSolrServer statisticsYearServer = this.createCore(this.solr, coreName);
            System.out.println("Moving: " + totalRecords + " into core " + coreName);
            log.info((Object)("Moving: " + totalRecords + " records into core " + coreName));
            ArrayList<File> filesToUpload = new ArrayList<File>();
            int i = 0;
            while ((long)i < totalRecords) {
                String solrRequestUrl = this.solr.getBaseURL() + "/select";
                solrRequestUrl = this.generateURL(solrRequestUrl, yearQueryParams);
                HttpGet get = new HttpGet(solrRequestUrl);
                CloseableHttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)get);
                InputStream csvInputstream = response.getEntity().getContent();
                File csvFile = new File(tempDirectory.getPath() + File.separatorChar + "temp." + dcStart.getYear() + "." + i + ".csv");
                FileUtils.copyInputStreamToFile((InputStream)csvInputstream, (File)csvFile);
                filesToUpload.add(csvFile);
                yearQueryParams.put("start", String.valueOf(i + 10000));
                i += 10000;
            }
            for (File tempCsv : filesToUpload) {
                ContentStreamUpdateRequest contentStreamUpdateRequest = new ContentStreamUpdateRequest("/update/csv");
                contentStreamUpdateRequest.setParam("stream.contentType", "text/plain;charset=utf-8");
                contentStreamUpdateRequest.setParam("skip", "_version_");
                contentStreamUpdateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                contentStreamUpdateRequest.addFile(tempCsv, "text/plain;charset=utf-8");
                statisticsYearServer.request((SolrRequest)contentStreamUpdateRequest);
            }
            statisticsYearServer.commit(true, true);
            this.solr.deleteByQuery(filterQuery.toString());
            this.solr.commit(true, true);
            log.info((Object)("Moved " + totalRecords + " records into core: " + coreName));
        }
        FileUtils.deleteDirectory((File)tempDirectory);
    }

    protected HttpSolrServer createCore(HttpSolrServer solr, String coreName) throws IOException, SolrServerException {
        String solrDir = this.configurationService.getProperty("dspace.dir") + File.separator + "solr" + File.separator;
        String baseSolrUrl = solr.getBaseURL().replace("statistics", "");
        CoreAdminRequest.Create create = new CoreAdminRequest.Create();
        create.setCoreName(coreName);
        create.setInstanceDir("statistics");
        create.setDataDir(solrDir + coreName + File.separator + "data");
        HttpSolrServer solrServer = new HttpSolrServer(baseSolrUrl);
        create.process((SolrServer)solrServer);
        log.info((Object)("Created core with name: " + coreName));
        return new HttpSolrServer(baseSolrUrl + "/" + coreName);
    }

    @Override
    public void reindexBitstreamHits(boolean removeDeletedBitstreams) throws Exception {
        Context context = new Context();
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("*:*");
            query.addFilterQuery(new String[]{"type:0"});
            query.addFilterQuery(new String[]{"-bundleName:[* TO *]"});
            query.setRows(Integer.valueOf(0));
            this.addAdditionalSolrYearCores(query);
            long totalRecords = this.solr.query((SolrParams)query).getResults().getNumFound();
            File tempDirectory = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
            tempDirectory.mkdirs();
            ArrayList<File> tempCsvFiles = new ArrayList<File>();
            int i = 0;
            while ((long)i < totalRecords) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("q", "*:*");
                params.put("fq", "-bundleName:[* TO *] AND type:0");
                params.put("wt", "csv");
                params.put("rows", String.valueOf(10000));
                params.put("start", String.valueOf(i));
                String solrRequestUrl = this.solr.getBaseURL() + "/select";
                solrRequestUrl = this.generateURL(solrRequestUrl, params);
                HttpGet get = new HttpGet(solrRequestUrl);
                CloseableHttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)get);
                InputStream csvOutput = response.getEntity().getContent();
                InputStreamReader csvReader = new InputStreamReader(csvOutput);
                List rows = new CSVReader((Reader)csvReader).readAll();
                String[][] csvParsed = (String[][])rows.toArray((T[])new String[rows.size()][]);
                Object[] header = csvParsed[0];
                int idIndex = 0;
                for (int j = 0; j < header.length; ++j) {
                    if (!header[j].equals("id")) continue;
                    idIndex = j;
                }
                File tempCsv = new File(tempDirectory.getPath() + File.separatorChar + "temp." + i + ".csv");
                tempCsvFiles.add(tempCsv);
                CSVWriter csvp = new CSVWriter((Writer)new FileWriter(tempCsv));
                csvp.writeNext((String[])ArrayUtils.add((Object[])header, (Object)"bundleName"));
                HashMap<String, String> bitBundleCache = new HashMap<String, String>();
                for (int j = 1; j < csvParsed.length; ++j) {
                    Object[] csvLine = csvParsed[j];
                    String bitstreamId = csvLine[idIndex];
                    String bundleName = (String)bitBundleCache.get(bitstreamId);
                    if (bundleName == null) {
                        Bitstream bitstream = (Bitstream)this.bitstreamService.findByIdOrLegacyId(context, bitstreamId);
                        if (bitstream != null) {
                            List<Bundle> bundles = bitstream.getBundles();
                            if (bundles != null && 0 < bundles.size()) {
                                Bundle bundle = bundles.get(0);
                                bundleName = bundle.getName();
                            } else {
                                DSpaceObject parentObject = this.bitstreamService.getParentObject(context, bitstream);
                                if (parentObject instanceof org.dspace.content.Collection) {
                                    bundleName = "LOGO-COLLECTION";
                                } else if (parentObject instanceof Community) {
                                    bundleName = "LOGO-COMMUNITY";
                                }
                            }
                            bitBundleCache.put(bitstream.getID().toString(), bundleName);
                        }
                        if (bundleName == null && !removeDeletedBitstreams) {
                            bundleName = "BITSTREAM_DELETED";
                        }
                    }
                    csvp.writeNext((String[])ArrayUtils.add((Object[])csvLine, (Object)bundleName));
                }
                csvp.flush();
                csvp.close();
                i += 10000;
            }
            for (File tempCsv : tempCsvFiles) {
                ContentStreamUpdateRequest contentStreamUpdateRequest = new ContentStreamUpdateRequest("/update/csv");
                contentStreamUpdateRequest.setParam("stream.contentType", "text/plain;charset=utf-8");
                contentStreamUpdateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                contentStreamUpdateRequest.addFile(tempCsv, "text/plain;charset=utf-8");
                this.solr.request((SolrRequest)contentStreamUpdateRequest);
            }
            this.solr.deleteByQuery("-bundleName:[* TO *] AND type:0");
            this.solr.commit(true, true);
            FileUtils.deleteDirectory((File)tempDirectory);
        }
        catch (Exception e) {
            log.error((Object)"Error while updating the bitstream statistics", (Throwable)e);
            throw e;
        }
        finally {
            context.abort();
        }
    }

    @Override
    public void exportHits() throws Exception {
        Context context = new Context();
        File tempDirectory = new File(this.configurationService.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
        tempDirectory.mkdirs();
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("*:*");
            ModifiableSolrParams solrParams = new ModifiableSolrParams();
            solrParams.set("q", new String[]{"statistics_type:view OR (*:* AND -statistics_type:*)"});
            solrParams.set("wt", new String[]{"javabin"});
            solrParams.set("rows", new String[]{String.valueOf(10000)});
            this.addAdditionalSolrYearCores(query);
            long totalRecords = this.solr.query((SolrParams)query).getResults().getNumFound();
            System.out.println("There are " + totalRecords + " usage events in SOLR for download/view.");
            int i = 0;
            while ((long)i < totalRecords) {
                solrParams.set("start", new String[]{String.valueOf(i)});
                QueryResponse queryResponse = this.solr.query((SolrParams)solrParams);
                SolrDocumentList docs = queryResponse.getResults();
                File exportOutput = new File(tempDirectory.getPath() + File.separatorChar + "usagestats_" + i + ".csv");
                exportOutput.delete();
                this.addDocumentsToFile(context, docs, exportOutput);
                System.out.println("Export hits [" + i + " - " + String.valueOf(i + 9999) + "] to " + exportOutput.getCanonicalPath());
                i += 10000;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while exporting SOLR data", (Throwable)e);
            throw e;
        }
        finally {
            context.abort();
        }
    }

    protected void addDocumentsToFile(Context context, SolrDocumentList docs, File exportOutput) throws SQLException, ParseException, IOException {
        for (SolrDocument doc : docs) {
            String ip = doc.get((Object)"ip").toString();
            if (ip.equals("::1")) {
                ip = "127.0.0.1";
            }
            String id = doc.get((Object)"id").toString();
            String type = doc.get((Object)"type").toString();
            String time = doc.get((Object)"time").toString();
            DSpaceObjectLegacySupportService<? extends DSpaceObject> dsoService = this.contentServiceFactory.getDSpaceLegacyObjectService(Integer.parseInt(type));
            DSpaceObject dso = dsoService.findByIdOrLegacyId(context, id);
            if (dso == null) {
                log.debug((Object)("Document no longer exists in DB. type:" + type + " id:" + id));
                continue;
            }
            SimpleDateFormat inputDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
            Date solrDate = inputDateFormat.parse(time);
            SimpleDateFormat outputDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String out = time + "," + "view_" + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso).toLowerCase() + "," + id + "," + outputDateFormat.format(solrDate) + ",anonymous," + ip + "\n";
            FileUtils.writeStringToFile((File)exportOutput, (String)out, (boolean)true);
        }
    }

    protected String generateURL(String baseURL, Map<String, String> parameters) throws UnsupportedEncodingException {
        boolean first = true;
        StringBuilder result = new StringBuilder(baseURL);
        for (String key : parameters.keySet()) {
            if (first) {
                result.append("?");
                first = false;
            } else {
                result.append("&");
            }
            result.append(key).append("=").append(URLEncoder.encode(parameters.get(key), "UTF-8"));
        }
        return result.toString();
    }

    protected void addAdditionalSolrYearCores(SolrQuery solrQuery) {
        if (0 < statisticYearCores.size()) {
            solrQuery.add("shards", new String[]{StringUtils.join(statisticYearCores.iterator(), (String)",")});
        }
    }

    public class ResultProcessor {
        public void execute(String query) throws SolrServerException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "10");
            if (0 < statisticYearCores.size()) {
                params.put("shards", StringUtils.join(statisticYearCores.iterator(), (char)','));
            }
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = SolrLoggerServiceImpl.this.solr.query((SolrParams)solrParams);
            long numbFound = response.getResults().getNumFound();
            this.process((List<SolrDocument>)response.getResults());
            int i = 10;
            while ((long)i < numbFound) {
                params.put("start", String.valueOf(i));
                solrParams = new MapSolrParams(params);
                response = SolrLoggerServiceImpl.this.solr.query((SolrParams)solrParams);
                this.process((List<SolrDocument>)response.getResults());
                i += 10;
            }
        }

        public void commit() throws IOException, SolrServerException {
            SolrLoggerServiceImpl.this.solr.commit();
        }

        public void process(List<SolrDocument> docs) throws IOException, SolrServerException {
            for (SolrDocument doc : docs) {
                this.process(doc);
            }
        }

        public void process(SolrDocument doc) throws IOException, SolrServerException {
        }
    }

    public static enum StatisticsType {
        VIEW("view"),
        SEARCH("search"),
        SEARCH_RESULT("search_result"),
        WORKFLOW("workflow");

        private final String text;

        private StatisticsType(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }
    }
}

