/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.importer.external.MetadataSourceException;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.ImportService;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.utils.DSpace;

public class XMLUIStartSubmissionLookupStep
extends AbstractProcessingStep {
    private static String publicationUrl = null;
    private static Logger log = Logger.getLogger(XMLUIStartSubmissionLookupStep.class);
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, AuthorizeException, SQLException {
        String publicationID = request.getParameter("publication_id");
        if (StringUtils.isNotBlank((String)publicationID)) {
            ImportService importService = (ImportService)new DSpace().getServiceManager().getServiceByName(null, ImportService.class);
            Item item = subInfo.getSubmissionItem().getItem();
            try {
                ImportRecord record = importService.getRecord(this.getPublicationUrl(), publicationID);
                for (MetadataValue metadataValue : this.itemService.getMetadata(item, "*", "*", "*", "*")) {
                    this.itemService.clearMetadata(context, item, metadataValue.getMetadataField().getMetadataSchema().getName(), metadataValue.getMetadataField().getElement(), metadataValue.getMetadataField().getQualifier(), metadataValue.getLanguage());
                }
                for (MetadatumDTO metadatumDTO : record.getValueList()) {
                    this.itemService.addMetadata(context, item, metadatumDTO.getSchema(), metadatumDTO.getElement(), metadatumDTO.getQualifier(), null, metadatumDTO.getValue());
                }
                this.itemService.update(context, item);
                context.dispatchEvents();
            }
            catch (MetadataSourceException e) {
                log.error((Object)e);
            }
        }
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }

    public String getPublicationUrl() {
        if (publicationUrl == null) {
            publicationUrl = this.configurationService.getProperty("publication-lookup.publication.url");
        }
        return publicationUrl;
    }
}

