/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.usage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dspace.core.Constants;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabFileUsageEventListener
extends AbstractUsageEventListener {
    private static final Logger errorLog = LoggerFactory.getLogger(TabFileUsageEventListener.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
    private PrintWriter eventLog;
    private boolean initialized = false;

    private void init() {
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        String logPath = (String)configurationService.getPropertyAsType("usageEvent.tabFileLogger.file", (Object)"usage-events.tsv");
        String logDir = null;
        if (!new File(logPath).isAbsolute()) {
            logDir = configurationService.getProperty("log.dir");
        }
        File logFile = new File(logDir, logPath);
        try {
            this.eventLog = new PrintWriter(new OutputStreamWriter(new FileOutputStream(logFile, true)));
            errorLog.debug("Writing to {}", (Object)logFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            errorLog.error("{} cannot open file, will not log events:  {}", (Object)TabFileUsageEventListener.class.getName(), (Object)e.getMessage());
            throw new IllegalArgumentException("Cannot open event log file", e);
        }
        if (logFile.length() <= 0L) {
            this.eventLog.println("date\tevent\tobjectType\tobjectId\tsessionId\tsourceAddress\teperson");
        }
        this.initialized = true;
    }

    public synchronized void receiveEvent(Event event) {
        if (!this.initialized) {
            this.init();
        }
        if (errorLog.isDebugEnabled()) {
            errorLog.debug("got: {}", (Object)event.toString());
        }
        if (!(event instanceof UsageEvent)) {
            return;
        }
        if (null == this.eventLog) {
            return;
        }
        UsageEvent ue = (UsageEvent)event;
        this.eventLog.append(dateFormat.format(new Date())).append('\t').append(ue.getName()).append('\t').append(Constants.typeText[ue.getObject().getType()]).append('\t').append(ue.getObject().getID().toString()).append('\t').append(ue.getRequest().getSession().getId()).append('\t').append(ue.getRequest().getRemoteAddr());
        String epersonName = null == ue.getContext().getCurrentUser() ? "anonymous" : ue.getContext().getCurrentUser().getEmail();
        this.eventLog.append('\t').append(epersonName);
        this.eventLog.println();
        this.eventLog.flush();
    }
}

