/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning.dao.impl;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.Item;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.dao.VersionDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class VersionDAOImpl
extends AbstractHibernateDAO<Version>
implements VersionDAO {
    protected VersionDAOImpl() {
    }

    @Override
    public Version findByItem(Context context, Item item) throws SQLException {
        Criteria criteria = this.createCriteria(context, Version.class);
        criteria.add((Criterion)Restrictions.eq((String)"item", (Object)item));
        return (Version)this.singleResult(criteria);
    }

    @Override
    public int getNextVersionNumber(Context c, VersionHistory vh) throws SQLException {
        Query q = this.createQuery(c, "SELECT (COALESCE(MAX(versionNumber), 0) + 1) FROM Version WHERE versionHistory.id = :historyId");
        q.setParameter("historyId", (Object)vh.getId());
        int next = (Integer)q.uniqueResult();
        return next;
    }

    @Override
    public List<Version> findVersionsWithItems(Context context, VersionHistory versionHistory) throws SQLException {
        Criteria criteria = this.createCriteria(context, Version.class);
        criteria.add((Criterion)Restrictions.eq((String)"versionHistory", (Object)versionHistory));
        criteria.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.isNotNull((String)"item")}));
        criteria.addOrder(Order.desc((String)"versionNumber"));
        return this.list(criteria);
    }
}

