/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.dao.PoolTaskDAO;
import org.dspace.xmlworkflow.storedcomponents.service.InProgressUserService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.springframework.beans.factory.annotation.Autowired;

public class PoolTaskServiceImpl
implements PoolTaskService {
    @Autowired(required=true)
    protected PoolTaskDAO poolTaskDAO;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected InProgressUserService inProgressUserService;

    protected PoolTaskServiceImpl() {
    }

    @Override
    public List<PoolTask> findByEperson(Context context, EPerson ePerson) throws SQLException, AuthorizeException, IOException {
        List<PoolTask> result = this.poolTaskDAO.findByEPerson(context, ePerson);
        List<Group> groups = this.groupService.allMemberGroups(context, ePerson);
        result.addAll(this.findByGroups(context, ePerson, groups));
        return result;
    }

    protected List<PoolTask> findByGroups(Context context, EPerson ePerson, List<Group> groups) throws SQLException {
        ArrayList<PoolTask> result = new ArrayList<PoolTask>();
        for (Group group : groups) {
            List<PoolTask> groupTasks = this.poolTaskDAO.findByGroup(context, group);
            for (PoolTask poolTask : groupTasks) {
                XmlWorkflowItem workflowItem = poolTask.getWorkflowItem();
                if (this.inProgressUserService.findByWorkflowItemAndEPerson(context, workflowItem, ePerson) != null) continue;
                result.add(poolTask);
            }
        }
        return result;
    }

    @Override
    public List<PoolTask> find(Context context, XmlWorkflowItem workflowItem) throws SQLException {
        return this.poolTaskDAO.findByWorkflowItem(context, workflowItem);
    }

    @Override
    public PoolTask findByWorkflowIdAndEPerson(Context context, XmlWorkflowItem workflowItem, EPerson ePerson) throws SQLException, AuthorizeException, IOException {
        PoolTask poolTask = this.poolTaskDAO.findByWorkflowItemAndEPerson(context, workflowItem, ePerson);
        if (poolTask != null) {
            return poolTask;
        }
        if (this.inProgressUserService.findByWorkflowItemAndEPerson(context, workflowItem, ePerson) != null) {
            return null;
        }
        List<Group> groups = this.groupService.allMemberGroups(context, ePerson);
        for (Group group : groups) {
            poolTask = this.poolTaskDAO.findByWorkflowItemAndGroup(context, group, workflowItem);
            if (poolTask == null) continue;
            return poolTask;
        }
        return null;
    }

    @Override
    public void deleteByWorkflowItem(Context context, XmlWorkflowItem xmlWorkflowItem) throws SQLException, AuthorizeException {
        List<PoolTask> tasks = this.find(context, xmlWorkflowItem);
        Iterator<PoolTask> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            PoolTask poolTask = iterator.next();
            iterator.remove();
            this.delete(context, poolTask);
        }
    }

    @Override
    public List<PoolTask> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        return this.poolTaskDAO.findByEPerson(context, ePerson);
    }

    @Override
    public PoolTask create(Context context) throws SQLException, AuthorizeException {
        return this.poolTaskDAO.create(context, new PoolTask());
    }

    @Override
    public PoolTask find(Context context, int id) throws SQLException {
        return (PoolTask)this.poolTaskDAO.findByID(context, PoolTask.class, id);
    }

    @Override
    public void update(Context context, PoolTask poolTask) throws SQLException, AuthorizeException {
        this.poolTaskDAO.save(context, poolTask);
    }

    @Override
    public void delete(Context context, PoolTask poolTask) throws SQLException, AuthorizeException {
        this.poolTaskDAO.delete(context, poolTask);
    }
}

