/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.dao.WorkflowItemRoleDAO;
import org.dspace.xmlworkflow.storedcomponents.service.WorkflowItemRoleService;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowItemRoleServiceImpl
implements WorkflowItemRoleService {
    @Autowired(required=true)
    private WorkflowItemRoleDAO workflowItemRoleDAO;

    protected WorkflowItemRoleServiceImpl() {
    }

    @Override
    public List<WorkflowItemRole> find(Context context, XmlWorkflowItem workflowItem, String role) throws SQLException {
        return this.workflowItemRoleDAO.findByWorkflowItemAndRole(context, workflowItem, role);
    }

    @Override
    public List<WorkflowItemRole> findByWorkflowItem(Context context, XmlWorkflowItem xmlWorkflowItem) throws SQLException {
        return this.workflowItemRoleDAO.findByWorkflowItem(context, xmlWorkflowItem);
    }

    @Override
    public void deleteForWorkflowItem(Context context, XmlWorkflowItem xmlWorkflowItem) throws SQLException, AuthorizeException {
        Iterator<WorkflowItemRole> workflowItemRoles = this.findByWorkflowItem(context, xmlWorkflowItem).iterator();
        while (workflowItemRoles.hasNext()) {
            WorkflowItemRole workflowItemRole = workflowItemRoles.next();
            workflowItemRoles.remove();
            this.delete(context, workflowItemRole);
        }
    }

    @Override
    public List<WorkflowItemRole> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        return this.workflowItemRoleDAO.findByEPerson(context, ePerson);
    }

    @Override
    public WorkflowItemRole create(Context context) throws SQLException, AuthorizeException {
        return this.workflowItemRoleDAO.create(context, new WorkflowItemRole());
    }

    @Override
    public WorkflowItemRole find(Context context, int id) throws SQLException {
        return (WorkflowItemRole)this.workflowItemRoleDAO.findByID(context, WorkflowItemRole.class, id);
    }

    @Override
    public void update(Context context, WorkflowItemRole workflowItemRole) throws SQLException, AuthorizeException {
        this.workflowItemRoleDAO.save(context, workflowItemRole);
    }

    @Override
    public void delete(Context context, WorkflowItemRole workflowItemRole) throws SQLException, AuthorizeException {
        this.workflowItemRoleDAO.delete(context, workflowItemRole);
    }
}

