/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemSubmitterStrategy;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestItemMetadataStrategy
extends RequestItemSubmitterStrategy {
    protected String emailMetadata;
    protected String fullNameMatadata;
    @Autowired(required=true)
    protected ItemService itemService;

    @Override
    public RequestItemAuthor getRequestItemAuthor(Context context, Item item) throws SQLException {
        List<MetadataValue> vals;
        if (this.emailMetadata != null && (vals = this.itemService.getMetadataByMetadataString(item, this.emailMetadata)).size() > 0) {
            List<MetadataValue> nameVals;
            String email = vals.iterator().next().getValue();
            String fullname = null;
            if (this.fullNameMatadata != null && (nameVals = this.itemService.getMetadataByMetadataString(item, this.fullNameMatadata)).size() > 0) {
                fullname = nameVals.iterator().next().getValue();
            }
            if (StringUtils.isBlank(fullname)) {
                fullname = I18nUtil.getMessage("org.dspace.app.requestitem.RequestItemMetadataStrategy.unnamed", context);
            }
            RequestItemAuthor author = new RequestItemAuthor(fullname, email);
            return author;
        }
        return super.getRequestItemAuthor(context, item);
    }

    public void setEmailMetadata(String emailMetadata) {
        this.emailMetadata = emailMetadata;
    }

    public void setFullNameMatadata(String fullNameMatadata) {
        this.fullNameMatadata = fullNameMatadata;
    }
}

