/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.ConfigurationManager;

public class CollectionDropDown {
    public static String collectionPath(Collection col) throws SQLException {
        return CollectionDropDown.collectionPath(col, 0);
    }

    public static String collectionPath(Collection col, int maxchars) throws SQLException {
        int len;
        String separator = ConfigurationManager.getProperty("subcommunity.separator");
        if (separator == null) {
            separator = " > ";
        }
        List<Community> getCom = null;
        StringBuffer name = new StringBuffer("");
        getCom = col.getCommunities();
        for (Community com : getCom) {
            name.insert(0, com.getName() + separator);
        }
        name.append(col.getName());
        if (maxchars != 0 && (len = name.length()) > maxchars) {
            name = new StringBuffer(name.substring(len - (maxchars - 1), len));
            name.insert(0, "\u2026");
        }
        return name.toString();
    }

    public static CollectionPathEntry[] annotateWithPaths(List<Collection> collections) throws SQLException {
        Object[] result = new CollectionPathEntry[collections.size()];
        for (int i = 0; i < collections.size(); ++i) {
            Collection collection = collections.get(i);
            CollectionPathEntry entry = new CollectionPathEntry(collection, CollectionDropDown.collectionPath(collection));
            result[i] = entry;
        }
        Arrays.sort(result);
        return result;
    }

    public static class CollectionPathEntry
    implements Comparable<CollectionPathEntry> {
        public Collection collection;
        public String path;

        public CollectionPathEntry(Collection collection, String path) {
            this.collection = collection;
            this.path = path;
        }

        @Override
        public int compareTo(CollectionPathEntry other) {
            if (!this.path.equals(other.path)) {
                return this.path.compareTo(other.path);
            }
            return this.collection.getID().compareTo(other.collection.getID());
        }

        public boolean equals(Object o) {
            return o != null && o instanceof CollectionPathEntry && this.compareTo((CollectionPathEntry)o) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.collection.getID());
        }
    }
}

