/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.Item;
import org.dspace.content.dao.BundleDAO;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.event.Event;
import org.springframework.beans.factory.annotation.Autowired;

public class BundleServiceImpl
extends DSpaceObjectServiceImpl<Bundle>
implements BundleService {
    private static Logger log = Logger.getLogger(Bundle.class);
    @Autowired(required=true)
    protected BundleDAO bundleDAO;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;

    protected BundleServiceImpl() {
    }

    @Override
    public Bundle find(Context context, UUID id) throws SQLException {
        Bundle bundle = (Bundle)this.bundleDAO.findByID(context, Bundle.class, id);
        if (bundle == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_bundle", "not_found,bundle_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bundle", "bundle_id=" + id));
        }
        return bundle;
    }

    @Override
    public Bundle create(Context context, Item item, String name) throws SQLException, AuthorizeException {
        if (StringUtils.isBlank((String)name)) {
            throw new SQLException("Bundle must be created with non-null name");
        }
        this.authorizeService.authorizeAction(context, item, 3);
        Bundle bundle = this.bundleDAO.create(context, new Bundle());
        bundle.setName(context, name);
        this.itemService.addBundle(context, item, bundle);
        if (!bundle.getItems().contains(item)) {
            bundle.addItem(item);
        }
        log.info((Object)LogManager.getHeader(context, "create_bundle", "bundle_id=" + bundle.getID()));
        context.addEvent(new Event(1, 1, bundle.getID(), null));
        return bundle;
    }

    @Override
    public Bitstream getBitstreamByName(Bundle bundle, String name) {
        Bitstream target = null;
        for (Bitstream bitstream : bundle.getBitstreams()) {
            if (!name.equals(bitstream.getName())) continue;
            target = bitstream;
            break;
        }
        return target;
    }

    @Override
    public void addBitstream(Context context, Bundle bundle, Bitstream bitstream) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, bundle, 3);
        log.info((Object)LogManager.getHeader(context, "add_bitstream", "bundle_id=" + bundle.getID() + ",bitstream_id=" + bitstream.getID()));
        List<Bitstream> bitstreams = bundle.getBitstreams();
        boolean topOrder = false;
        for (Bitstream bs : bitstreams) {
            if (!bitstream.getID().equals(bs.getID())) continue;
            return;
        }
        bundle.addBitstream(bitstream);
        bitstream.getBundles().add(bundle);
        context.addEvent(new Event(8, 1, bundle.getID(), 0, bitstream.getID(), String.valueOf(bitstream.getSequenceID()), this.getIdentifiers(context, bundle)));
        this.authorizeService.inheritPolicies(context, bundle, bitstream);
        this.bitstreamService.update(context, bitstream);
    }

    @Override
    public void removeBitstream(Context context, Bundle bundle, Bitstream bitstream) throws AuthorizeException, SQLException, IOException {
        this.authorizeService.authorizeAction(context, bundle, 4);
        log.info((Object)LogManager.getHeader(context, "remove_bitstream", "bundle_id=" + bundle.getID() + ",bitstream_id=" + bitstream.getID()));
        bundle.getBitstreams().remove(bitstream);
        bitstream.getBundles().remove(bundle);
        context.addEvent(new Event(16, 1, bundle.getID(), 0, bitstream.getID(), String.valueOf(bitstream.getSequenceID()), this.getIdentifiers(context, bundle)));
        Item owningItem = (Item)this.getParentObject(context, bundle);
        if (owningItem != null) {
            this.itemService.updateLastModified(context, owningItem);
            this.itemService.update(context, owningItem);
        }
        if (bitstream.equals(bundle.getPrimaryBitstream())) {
            bundle.unsetPrimaryBitstreamID();
        }
        this.bitstreamService.delete(context, bitstream);
    }

    @Override
    public void inheritCollectionDefaultPolicies(Context context, Bundle bundle, Collection collection) throws SQLException, AuthorizeException {
        List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, collection, 9);
        Iterator<ResourcePolicy> i = policies.iterator();
        if (!i.hasNext()) {
            throw new SQLException("Collection " + collection.getID() + " has no default bitstream READ policies");
        }
        ArrayList<ResourcePolicy> newPolicies = new ArrayList<ResourcePolicy>();
        while (i.hasNext()) {
            ResourcePolicy rp = this.resourcePolicyService.clone(context, i.next());
            rp.setAction(0);
            newPolicies.add(rp);
        }
        this.replaceAllBitstreamPolicies(context, bundle, newPolicies);
    }

    @Override
    public void replaceAllBitstreamPolicies(Context context, Bundle bundle, List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        List<Bitstream> bitstreams = bundle.getBitstreams();
        if (CollectionUtils.isNotEmpty(bitstreams)) {
            for (Bitstream bs : bitstreams) {
                this.authorizeService.removeAllPolicies(context, bs);
                this.authorizeService.addPolicies(context, newpolicies, bs);
            }
        }
        this.authorizeService.removeAllPolicies(context, bundle);
        this.authorizeService.addPolicies(context, newpolicies, bundle);
    }

    @Override
    public List<ResourcePolicy> getBitstreamPolicies(Context context, Bundle bundle) throws SQLException {
        ArrayList<ResourcePolicy> list = new ArrayList<ResourcePolicy>();
        List<Bitstream> bitstreams = bundle.getBitstreams();
        if (CollectionUtils.isNotEmpty(bitstreams)) {
            for (Bitstream bs : bitstreams) {
                list.addAll(this.authorizeService.getPolicies(context, bs));
            }
        }
        return list;
    }

    @Override
    public List<ResourcePolicy> getBundlePolicies(Context context, Bundle bundle) throws SQLException {
        return this.authorizeService.getPolicies(context, bundle);
    }

    @Override
    public void setOrder(Context context, Bundle bundle, UUID[] bitstreamIds) throws AuthorizeException, SQLException {
        this.authorizeService.authorizeAction(context, bundle, 1);
        bundle.getBitstreams().clear();
        for (int i = 0; i < bitstreamIds.length; ++i) {
            UUID bitstreamId = bitstreamIds[i];
            Bitstream bitstream = (Bitstream)this.bitstreamService.find(context, bitstreamId);
            if (bitstream == null) {
                log.warn((Object)LogManager.getHeader(context, "Invalid bitstream id while changing bitstream order", "Bundle: " + bundle.getID() + ", bitstream id: " + bitstreamId));
                continue;
            }
            bitstream.getBundles().remove(bundle);
            bundle.getBitstreams().add(bitstream);
            bitstream.getBundles().add(bundle);
            this.bitstreamService.update(context, bitstream);
        }
        Item owningItem = (Item)this.getParentObject(context, bundle);
        if (owningItem != null) {
            this.itemService.updateLastModified(context, owningItem);
            this.itemService.update(context, owningItem);
        }
    }

    @Override
    public DSpaceObject getAdminObject(Context context, Bundle bundle, int action) throws SQLException {
        DSpaceObject adminObject = null;
        Item item = (Item)this.getParentObject(context, bundle);
        Collection collection = null;
        Community community = null;
        if (item != null && (collection = item.getOwningCollection()) != null) {
            community = collection.getCommunities().iterator().next();
        }
        switch (action) {
            case 4: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamDeletion()) {
                    adminObject = item;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamDeletion()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamDeletion()) break;
                adminObject = community;
                break;
            }
            case 3: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamCreation()) {
                    adminObject = item;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamCreation()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamCreation()) break;
                adminObject = community;
                break;
            }
            default: {
                adminObject = bundle;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject(Context context, Bundle bundle) throws SQLException {
        List<Item> items = bundle.getItems();
        if (CollectionUtils.isNotEmpty(items)) {
            return items.iterator().next();
        }
        return null;
    }

    @Override
    public void updateLastModified(Context context, Bundle dso) {
    }

    @Override
    public void update(Context context, Bundle bundle) throws SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(context, "update_bundle", "bundle_id=" + bundle.getID()));
        super.update(context, bundle);
        this.bundleDAO.save(context, bundle);
        if (bundle.isModified() || bundle.isMetadataModified()) {
            if (bundle.isMetadataModified()) {
                context.addEvent(new Event(4, bundle.getType(), bundle.getID(), bundle.getDetails(), this.getIdentifiers(context, bundle)));
            }
            context.addEvent(new Event(2, 1, bundle.getID(), null, this.getIdentifiers(context, bundle)));
            bundle.clearModified();
            bundle.clearDetails();
        }
    }

    @Override
    public void delete(Context context, Bundle bundle) throws SQLException, AuthorizeException, IOException {
        log.info((Object)LogManager.getHeader(context, "delete_bundle", "bundle_id=" + bundle.getID()));
        this.authorizeService.authorizeAction(context, bundle, 2);
        context.addEvent(new Event(32, 1, bundle.getID(), bundle.getName(), this.getIdentifiers(context, bundle)));
        Iterator<Bitstream> bitstreams = bundle.getBitstreams().iterator();
        while (bitstreams.hasNext()) {
            Bitstream bitstream = bitstreams.next();
            bitstreams.remove();
            this.removeBitstream(context, bundle, bitstream);
        }
        for (Item item : bundle.getItems()) {
            item.removeBundle(bundle);
        }
        this.authorizeService.removeAllPolicies(context, bundle);
        this.bundleDAO.delete(context, bundle);
    }

    @Override
    public int getSupportsTypeConstant() {
        return 1;
    }

    @Override
    public Bundle findByIdOrLegacyId(Context context, String id) throws SQLException {
        if (StringUtils.isNumeric((String)id)) {
            return this.findByLegacyId(context, Integer.parseInt(id));
        }
        return this.find(context, UUID.fromString(id));
    }

    @Override
    public Bundle findByLegacyId(Context context, int id) throws SQLException {
        return this.bundleDAO.findByLegacyId(context, id, Bundle.class);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.bundleDAO.countRows(context);
    }
}

