/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DSpaceObjectServiceImpl<T extends DSpaceObject>
implements DSpaceObjectService<T> {
    private static final Logger log = Logger.getLogger(DSpaceObjectServiceImpl.class);
    @Autowired(required=true)
    protected ChoiceAuthorityService choiceAuthorityService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected MetadataValueService metadataValueService;
    @Autowired(required=true)
    protected MetadataFieldService metadataFieldService;
    @Autowired(required=true)
    protected MetadataAuthorityService metadataAuthorityService;

    @Override
    public String getName(T dso) {
        String value = this.getMetadataFirstValue(dso, "dc", "title", null, "*");
        return value == null ? "" : value;
    }

    @Override
    public ArrayList<String> getIdentifiers(Context context, T dso) {
        ArrayList<String> identifiers = new ArrayList<String>();
        IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
        if (identifierService != null) {
            identifiers.addAll(identifierService.lookup(context, (DSpaceObject)dso));
        } else {
            log.warn((Object)"No IdentifierService found, will return an list containing the Handle only.");
            if (((DSpaceObject)dso).getHandle() != null) {
                identifiers.add(this.handleService.getCanonicalForm(((DSpaceObject)dso).getHandle()));
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder dbgMsg = new StringBuilder();
            for (String id : identifiers) {
                if (dbgMsg.capacity() == 0) {
                    dbgMsg.append("This DSO's Identifiers are: ");
                } else {
                    dbgMsg.append(", ");
                }
                dbgMsg.append(id);
            }
            dbgMsg.append(".");
            log.debug((Object)dbgMsg.toString());
        }
        return identifiers;
    }

    @Override
    public DSpaceObject getParentObject(Context context, T dso) throws SQLException {
        return null;
    }

    @Override
    public DSpaceObject getAdminObject(Context context, T dso, int action) throws SQLException {
        if (action == 11) {
            throw new IllegalArgumentException("Illegal call to the DSpaceObject.getAdminObject method");
        }
        return dso;
    }

    @Override
    public String getTypeText(T dso) {
        return Constants.typeText[((DSpaceObject)dso).getType()];
    }

    @Override
    public List<MetadataValue> getMetadata(T dso, String schema, String element, String qualifier, String lang) {
        ArrayList<MetadataValue> values = new ArrayList<MetadataValue>();
        for (MetadataValue dcv : ((DSpaceObject)dso).getMetadata()) {
            if (!this.match(schema, element, qualifier, lang, dcv)) continue;
            values.add(dcv);
        }
        return values;
    }

    @Override
    public List<MetadataValue> getMetadataByMetadataString(T dso, String mdString) {
        StringTokenizer dcf = new StringTokenizer(mdString, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        String schema = tokens[0];
        String element = tokens[1];
        String qualifier = tokens[2];
        List<MetadataValue> values = "*".equals(qualifier) ? this.getMetadata(dso, schema, element, "*", "*") : ("".equals(qualifier) ? this.getMetadata(dso, schema, element, null, "*") : this.getMetadata(dso, schema, element, qualifier, "*"));
        return values;
    }

    @Override
    public String getMetadata(T dso, String value) {
        List<MetadataValue> metadataValues = this.getMetadataByMetadataString(dso, value);
        if (CollectionUtils.isNotEmpty(metadataValues)) {
            return metadataValues.iterator().next().getValue();
        }
        return null;
    }

    @Override
    public List<MetadataValue> getMetadata(T dso, String mdString, String authority) {
        String[] elements = this.getElements(mdString);
        return this.getMetadata(dso, elements[0], elements[1], elements[2], elements[3], authority);
    }

    @Override
    public List<MetadataValue> getMetadata(T dso, String schema, String element, String qualifier, String lang, String authority) {
        List<MetadataValue> metadata = this.getMetadata(dso, schema, element, qualifier, lang);
        ArrayList<MetadataValue> result = new ArrayList<MetadataValue>(metadata);
        if (!authority.equals("*")) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                MetadataValue metadataValue = (MetadataValue)iterator.next();
                if (authority.equals(metadataValue.getAuthority())) continue;
                iterator.remove();
            }
        }
        return result;
    }

    @Override
    public void addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, List<String> values) throws SQLException {
        MetadataField metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier);
        if (metadataField == null) {
            throw new SQLException("bad_dublin_core schema=" + schema + "." + element + "." + qualifier);
        }
        this.addMetadata(context, dso, metadataField, lang, values);
    }

    @Override
    public void addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, List<String> values, List<String> authorities, List<Integer> confidences) throws SQLException {
        MetadataField metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier);
        if (metadataField == null) {
            throw new SQLException("bad_dublin_core schema=" + schema + "." + element + "." + qualifier);
        }
        this.addMetadata(context, dso, metadataField, lang, values, authorities, confidences);
    }

    @Override
    public void addMetadata(Context context, T dso, MetadataField metadataField, String lang, List<String> values, List<String> authorities, List<Integer> confidences) throws SQLException {
        boolean authorityControlled = this.metadataAuthorityService.isAuthorityControlled(metadataField);
        boolean authorityRequired = this.metadataAuthorityService.isAuthorityRequired(metadataField);
        for (int i = 0; i < values.size(); ++i) {
            MetadataValue metadataValue = this.metadataValueService.create(context, (DSpaceObject)dso, metadataField);
            metadataValue.setLanguage(lang == null ? null : lang.trim());
            if (authorityControlled) {
                if (authorities != null && authorities.get(i) != null && authorities.get(i).length() > 0) {
                    metadataValue.setAuthority(authorities.get(i));
                    metadataValue.setConfidence(confidences == null ? 0 : confidences.get(i));
                } else {
                    metadataValue.setAuthority(null);
                    metadataValue.setConfidence(confidences == null ? -1 : confidences.get(i));
                }
                if (authorityRequired && (metadataValue.getAuthority() == null || metadataValue.getAuthority().length() == 0)) {
                    throw new IllegalArgumentException("The metadata field \"" + metadataField.toString() + "\" requires an authority key but none was provided. Value=\"" + values.get(i) + "\"");
                }
            }
            if (values.get(i) != null) {
                String temp = values.get(i).trim();
                char[] dcvalue = temp.toCharArray();
                for (int charPos = 0; charPos < dcvalue.length; ++charPos) {
                    if (!Character.isISOControl(dcvalue[charPos]) || String.valueOf(dcvalue[charPos]).equals("\t") || String.valueOf(dcvalue[charPos]).equals("\n") || String.valueOf(dcvalue[charPos]).equals("\r")) continue;
                    dcvalue[charPos] = 32;
                }
                metadataValue.setValue(String.valueOf(dcvalue));
            } else {
                metadataValue.setValue(null);
            }
            ((DSpaceObject)dso).addDetails(metadataField.toString());
        }
    }

    @Override
    public void addMetadata(Context context, T dso, MetadataField metadataField, String language, String value, String authority, int confidence) throws SQLException {
        this.addMetadata(context, dso, metadataField, language, Arrays.asList(value), Arrays.asList(authority), Arrays.asList(confidence));
    }

    @Override
    public void addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, String value) throws SQLException {
        this.addMetadata(context, dso, schema, element, qualifier, lang, Arrays.asList(value));
    }

    @Override
    public void addMetadata(Context context, T dso, MetadataField metadataField, String language, String value) throws SQLException {
        this.addMetadata(context, dso, metadataField, language, Arrays.asList(value));
    }

    @Override
    public void addMetadata(Context context, T dso, MetadataField metadataField, String language, List<String> values) throws SQLException {
        if (metadataField != null) {
            String fieldKey = this.metadataAuthorityService.makeFieldKey(metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier());
            if (this.metadataAuthorityService.isAuthorityControlled(fieldKey)) {
                ArrayList<String> authorities = new ArrayList<String>();
                ArrayList<Integer> confidences = new ArrayList<Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    if (dso instanceof Item) {
                        this.getAuthoritiesAndConfidences(fieldKey, ((Item)dso).getOwningCollection(), values, authorities, confidences, i);
                        continue;
                    }
                    this.getAuthoritiesAndConfidences(fieldKey, null, values, authorities, confidences, i);
                }
                this.addMetadata(context, dso, metadataField, language, values, authorities, confidences);
            } else {
                this.addMetadata(context, dso, metadataField, language, values, null, null);
            }
        }
    }

    @Override
    public void addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, String value, String authority, int confidence) throws SQLException {
        this.addMetadata(context, dso, schema, element, qualifier, lang, Arrays.asList(value), Arrays.asList(authority), Arrays.asList(confidence));
    }

    @Override
    public void clearMetadata(Context context, T dso, String schema, String element, String qualifier, String lang) throws SQLException {
        Iterator<MetadataValue> metadata = ((DSpaceObject)dso).getMetadata().iterator();
        while (metadata.hasNext()) {
            MetadataValue metadataValue = metadata.next();
            if (!this.match(schema, element, qualifier, lang, metadataValue)) continue;
            metadataValue.setDSpaceObject(null);
            metadata.remove();
        }
        ((DSpaceObject)dso).setMetadataModified();
    }

    @Override
    public void removeMetadataValues(Context context, T dso, List<MetadataValue> values) throws SQLException {
        Iterator<MetadataValue> metadata = ((DSpaceObject)dso).getMetadata().iterator();
        while (metadata.hasNext()) {
            MetadataValue metadataValue = metadata.next();
            if (!values.contains(metadataValue)) continue;
            metadata.remove();
        }
        ((DSpaceObject)dso).setMetadataModified();
    }

    @Override
    public String getMetadataFirstValue(T dso, String schema, String element, String qualifier, String language) {
        List<MetadataValue> metadataValues = this.getMetadata(dso, schema, element, qualifier, language);
        if (CollectionUtils.isNotEmpty(metadataValues)) {
            return metadataValues.iterator().next().getValue();
        }
        return null;
    }

    @Override
    public void setMetadataSingleValue(Context context, T dso, String schema, String element, String qualifier, String language, String value) throws SQLException {
        if (value != null) {
            this.clearMetadata(context, dso, schema, element, qualifier, language);
            this.addMetadata(context, dso, schema, element, qualifier, language, value);
            ((DSpaceObject)dso).setMetadataModified();
        }
    }

    protected boolean match(String schema, String element, String qualifier, String language, MetadataValue metadataValue) {
        MetadataField metadataField = metadataValue.getMetadataField();
        MetadataSchema metadataSchema = metadataField.getMetadataSchema();
        if (!element.equals("*") && !element.equals(metadataField.getElement())) {
            return false;
        }
        if (qualifier == null ? metadataField.getQualifier() != null : !qualifier.equals("*") && !qualifier.equals(metadataField.getQualifier())) {
            return false;
        }
        if (language == null ? metadataValue.getLanguage() != null : !language.equals("*") && !language.equals(metadataValue.getLanguage())) {
            return false;
        }
        return schema.equals("*") || metadataSchema == null || metadataSchema.getName().equals(schema);
    }

    protected void getAuthoritiesAndConfidences(String fieldKey, Collection collection, List<String> values, List<String> authorities, List<Integer> confidences, int i) {
        Choices c = this.choiceAuthorityService.getBestMatch(fieldKey, values.get(i), null, null);
        authorities.add(c.values.length > 0 ? c.values[0].authority : null);
        confidences.add(c.confidence);
    }

    protected String[] getElements(String fieldName) {
        Object[] tokens = StringUtils.split((String)fieldName, (String)".");
        int add = 4 - tokens.length;
        if (add > 0) {
            tokens = (String[])ArrayUtils.addAll((Object[])tokens, (Object[])new String[add]);
        }
        return tokens;
    }

    protected String[] getElementsFilled(String fieldName) {
        String[] elements = this.getElements(fieldName);
        for (int i = 0; i < elements.length; ++i) {
            if (!StringUtils.isBlank((String)elements[i])) continue;
            elements[i] = "*";
        }
        return elements;
    }

    protected String[] getMDValueByField(String field) {
        StringTokenizer dcf = new StringTokenizer(field, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        if (i != 0) {
            return tokens;
        }
        return this.getMDValueByLegacyField(field);
    }

    @Override
    public void update(Context context, T dso) throws SQLException, AuthorizeException {
        if (((DSpaceObject)dso).isMetadataModified()) {
            HashMap<MetadataField, Integer> fieldToLastPlace = new HashMap<MetadataField, Integer>();
            List<MetadataValue> metadataValues = ((DSpaceObject)dso).getMetadata();
            for (MetadataValue metadataValue : metadataValues) {
                int mvPlace = this.getMetadataValuePlace(fieldToLastPlace, metadataValue);
                metadataValue.setPlace(mvPlace);
            }
        }
    }

    protected int getMetadataValuePlace(Map<MetadataField, Integer> fieldToLastPlace, MetadataValue metadataValue) {
        MetadataField metadataField = metadataValue.getMetadataField();
        if (fieldToLastPlace.containsKey(metadataField)) {
            fieldToLastPlace.put(metadataField, fieldToLastPlace.get(metadataField) + 1);
        } else {
            fieldToLastPlace.put(metadataField, 0);
        }
        return fieldToLastPlace.get(metadataField);
    }

    protected String[] getMDValueByLegacyField(String field) {
        switch (field) {
            case "introductory_text": {
                return new String[]{"dc", "description", null};
            }
            case "short_description": {
                return new String[]{"dc", "description", "abstract"};
            }
            case "side_bar_text": {
                return new String[]{"dc", "description", "tableofcontents"};
            }
            case "copyright_text": {
                return new String[]{"dc", "rights", null};
            }
            case "name": {
                return new String[]{"dc", "title", null};
            }
            case "provenance_description": {
                return new String[]{"dc", "provenance", null};
            }
            case "license": {
                return new String[]{"dc", "rights", "license"};
            }
            case "user_format_description": {
                return new String[]{"dc", "format", null};
            }
            case "source": {
                return new String[]{"dc", "source", null};
            }
            case "firstname": {
                return new String[]{"eperson", "firstname", null};
            }
            case "lastname": {
                return new String[]{"eperson", "lastname", null};
            }
            case "phone": {
                return new String[]{"eperson", "phone", null};
            }
            case "language": {
                return new String[]{"eperson", "language", null};
            }
        }
        return new String[]{null, null, null};
    }
}

