/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dspace.core.DBConnection;
import org.dspace.core.ReloadableEntity;
import org.dspace.storage.rdbms.DatabaseConfigVO;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.proxy.HibernateProxyHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate4.SessionFactoryUtils;

public class HibernateDBConnection
implements DBConnection<Session> {
    @Autowired(required=true)
    @Qualifier(value="sessionFactory")
    private SessionFactory sessionFactory;
    private boolean batchModeEnabled = false;

    @Override
    public Session getSession() throws SQLException {
        if (!this.isTransActionAlive()) {
            this.sessionFactory.getCurrentSession().beginTransaction();
            this.configureBatchMode();
        }
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public boolean isTransActionAlive() {
        Transaction transaction = this.getTransaction();
        return transaction != null && transaction.isActive();
    }

    protected Transaction getTransaction() {
        return this.sessionFactory.getCurrentSession().getTransaction();
    }

    @Override
    public boolean isSessionAlive() {
        return this.sessionFactory.getCurrentSession() != null && this.sessionFactory.getCurrentSession().getTransaction() != null && this.sessionFactory.getCurrentSession().getTransaction().isActive();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.isTransActionAlive()) {
            this.getTransaction().rollback();
        }
    }

    @Override
    public void closeDBConnection() throws SQLException {
        if (this.sessionFactory.getCurrentSession() != null && this.sessionFactory.getCurrentSession().isOpen()) {
            this.sessionFactory.getCurrentSession().close();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.isTransActionAlive() && !this.getTransaction().wasRolledBack()) {
            this.getSession().flush();
            this.getTransaction().commit();
        }
    }

    @Override
    public synchronized void shutdown() {
        this.sessionFactory.close();
    }

    @Override
    public String getType() {
        return ((SessionFactoryImplementor)this.sessionFactory).getDialect().toString();
    }

    @Override
    public DataSource getDataSource() {
        return SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory);
    }

    @Override
    public DatabaseConfigVO getDatabaseConfig() throws SQLException {
        DatabaseConfigVO databaseConfigVO = new DatabaseConfigVO();
        try (Connection connection = this.getDataSource().getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            databaseConfigVO.setDatabaseDriver(metaData.getDriverName());
            databaseConfigVO.setDatabaseUrl(metaData.getURL());
            databaseConfigVO.setSchema(metaData.getSchemaTerm());
            databaseConfigVO.setMaxConnections(metaData.getMaxConnections());
            databaseConfigVO.setUserName(metaData.getUserName());
        }
        return databaseConfigVO;
    }

    @Override
    public void clearCache() throws SQLException {
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    public long getCacheSize() throws SQLException {
        return this.getSession().getStatistics().getEntityCount();
    }

    @Override
    public <E extends ReloadableEntity> E reloadEntity(E entity) throws SQLException {
        if (entity == null) {
            return null;
        }
        if (this.getSession().contains(entity)) {
            return entity;
        }
        return (E)((ReloadableEntity)this.getSession().get(HibernateProxyHelper.getClassWithoutInitializingProxy(entity), entity.getID()));
    }

    @Override
    public void setOptimizedForBatchProcessing(boolean batchOptimized) throws SQLException {
        this.batchModeEnabled = batchOptimized;
        this.configureBatchMode();
    }

    @Override
    public boolean isOptimizedForBatchProcessing() {
        return this.batchModeEnabled;
    }

    private void configureBatchMode() throws SQLException {
        if (this.batchModeEnabled) {
            this.getSession().setFlushMode(FlushMode.ALWAYS);
        } else {
            this.getSession().setFlushMode(FlushMode.AUTO);
        }
    }
}

