/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.pubmed.metadatamapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.dspace.importer.external.pubmed.metadatamapping.PubmedDateMetadatumContributor;

public class PubmedLanguageMetadatumContributor<T>
implements MetadataContributor<T> {
    Logger log = Logger.getLogger(PubmedDateMetadatumContributor.class);
    private MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping;
    private HashMap<String, String> iso3toIso2 = new HashMap();
    private MetadataFieldConfig field;
    private MetadataContributor language;

    public PubmedLanguageMetadatumContributor() {
        for (Locale locale : Locale.getAvailableLocales()) {
            this.iso3toIso2.put(locale.getISO3Language(), locale.getLanguage());
        }
    }

    public PubmedLanguageMetadatumContributor(MetadataFieldConfig field, MetadataContributor language) {
        this();
        this.field = field;
        this.language = language;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
        this.language.setMetadataFieldMapping(metadataFieldMapping);
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(T t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        try {
            LinkedList languageList = (LinkedList)this.language.contributeMetadata(t);
            for (MetadatumDTO metadatum : languageList) {
                values.add(this.metadataFieldMapping.toDCValue(this.field, this.iso3toIso2.get(metadatum.getValue().toLowerCase())));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error", (Throwable)e);
        }
        return values;
    }

    public MetadataContributor getLanguage() {
        return this.language;
    }

    public void setLanguage(MetadataContributor language) {
        this.language = language;
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }
}

