/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.pubmed.metadatamapping.service;

import java.util.List;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.importer.external.MetadataSourceException;
import org.dspace.importer.external.Query;
import org.dspace.importer.external.metadatamapping.service.GenerateQueryService;

public class GeneratePubmedQueryService
implements GenerateQueryService {
    @Override
    public Query generateQueryForItem(Item item) throws MetadataSourceException {
        Query query = new Query();
        ItemService itemService = ContentServiceFactory.getInstance().getItemService();
        List<MetadataValue> doi = itemService.getMetadata(item, "dc", "identifier", "doi", "*");
        if (doi.size() > 0) {
            query.addParameter("term", doi.get(0).getValue());
            query.addParameter("field", "ELocationID");
            return query;
        }
        List<MetadataValue> title = itemService.getMetadata(item, "dc", "title", null, "*");
        if (title.size() > 0) {
            query.addParameter("term", title.get(0).getValue());
            query.addParameter("field", "title");
            return query;
        }
        return null;
    }
}

