/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.MetadataSourceException;
import org.dspace.importer.external.Query;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.service.other.Destroyable;
import org.dspace.importer.external.service.other.Imports;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportService
implements Destroyable {
    private HashMap<String, Imports> importSources = new HashMap();
    Logger log = Logger.getLogger(ImportService.class);
    protected static final String ANY = "*";

    @Autowired(required=false)
    public void setImportSources(List<Imports> importSources) throws MetadataSourceException {
        this.log.info((Object)("Loading " + importSources.size() + " import sources."));
        for (Imports imports : importSources) {
            this.importSources.put(imports.getImportSource(), imports);
        }
    }

    protected Map<String, Imports> getImportSources() {
        return Collections.unmodifiableMap(this.importSources);
    }

    protected Collection<Imports> matchingImports(String url) {
        if (ANY.equals(url)) {
            return this.importSources.values();
        }
        if (this.importSources.containsKey(url)) {
            return Collections.singletonList(this.importSources.get(url));
        }
        return Collections.emptyList();
    }

    public Collection<ImportRecord> findMatchingRecords(String url, Item item) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (Imports imports : this.matchingImports(url)) {
                recordList.addAll(imports.findMatchingRecords(item));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> findMatchingRecords(String url, Query query) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (Imports imports : this.matchingImports(url)) {
                recordList.addAll(imports.findMatchingRecords(query));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public int getNbRecords(String url, String query) throws MetadataSourceException {
        try {
            int total = 0;
            for (Imports Imports2 : this.matchingImports(url)) {
                total += Imports2.getNbRecords(query);
            }
            return total;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public int getNbRecords(String url, Query query) throws MetadataSourceException {
        try {
            int total = 0;
            for (Imports Imports2 : this.matchingImports(url)) {
                total += Imports2.getNbRecords(query);
            }
            return total;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> getRecords(String url, String query, int start, int count) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (Imports imports : this.matchingImports(url)) {
                recordList.addAll(imports.getRecords(query, start, count));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> getRecords(String url, Query query) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (Imports imports : this.matchingImports(url)) {
                recordList.addAll(imports.getRecords(query));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public ImportRecord getRecord(String url, String id) throws MetadataSourceException {
        try {
            for (Imports imports : this.matchingImports(url)) {
                if (imports.getRecord(id) == null) continue;
                return imports.getRecord(id);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public ImportRecord getRecord(String url, Query query) throws MetadataSourceException {
        try {
            for (Imports imports : this.matchingImports(url)) {
                if (imports.getRecord(query) == null) continue;
                return imports.getRecord(query);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<String> getImportUrls() {
        return this.importSources.keySet();
    }

    @Override
    public void destroy() throws Exception {
        for (Imports imports : this.importSources.values()) {
            if (!(imports instanceof Destroyable)) continue;
            ((Destroyable)((Object)imports)).destroy();
        }
    }
}

