/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.eperson.EPerson;
import org.dspace.statistics.service.ElasticSearchLoggerService;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;
import org.dspace.statistics.util.SpiderDetector;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.springframework.beans.factory.InitializingBean;

public class ElasticSearchLoggerServiceImpl
implements ElasticSearchLoggerService,
InitializingBean {
    private static Logger log = Logger.getLogger(ElasticSearchLoggerServiceImpl.class);
    protected boolean useProxies;
    public static final String DATE_FORMAT_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_DCDATE = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected static LookupService locationService;
    protected String clusterName = "dspacestatslogging";
    protected String indexName = "dspaceindex";
    protected String indexType = "stats";
    protected String address = "127.0.0.1";
    protected int port = 9300;
    protected Client client;

    protected ElasticSearchLoggerServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        log.info((Object)"DSpace ElasticSearchLogger Initializing");
        try {
            LookupService service = null;
            String dbfile = ConfigurationManager.getProperty("usage-statistics", "dbfile");
            if (dbfile != null) {
                try {
                    service = new LookupService(dbfile, 0);
                }
                catch (FileNotFoundException fe) {
                    log.error((Object)("The GeoLite Database file is missing (" + dbfile + ")! Usage Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file."), (Throwable)fe);
                }
                catch (IOException e) {
                    log.error((Object)("Unable to load GeoLite Database file (" + dbfile + ")! You may need to reinstall it. See the DSpace installation instructions for more details."), (Throwable)e);
                }
            } else {
                log.error((Object)"The required 'dbfile' configuration is missing in usage-statistics.cfg!");
            }
            locationService = service;
            this.useProxies = "true".equals(ConfigurationManager.getProperty("useProxies"));
            log.info((Object)("useProxies=" + this.useProxies));
            this.clusterName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "clusterName", this.clusterName);
            this.indexName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexName", this.indexName);
            this.indexType = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexType", this.indexType);
            this.address = this.getConfigurationStringWithFallBack("elastic-search-statistics", "address", this.address);
            this.port = ConfigurationManager.getIntProperty("elastic-search-statistics", "port", this.port);
            this.client = this.getClient();
            boolean hasIndex = false;
            try {
                log.info((Object)"Checking Elastic Search cluster health...");
                ClusterHealthResponse healthResponse = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[]{this.indexName}).setWaitForYellowStatus().setTimeout(TimeValue.timeValueSeconds((long)30L)).execute().actionGet();
                if (healthResponse.isTimedOut() || healthResponse.getStatus() == ClusterHealthStatus.RED) {
                    throw new IllegalStateException("cluster not ready due to health: " + healthResponse.toString());
                }
                log.info((Object)"DS ES Checking if index exists");
                hasIndex = ((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.indexName}).execute().actionGet()).isExists();
            }
            catch (Exception e) {
                log.error((Object)("Exception during health check, likely have to create index and put mapping still. Exception:" + e.getMessage()));
                hasIndex = false;
            }
            if (!hasIndex) {
                log.info((Object)"DS ES index didn't exist, we need to create it.");
                String mappingPath = ElasticSearchLoggerServiceImpl.class.getPackage().getName().replaceAll("\\.", "/");
                URL url = Resources.getResource((String)(mappingPath + "/elasticsearch-statistics-mapping.json"));
                String stringMappingJSON = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
                stringMappingJSON = stringMappingJSON.replace("stats", this.indexType);
                this.client.prepareIndex(this.indexName, this.indexType, "1").setSource(XContentFactory.jsonBuilder().startObject().field("user", "kimchy").field("postDate", new Date()).field("message", "trying out Elastic Search").endObject()).execute().actionGet();
                log.info((Object)("Create INDEX [" + this.indexName + "]/[" + this.indexType + "]"));
                this.client.admin().indices().prepareRefresh(new String[]{this.indexName}).execute().actionGet();
                log.info((Object)("Put Mapping for [" + this.indexName + "]/[" + this.indexType + "]=" + stringMappingJSON));
                PutMappingRequestBuilder putMappingRequestBuilder = this.client.admin().indices().preparePutMapping(new String[]{this.indexName}).setType(this.indexType);
                putMappingRequestBuilder.setSource(stringMappingJSON);
                PutMappingResponse response = (PutMappingResponse)putMappingRequestBuilder.execute().actionGet();
                if (!response.isAcknowledged()) {
                    log.info((Object)("Could not define mapping for type [" + this.indexName + "]/[" + this.indexType + "]"));
                } else {
                    log.info((Object)("Successfully put mapping for [" + this.indexName + "]/[" + this.indexType + "]"));
                }
                log.info((Object)"DS ES index didn't exist, but we created it.");
            } else {
                log.info((Object)"DS ES index already exists");
            }
            log.info((Object)"DSpace ElasticSearchLogger Initialized Successfully (I suppose)");
        }
        catch (Exception e) {
            log.error((Object)("Elastic Search crashed during init. " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        this.client = this.getClient();
        boolean isSpiderBot = SpiderDetector.isSpider(request);
        try {
            if (isSpiderBot && !ConfigurationManager.getBooleanProperty("usage-statistics", "logBots", true)) {
                return;
            }
            String ip = request.getRemoteAddr();
            if (this.isUseProxies() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            XContentBuilder docBuilder = null;
            docBuilder = XContentFactory.jsonBuilder().startObject();
            docBuilder.field("ip", ip);
            docBuilder.field("id", (Object)dspaceObject.getID());
            docBuilder.field("typeIndex", dspaceObject.getType());
            docBuilder.field("type", Constants.typeText[dspaceObject.getType()]);
            docBuilder.field("time", DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
            if (currentUser != null) {
                docBuilder.field("epersonid", (Object)currentUser.getID());
            }
            try {
                String dns = DnsLookup.reverseDns(ip);
                docBuilder.field("dns", dns.toLowerCase());
            }
            catch (Exception e) {
                log.info((Object)("Failed DNS Lookup for IP:" + ip));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            Location location = locationService.getLocation(ip);
            if (!(location == null || "--".equals(location.countryCode) && location.latitude == -180.0f && location.longitude == -180.0f)) {
                try {
                    docBuilder.field("continent", LocationUtils.getContinentCode(location.countryCode));
                }
                catch (Exception e) {
                    System.out.println("COUNTRY ERROR: " + location.countryCode);
                }
                docBuilder.field("countryCode", location.countryCode);
                docBuilder.field("city", location.city);
                docBuilder.field("latitude", location.latitude);
                docBuilder.field("longitude", location.longitude);
                docBuilder.field("isBot", isSpiderBot);
                if (request.getHeader("User-Agent") != null) {
                    docBuilder.field("userAgent", request.getHeader("User-Agent"));
                }
            }
            if (dspaceObject instanceof Bitstream) {
                Bitstream bit = (Bitstream)dspaceObject;
                List<Bundle> bundles = bit.getBundles();
                docBuilder.field("bundleName").startArray();
                for (Bundle bundle : bundles) {
                    docBuilder.value(bundle.getName());
                }
                docBuilder.endArray();
            }
            this.storeParents(docBuilder, this.getParents(dspaceObject));
            docBuilder.endObject();
            if (docBuilder != null) {
                IndexRequestBuilder irb = this.client.prepareIndex(this.indexName, this.indexType).setSource(docBuilder);
                if (this.client == null) {
                    log.error((Object)"Hey, client is null");
                }
                irb.execute().actionGet();
            }
        }
        catch (RuntimeException re) {
            log.error((Object)("RunTimer in ESL:\n" + ExceptionUtils.getStackTrace((Throwable)re)));
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        finally {
            this.client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(DSpaceObject dspaceObject, String ip, String userAgent, String xforwardedfor, EPerson currentUser) {
        this.client = this.getClient();
        boolean isSpiderBot = SpiderDetector.isSpider(ip);
        try {
            if (isSpiderBot && !ConfigurationManager.getBooleanProperty("usage-statistics", "logBots", true)) {
                return;
            }
            if (this.isUseProxies() && xforwardedfor != null) {
                for (String xfip : xforwardedfor.split(",")) {
                    if (xforwardedfor.contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            XContentBuilder docBuilder = null;
            docBuilder = XContentFactory.jsonBuilder().startObject();
            docBuilder.field("ip", ip);
            docBuilder.field("id", (Object)dspaceObject.getID());
            docBuilder.field("typeIndex", dspaceObject.getType());
            docBuilder.field("type", Constants.typeText[dspaceObject.getType()]);
            docBuilder.field("time", DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
            if (currentUser != null) {
                docBuilder.field("epersonid", (Object)currentUser.getID());
            }
            try {
                String dns = DnsLookup.reverseDns(ip);
                docBuilder.field("dns", dns.toLowerCase());
            }
            catch (Exception e) {
                log.info((Object)("Failed DNS Lookup for IP:" + ip));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            Location location = locationService.getLocation(ip);
            if (!(location == null || "--".equals(location.countryCode) && location.latitude == -180.0f && location.longitude == -180.0f)) {
                try {
                    docBuilder.field("continent", LocationUtils.getContinentCode(location.countryCode));
                }
                catch (Exception e) {
                    System.out.println("COUNTRY ERROR: " + location.countryCode);
                }
                docBuilder.field("countryCode", location.countryCode);
                docBuilder.field("city", location.city);
                docBuilder.field("latitude", location.latitude);
                docBuilder.field("longitude", location.longitude);
                docBuilder.field("isBot", isSpiderBot);
                if (userAgent != null) {
                    docBuilder.field("userAgent", userAgent);
                }
            }
            if (dspaceObject instanceof Bitstream) {
                Bitstream bit = (Bitstream)dspaceObject;
                List<Bundle> bundles = bit.getBundles();
                docBuilder.field("bundleName").startArray();
                for (Bundle bundle : bundles) {
                    docBuilder.value(bundle.getName());
                }
                docBuilder.endArray();
            }
            this.storeParents(docBuilder, this.getParents(dspaceObject));
            docBuilder.endObject();
            if (docBuilder != null) {
                IndexRequestBuilder irb = this.client.prepareIndex(this.indexName, this.indexType).setSource(docBuilder);
                if (this.client == null) {
                    log.error((Object)"Hey, client is null");
                }
                irb.execute().actionGet();
            }
        }
        catch (RuntimeException re) {
            log.error((Object)("RunTimer in ESL:\n" + ExceptionUtils.getStackTrace((Throwable)re)));
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        finally {
            this.client.close();
        }
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public String getIndexType() {
        return this.indexType;
    }

    @Override
    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void buildParents(DSpaceObject dso, HashMap<String, ArrayList<String>> parents) throws SQLException {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(dso instanceof Community)) break block5;
                        Community comm = (Community)dso;
                        while (comm != null && CollectionUtils.isNotEmpty(comm.getParentCommunities())) {
                            comm = comm.getParentCommunities().get(0);
                            parents.get("owningComm").add(comm.getID().toString());
                        }
                        break block6;
                    }
                    if (!(dso instanceof Collection)) break block7;
                    Collection coll = (Collection)dso;
                    for (Community community : coll.getCommunities()) {
                        parents.get("owningComm").add(community.getID().toString());
                        this.buildParents(community, parents);
                    }
                    break block6;
                }
                if (!(dso instanceof Item)) break block8;
                Item item = (Item)dso;
                for (Collection collection : item.getCollections()) {
                    parents.get("owningColl").add(collection.getID().toString());
                    this.buildParents(collection, parents);
                }
                break block6;
            }
            if (!(dso instanceof Bitstream)) break block6;
            Bitstream bitstream = (Bitstream)dso;
            for (Bundle bundle : bitstream.getBundles()) {
                for (Item item : bundle.getItems()) {
                    parents.get("owningItem").add(item.getID().toString());
                    this.buildParents(item, parents);
                }
            }
        }
    }

    @Override
    public HashMap<String, ArrayList<String>> getParents(DSpaceObject dso) throws SQLException {
        HashMap<String, ArrayList<String>> parents = new HashMap<String, ArrayList<String>>();
        parents.put("owningComm", new ArrayList());
        parents.put("owningColl", new ArrayList());
        parents.put("owningItem", new ArrayList());
        this.buildParents(dso, parents);
        return parents;
    }

    @Override
    public void storeParents(XContentBuilder docBuilder, HashMap<String, ArrayList<String>> parents) throws IOException {
        for (String key : parents.keySet()) {
            ArrayList<String> ids = parents.get(key);
            if (ids.size() <= 0) continue;
            docBuilder.field(key).startArray();
            for (String i : ids) {
                docBuilder.value(i);
            }
            docBuilder.endArray();
        }
    }

    @Override
    public boolean isUseProxies() {
        return this.useProxies;
    }

    @Override
    public void createTransportClient() {
        this.clusterName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "clusterName", this.clusterName);
        this.indexName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexName", this.indexName);
        this.indexType = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexType", this.indexType);
        this.address = this.getConfigurationStringWithFallBack("elastic-search-statistics", "address", this.address);
        this.port = ConfigurationManager.getIntProperty("elastic-search-statistics", "port", this.port);
        log.info((Object)("Creating TransportClient to [Address:" + this.address + "] [Port:" + this.port + "] [cluster.name:" + this.clusterName + "]"));
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).build();
        this.client = new TransportClient(settings).addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.address, this.port));
    }

    @Override
    public Client getClient() {
        return this.getClient(ElasticSearchLoggerService.ClientType.NODE);
    }

    @Override
    public Client getClient(ElasticSearchLoggerService.ClientType clientType) {
        if (this.client == null) {
            log.error((Object)"getClient reports null client");
            if (clientType == ElasticSearchLoggerService.ClientType.TRANSPORT) {
                this.createTransportClient();
            } else {
                this.createNodeClient(clientType);
            }
        }
        return this.client;
    }

    @Override
    public Client createNodeClient(ElasticSearchLoggerService.ClientType clientType) {
        String dspaceDir = ConfigurationManager.getProperty("dspace.dir");
        Settings settings = ImmutableSettings.settingsBuilder().put("path.data", dspaceDir + "/elasticsearch/").build();
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder().clusterName(this.clusterName).data(true).settings(settings);
        if (clientType == ElasticSearchLoggerService.ClientType.LOCAL) {
            log.info((Object)"Create a Local Node.");
            nodeBuilder = nodeBuilder.local(true);
        } else if (clientType == ElasticSearchLoggerService.ClientType.NODE) {
            log.info((Object)"Create a nodeClient, allows transport clients to connect");
            nodeBuilder = nodeBuilder.local(false);
        }
        Node node = nodeBuilder.node();
        log.info((Object)"Got node");
        this.client = node.client();
        log.info((Object)"Created new node client");
        return this.client;
    }

    @Override
    public String getConfigurationStringWithFallBack(String module, String configurationKey, String defaultFallbackValue) {
        String configDrivenValue = ConfigurationManager.getProperty(module, configurationKey);
        if (configDrivenValue == null || configDrivenValue.trim().equalsIgnoreCase("")) {
            return defaultFallbackValue;
        }
        return configDrivenValue;
    }
}

