/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.ElasticSearchLoggerService;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class StatisticsImporterElasticSearch {
    private static final Logger log = Logger.getLogger(StatisticsImporterElasticSearch.class);
    private static ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
    };
    private static LookupService geoipLookup;
    private static Map<String, String> metadataStorageInfo;
    private static boolean skipReverseDNS;
    private static ElasticSearchLoggerService elasticSearchLoggerInstance;
    private static Client client;
    private static BulkRequestBuilder bulkRequest;

    private void load(String filename, Context context, boolean verbose) {
        int counter = 0;
        int errors = 0;
        int searchengines = 0;
        try {
            BulkResponse bulkResponse;
            String line;
            BufferedReader input;
            if (null == filename || "-".equals(filename)) {
                input = new BufferedReader(new InputStreamReader(System.in));
                filename = "standard input";
            } else {
                input = new BufferedReader(new FileReader(new File(filename)));
            }
            System.out.println("Processing file: " + filename);
            String continent = "";
            String country = "";
            String countryCode = "";
            float longitude = 0.0f;
            float latitude = 0.0f;
            String city = "";
            DNSCache<String, String> dnsCache = new DNSCache<String, String>(2500, 0.75f, 2500);
            ContentServiceFactory contentServiceFactory = ContentServiceFactory.getInstance();
            while ((line = input.readLine()) != null) {
                ++counter;
                ++errors;
                if (verbose) {
                    System.out.println("Line:" + line);
                }
                String[] parts = line.split(",");
                String action = parts[1];
                String id = parts[2];
                Date date = dateFormat.get().parse(parts[3]);
                String user = parts[4];
                String ip = parts[5];
                String dns = "";
                if (!skipReverseDNS) {
                    Object fromCache = dnsCache.get(ip);
                    if (fromCache != null) {
                        dns = (String)fromCache;
                    } else {
                        try {
                            dns = DnsLookup.reverseDns(ip);
                            dnsCache.put(ip, dns);
                        }
                        catch (Exception e) {
                            dns = "";
                        }
                    }
                }
                String data = "";
                data = data + "ip addr = " + ip;
                data = data + ", dns name = " + dns;
                if (dns.endsWith(".googlebot.com.") || dns.endsWith(".crawl.yahoo.net.") || dns.endsWith(".search.msn.com.")) {
                    if (verbose) {
                        System.out.println(data + ", IGNORE (search engine)");
                    }
                    --errors;
                    ++searchengines;
                    continue;
                }
                try {
                    Location location = geoipLookup.getLocation(ip);
                    city = location.city;
                    country = location.countryName;
                    countryCode = location.countryCode;
                    longitude = location.longitude;
                    latitude = location.latitude;
                    if (verbose) {
                        data = data + ", country = " + country;
                        data = data + ", city = " + city;
                        System.out.println(data);
                    }
                    try {
                        continent = LocationUtils.getContinentCode(countryCode);
                    }
                    catch (Exception e) {
                        if (!verbose) continue;
                        System.out.println("Unknown country code: " + countryCode);
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                DSpaceObjectService<Bitstream> legacySupportService = null;
                int type = 0;
                if ("view_bitstream".equals(action)) {
                    legacySupportService = contentServiceFactory.getBitstreamService();
                    type = 0;
                } else if ("view_item".equals(action)) {
                    legacySupportService = contentServiceFactory.getItemService();
                    type = 2;
                } else if ("view_collection".equals(action)) {
                    legacySupportService = contentServiceFactory.getCollectionService();
                    type = 3;
                } else if ("view_community".equals(action)) {
                    legacySupportService = contentServiceFactory.getCommunityService();
                    type = 4;
                }
                if (legacySupportService == null) continue;
                Object dso = legacySupportService.findByIdOrLegacyId(context, id);
                if (dso == null) {
                    if (!verbose) continue;
                    System.err.println(" - DSO with ID '" + id + "' is no longer in the system");
                    continue;
                }
                EPerson eperson = EPersonServiceFactory.getInstance().getEPersonService().findByEmail(context, user);
                int epersonId = 0;
                if (eperson != null) {
                    eperson.getID();
                }
                XContentBuilder postBuilder = XContentFactory.jsonBuilder().startObject().field("id", (Object)((DSpaceObject)dso).getID()).field("typeIndex", ((DSpaceObject)dso).getType()).field("type", contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso)).field("geo", (Object)new GeoPoint((double)latitude, (double)longitude)).field("continent", continent).field("countryCode", countryCode).field("country", country).field("city", city).field("ip", ip).field("time", DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
                if (dso instanceof Bitstream) {
                    Bitstream bit = (Bitstream)dso;
                    List<Bundle> bundles = bit.getBundles();
                    postBuilder = postBuilder.field("bundleName").startArray();
                    for (Bundle bundle : bundles) {
                        postBuilder = postBuilder.value(bundle.getName());
                    }
                    postBuilder = postBuilder.endArray();
                }
                if (epersonId > 0) {
                    postBuilder = postBuilder.field("epersonid", epersonId);
                }
                if (dns != null) {
                    postBuilder = postBuilder.field("dns", dns.toLowerCase());
                }
                elasticSearchLoggerInstance.storeParents(postBuilder, elasticSearchLoggerInstance.getParents((DSpaceObject)dso));
                bulkRequest.add(client.prepareIndex(elasticSearchLoggerInstance.getIndexName(), elasticSearchLoggerInstance.getIndexType()).setSource(postBuilder.endObject()));
                --errors;
            }
            if (bulkRequest.numberOfActions() > 0 && (bulkResponse = (BulkResponse)bulkRequest.execute().actionGet()).hasFailures()) {
                log.error((Object)("Bulk Request Failed due to: " + bulkResponse.buildFailureMessage()));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        DecimalFormat percentage = new DecimalFormat("##.###");
        int committed = counter - errors - searchengines;
        System.out.println("Processed " + counter + " log lines");
        if (counter > 0) {
            Double committedpercentage = 100.0 * (double)committed / (double)counter;
            System.out.println(" - " + committed + " entries added to ElasticSearch: " + percentage.format(committedpercentage) + "%");
            Double errorpercentage = 100.0 * (double)errors / (double)counter;
            System.out.println(" - " + errors + " errors: " + percentage.format(errorpercentage) + "%");
            Double sepercentage = 100.0 * (double)searchengines / (double)counter;
            System.out.println(" - " + searchengines + " search engine activity skipped: " + percentage.format(sepercentage) + "%");
        }
        System.out.println(" done!");
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("StatisticsImporterElasticSearch\n", options);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "in", true, "the input file ('-' or omit for standard input)");
        options.addOption("m", "multiple", false, "treat the input file as having a wildcard ending");
        options.addOption("s", "skipdns", false, "skip performing reverse DNS lookups on IP addresses");
        options.addOption("v", "verbose", false, "display verbose output (useful for debugging)");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            StatisticsImporterElasticSearch.printHelp(options, 0);
        }
        if (line.hasOption('s')) {
            skipReverseDNS = true;
        }
        log.info((Object)"Getting ElasticSearch Transport Client for StatisticsImporterElasticSearch...");
        client = elasticSearchLoggerInstance.getClient(ElasticSearchLoggerService.ClientType.TRANSPORT);
        client.admin().indices().prepareRefresh(new String[]{StatisticsServiceFactory.getInstance().getElasticSearchLoggerService().getIndexName()}).execute().actionGet();
        bulkRequest = client.prepareBulk();
        Context context = new Context();
        boolean verbose = line.hasOption('v');
        String dbfile = ConfigurationManager.getProperty("usage-statistics", "dbfile");
        try {
            geoipLookup = new LookupService(dbfile, 0);
        }
        catch (FileNotFoundException fe) {
            log.error((Object)("The GeoLite Database file is missing (" + dbfile + ")! Elastic Search  Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file."), (Throwable)fe);
        }
        catch (IOException e) {
            log.error((Object)("Unable to load GeoLite Database file (" + dbfile + ")! You may need to reinstall it. See the DSpace installation instructions for more details."), (Throwable)e);
        }
        StatisticsImporterElasticSearch elasticSearchImporter = new StatisticsImporterElasticSearch();
        if (line.hasOption('m')) {
            String[] children;
            final File sample = new File(line.getOptionValue('i'));
            File dir = sample.getParentFile();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(sample.getName());
                }
            };
            for (String in : children = dir.list(filter)) {
                System.out.println(in);
                elasticSearchImporter.load(dir.getAbsolutePath() + System.getProperty("file.separator") + in, context, verbose);
            }
        } else {
            elasticSearchImporter.load(line.getOptionValue('i'), context, verbose);
        }
    }

    static {
        skipReverseDNS = false;
        elasticSearchLoggerInstance = StatisticsServiceFactory.getInstance().getElasticSearchLoggerService();
    }

    static class DNSCache<K, V>
    extends LinkedHashMap<K, V> {
        private int maxCapacity;

        public DNSCache(int initialCapacity, float loadFactor, int maxCapacity) {
            super(initialCapacity, loadFactor, true);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.maxCapacity;
        }
    }
}

