/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DSpaceCSV
implements Serializable {
    protected List<String> headings;
    protected List<DSpaceCSVLine> lines;
    protected int counter;
    protected String valueSeparator;
    protected String escapedValueSeparator;
    protected String fieldSeparator;
    protected String escapedFieldSeparator;
    protected String authoritySeparator;
    protected String escapedAuthoritySeparator;
    protected final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected final transient MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected final transient MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected final transient AuthorityValueService authorityValueService = AuthorityServiceFactory.getInstance().getAuthorityValueService();
    protected boolean exportAll;
    protected Map<String, String> ignore;

    public DSpaceCSV(boolean exportAll) {
        this.init();
        this.exportAll = exportAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSpaceCSV(File f, Context c) throws Exception {
        this.init();
        try (BufferedReader input = null;){
            String lineRead;
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String head = input.readLine();
            String[] headingElements = head.split(this.escapedFieldSeparator);
            int columnCounter = 0;
            for (String element : headingElements) {
                MetadataSchema foundSchema;
                String[] clean;
                String[] parts;
                ++columnCounter;
                if (element.startsWith("\"") && element.endsWith("\"")) {
                    element = element.substring(1, element.length() - 1);
                }
                if ("collection".equals(element)) {
                    this.headings.add(element);
                    continue;
                }
                if ("action".equals(element)) {
                    this.headings.add(element);
                    continue;
                }
                if ("id".equals(element)) continue;
                String authorityPrefix = "";
                AuthorityValue authorityValueType = this.authorityValueService.getAuthorityValueType(element);
                if (authorityValueType != null) {
                    String authorityType = authorityValueType.getAuthorityType();
                    authorityPrefix = element.substring(0, authorityType.length() + 1);
                    element = element.substring(authorityPrefix.length());
                }
                if ((parts = (clean = element.split("\\["))[0].split("\\.")).length < 2) {
                    throw new MetadataImportInvalidHeadingException(element, 99, columnCounter);
                }
                String metadataSchema = parts[0];
                String metadataElement = parts[1];
                String metadataQualifier = null;
                if (parts.length > 2) {
                    metadataQualifier = parts[2];
                }
                if ((foundSchema = this.metadataSchemaService.find(c, metadataSchema)) == null) {
                    throw new MetadataImportInvalidHeadingException(clean[0], 0, columnCounter);
                }
                MetadataField foundField = this.metadataFieldService.findByElement(c, foundSchema, metadataElement, metadataQualifier);
                if (foundField == null) {
                    throw new MetadataImportInvalidHeadingException(clean[0], 1, columnCounter);
                }
                this.headings.add(authorityPrefix + element);
            }
            StringBuilder lineBuilder = new StringBuilder();
            while (StringUtils.isNotBlank((CharSequence)(lineRead = input.readLine()))) {
                int pos;
                int quoteCount;
                if (lineBuilder.length() > 0) {
                    lineBuilder.append("\n").append(lineRead);
                    quoteCount = 0;
                    for (pos = 0; pos < lineBuilder.length(); ++pos) {
                        if (lineBuilder.charAt(pos) != '\"') continue;
                        ++quoteCount;
                    }
                    if (quoteCount % 2 != 0) continue;
                    this.addItem(lineBuilder.toString());
                    lineBuilder = new StringBuilder();
                    continue;
                }
                if (lineRead.indexOf(34) > -1) {
                    quoteCount = 0;
                    for (pos = 0; pos < lineRead.length(); ++pos) {
                        if (lineRead.charAt(pos) != '\"') continue;
                        ++quoteCount;
                    }
                    if (quoteCount % 2 == 0) {
                        this.addItem(lineRead);
                        continue;
                    }
                    lineBuilder.append(lineRead);
                    continue;
                }
                this.addItem(lineRead);
            }
        }
    }

    protected void init() {
        String[] toIgnoreArray;
        this.setValueSeparator();
        this.setFieldSeparator();
        this.setAuthoritySeparator();
        this.headings = new ArrayList<String>();
        this.lines = new ArrayList<DSpaceCSVLine>();
        this.counter = 0;
        this.ignore = new HashMap<String, String>();
        String[] defaultValues = new String[]{"dc.date.accessioned, dc.date.available, dc.date.updated, dc.description.provenance"};
        for (String toIgnoreString : toIgnoreArray = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("bulkedit.ignore-on-export", defaultValues)) {
            if ("".equals(toIgnoreString.trim())) continue;
            this.ignore.put(toIgnoreString.trim(), toIgnoreString.trim());
        }
    }

    public boolean hasActions() {
        for (String header : this.headings) {
            if (!header.equals("action")) continue;
            return true;
        }
        return false;
    }

    private void setValueSeparator() {
        this.valueSeparator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("bulkedit.valueseparator");
        this.valueSeparator = this.valueSeparator != null && !"".equals(this.valueSeparator.trim()) ? this.valueSeparator.trim() : "||";
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(this.valueSeparator);
        this.escapedValueSeparator = match.replaceAll("\\\\$1");
    }

    private void setFieldSeparator() {
        this.fieldSeparator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("bulkedit.fieldseparator");
        if (this.fieldSeparator != null && !"".equals(this.fieldSeparator.trim())) {
            this.fieldSeparator = this.fieldSeparator.trim();
            this.fieldSeparator = "tab".equals(this.fieldSeparator) ? "\t" : ("semicolon".equals(this.fieldSeparator) ? ";" : ("hash".equals(this.fieldSeparator) ? "#" : this.fieldSeparator.trim()));
        } else {
            this.fieldSeparator = ",";
        }
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(this.fieldSeparator);
        this.escapedFieldSeparator = match.replaceAll("\\\\$1");
    }

    private void setAuthoritySeparator() {
        this.authoritySeparator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("bulkedit.authorityseparator");
        this.authoritySeparator = this.authoritySeparator != null && !"".equals(this.authoritySeparator.trim()) ? this.authoritySeparator.trim() : "::";
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(this.authoritySeparator);
        this.escapedAuthoritySeparator = match.replaceAll("\\\\$1");
    }

    public final void addItem(Item i) throws Exception {
        if (i.getOwningCollection() == null) {
            return;
        }
        DSpaceCSVLine line = new DSpaceCSVLine(i.getID());
        String owningCollectionHandle = i.getOwningCollection().getHandle();
        line.add("collection", owningCollectionHandle);
        List<Collection> collections = i.getCollections();
        for (Collection c : collections) {
            if (c.getHandle().equals(owningCollectionHandle)) continue;
            line.add("collection", c.getHandle());
        }
        List<MetadataValue> md = this.itemService.getMetadata(i, "*", "*", "*", "*");
        for (MetadataValue value : md) {
            MetadataField metadataField = value.getMetadataField();
            MetadataSchema metadataSchema = metadataField.getMetadataSchema();
            String key = metadataSchema.getName() + "." + metadataField.getElement();
            if (metadataField.getQualifier() != null) {
                key = key + "." + metadataField.getQualifier();
            }
            if (value.getLanguage() != null) {
                key = key + "[" + value.getLanguage() + "]";
            }
            if (!this.exportAll && !this.okToExport(metadataField)) continue;
            String mdValue = value.getValue();
            if (value.getAuthority() != null && !"".equals(value.getAuthority())) {
                mdValue = mdValue + this.authoritySeparator + value.getAuthority() + this.authoritySeparator + (value.getConfidence() != -1 ? value.getConfidence() : 600);
            }
            line.add(key, mdValue);
            if (this.headings.contains(key)) continue;
            this.headings.add(key);
        }
        this.lines.add(line);
        ++this.counter;
    }

    public final void addItem(String line) throws Exception {
        DSpaceCSVLine csvLine;
        boolean last = false;
        if (line.endsWith(this.fieldSeparator)) {
            last = true;
            line = line + " ";
        }
        String[] parts = line.split(this.escapedFieldSeparator);
        ArrayList<String> bits = new ArrayList<String>();
        bits.addAll(Arrays.asList(parts));
        boolean alldone = false;
        while (!alldone) {
            boolean found = false;
            int i = 0;
            for (String part : bits) {
                int bitcounter = part.length() - part.replaceAll("\"", "").length();
                if (part.startsWith("\"") && (!part.endsWith("\"") || (bitcounter & 1) == 1)) {
                    found = true;
                    String add = (String)bits.get(i) + this.fieldSeparator + (String)bits.get(i + 1);
                    bits.remove(i);
                    bits.add(i, add);
                    bits.remove(i + 1);
                    break;
                }
                ++i;
            }
            alldone = !found;
        }
        int i = 0;
        for (String part : bits) {
            if (part.startsWith("\"") && part.endsWith("\"")) {
                part = part.substring(1, part.length() - 1);
                bits.set(i, part);
            }
            ++i;
        }
        i = 0;
        for (String part : bits) {
            if (part.contains("\"\"")) {
                part = part.replaceAll("\"\"", "\"");
                bits.set(i, part);
            }
            ++i;
        }
        String id = parts[0].replaceAll("\"", "");
        if ("+".equals(id)) {
            csvLine = new DSpaceCSVLine();
        } else {
            try {
                csvLine = new DSpaceCSVLine(UUID.fromString(id));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid item identifier: " + id);
                System.err.println("Please check your CSV file for information. Item id must be numeric, or a '+' to add a new item");
                throw nfe;
            }
        }
        i = 0;
        for (String part : bits) {
            if (i > 0) {
                String[] elements;
                if (last && i == this.headings.size()) {
                    part = "";
                }
                if (this.headings.size() < i) {
                    throw new MetadataImportInvalidHeadingException("", 98, i + 1);
                }
                csvLine.add(this.headings.get(i - 1), null);
                for (String element : elements = part.split(this.escapedValueSeparator)) {
                    if (element == null || "".equals(element)) continue;
                    csvLine.add(this.headings.get(i - 1), element);
                }
            }
            ++i;
        }
        this.lines.add(csvLine);
        ++this.counter;
    }

    public final List<DSpaceCSVLine> getCSVLines() {
        return this.lines;
    }

    public final String[] getCSVLinesAsStringArray() {
        String[] csvLines = new String[this.counter + 1];
        csvLines[0] = "id" + this.fieldSeparator + "collection";
        ArrayList<String> headingsCopy = new ArrayList<String>(this.headings);
        Collections.sort(headingsCopy);
        for (String value : headingsCopy) {
            csvLines[0] = csvLines[0] + this.fieldSeparator + value;
        }
        Iterator<DSpaceCSVLine> i = this.lines.iterator();
        int c = 1;
        while (i.hasNext()) {
            csvLines[c++] = i.next().toCSV(headingsCopy, this.fieldSeparator, this.valueSeparator);
        }
        return csvLines;
    }

    public final void save(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        for (String csvLine : this.getCSVLinesAsStringArray()) {
            out.write(csvLine + "\n");
        }
        out.flush();
        out.close();
    }

    protected boolean okToExport(MetadataField md) {
        String key = md.getMetadataSchema().getName() + "." + md.getElement();
        if (md.getQualifier() != null) {
            key = key + "." + md.getQualifier();
        }
        return this.ignore.get(key) == null;
    }

    public List<String> getHeadings() {
        return this.headings;
    }

    public final String toString() {
        String[] lines;
        StringBuilder csvLines = new StringBuilder();
        for (String line : lines = this.getCSVLinesAsStringArray()) {
            csvLines.append(line).append("\n");
        }
        return csvLines.toString();
    }

    public String getAuthoritySeparator() {
        return this.authoritySeparator;
    }

    public String getEscapedAuthoritySeparator() {
        return this.escapedAuthoritySeparator;
    }
}

