/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.workflow.WorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorizeServiceImpl
implements AuthorizeService {
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ContentServiceFactory serviceFactory;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected WorkflowItemService workflowItemService;

    protected AuthorizeServiceImpl() {
    }

    @Override
    public void authorizeAnyOf(Context c, DSpaceObject o, int[] actions) throws AuthorizeException, SQLException {
        AuthorizeException ex = null;
        for (int action : actions) {
            try {
                this.authorizeAction(c, o, action);
                return;
            }
            catch (AuthorizeException e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        throw ex;
    }

    @Override
    public void authorizeAction(Context c, DSpaceObject o, int action) throws AuthorizeException, SQLException {
        this.authorizeAction(c, o, action, true);
    }

    @Override
    public void authorizeAction(Context c, DSpaceObject o, int action, boolean useInheritance) throws AuthorizeException, SQLException {
        this.authorizeAction(c, c.getCurrentUser(), o, action, useInheritance);
    }

    @Override
    public void authorizeAction(Context c, EPerson e, DSpaceObject o, int action, boolean useInheritance) throws AuthorizeException, SQLException {
        if (o == null) {
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            UUID userid = e == null ? null : e.getID();
            throw new AuthorizeException("Authorization attempted on null DSpace object " + actionText + " by user " + userid);
        }
        if (!this.authorize(c, o, action, e, useInheritance)) {
            int otype = o.getType();
            UUID oid = o.getID();
            UUID userid = e == null ? null : e.getID();
            String actionText = action == -1 ? "null" : Constants.actionText[action];
            throw new AuthorizeException("Authorization denied for action " + actionText + " on " + Constants.typeText[otype] + ":" + oid + " by user " + userid, o, action);
        }
    }

    @Override
    public boolean authorizeActionBoolean(Context c, DSpaceObject o, int a) throws SQLException {
        return this.authorizeActionBoolean(c, o, a, true);
    }

    @Override
    public boolean authorizeActionBoolean(Context c, DSpaceObject o, int a, boolean useInheritance) throws SQLException {
        boolean isAuthorized = true;
        if (o == null) {
            return false;
        }
        try {
            this.authorizeAction(c, o, a, useInheritance);
        }
        catch (AuthorizeException e) {
            isAuthorized = false;
        }
        return isAuthorized;
    }

    @Override
    public boolean authorizeActionBoolean(Context c, EPerson e, DSpaceObject o, int a, boolean useInheritance) throws SQLException {
        boolean isAuthorized = true;
        if (o == null) {
            return false;
        }
        try {
            this.authorizeAction(c, e, o, a, useInheritance);
        }
        catch (AuthorizeException ex) {
            isAuthorized = false;
        }
        return isAuthorized;
    }

    protected boolean authorize(Context c, DSpaceObject o, int action, EPerson e, boolean useInheritance) throws SQLException {
        Bitstream b;
        DSpaceObject parent;
        if (o == null) {
            return false;
        }
        if (c.ignoreAuthorization()) {
            return true;
        }
        EPerson userToCheck = null;
        if (e != null) {
            DSpaceObject adminObject;
            userToCheck = e;
            DSpaceObject dSpaceObject = adminObject = useInheritance ? this.serviceFactory.getDSpaceObjectService(o).getAdminObject(c, o, action) : null;
            if (this.isAdmin(c, adminObject)) {
                return true;
            }
        }
        boolean ignoreCustomPolicies = false;
        if (o instanceof Bitstream && !((parent = this.bitstreamService.getParentObject(c, b = (Bitstream)o)) instanceof Collection) && !(parent instanceof Community)) {
            boolean bl = ignoreCustomPolicies = !this.isAnyItemInstalled(c, b.getBundles());
        }
        if (o instanceof Bundle) {
            boolean bl = ignoreCustomPolicies = !this.isAnyItemInstalled(c, Arrays.asList((Bundle)o));
        }
        if (o instanceof Item && (this.workspaceItemService.findByItem(c, (Item)o) != null || this.workflowItemService.findByItem(c, (Item)o) != null)) {
            ignoreCustomPolicies = true;
        }
        for (ResourcePolicy rp : this.getPoliciesActionFilter(c, o, action)) {
            if (ignoreCustomPolicies && ResourcePolicy.TYPE_CUSTOM.equals(rp.getRpType()) || !this.resourcePolicyService.isDateValid(rp)) continue;
            if (rp.getEPerson() != null && rp.getEPerson().equals(userToCheck)) {
                return true;
            }
            if (rp.getGroup() == null || !this.groupService.isMember(c, rp.getGroup())) continue;
            return true;
        }
        return false;
    }

    protected boolean isAnyItemInstalled(Context ctx, List<Bundle> bundles) throws SQLException {
        for (Bundle bundle : bundles) {
            for (Item item : bundle.getItems()) {
                if (this.workspaceItemService.findByItem(ctx, item) != null || this.workflowItemService.findByItem(ctx, item) != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAdmin(Context c, DSpaceObject o) throws SQLException {
        if (this.isAdmin(c)) {
            return true;
        }
        if (o == null) {
            return false;
        }
        List<ResourcePolicy> policies = this.getPoliciesActionFilter(c, o, 11);
        for (ResourcePolicy rp : policies) {
            if (!this.resourcePolicyService.isDateValid(rp)) continue;
            if (rp.getEPerson() != null && rp.getEPerson().equals(c.getCurrentUser())) {
                return true;
            }
            if (rp.getGroup() == null || !this.groupService.isMember(c, rp.getGroup())) continue;
            return true;
        }
        DSpaceObject parent = this.serviceFactory.getDSpaceObjectService(o).getParentObject(c, o);
        if (parent != null) {
            return this.isAdmin(c, parent);
        }
        return false;
    }

    @Override
    public boolean isAdmin(Context c) throws SQLException {
        if (c.ignoreAuthorization()) {
            return true;
        }
        EPerson e = c.getCurrentUser();
        if (e == null) {
            return false;
        }
        return this.groupService.isMember(c, "Administrator");
    }

    @Override
    public void addPolicy(Context c, DSpaceObject o, int actionID, EPerson e) throws SQLException, AuthorizeException {
        this.addPolicy(c, o, actionID, e, null);
    }

    @Override
    public void addPolicy(Context context, DSpaceObject o, int actionID, EPerson e, String type) throws SQLException, AuthorizeException {
        this.createResourcePolicy(context, o, null, e, actionID, type);
    }

    @Override
    public void addPolicy(Context c, DSpaceObject o, int actionID, Group g) throws SQLException, AuthorizeException {
        this.createResourcePolicy(c, o, g, null, actionID, null);
    }

    @Override
    public void addPolicy(Context c, DSpaceObject o, int actionID, Group g, String type) throws SQLException, AuthorizeException {
        this.createResourcePolicy(c, o, g, null, actionID, type);
    }

    @Override
    public List<ResourcePolicy> getPolicies(Context c, DSpaceObject o) throws SQLException {
        return this.resourcePolicyService.find(c, o);
    }

    @Override
    public List<ResourcePolicy> findPoliciesByDSOAndType(Context c, DSpaceObject o, String type) throws SQLException {
        return this.resourcePolicyService.find(c, o, type);
    }

    @Override
    public List<ResourcePolicy> getPoliciesForGroup(Context c, Group g) throws SQLException {
        return this.resourcePolicyService.find(c, g);
    }

    @Override
    public List<ResourcePolicy> getPoliciesActionFilter(Context c, DSpaceObject o, int actionID) throws SQLException {
        return this.resourcePolicyService.find(c, o, actionID);
    }

    @Override
    public void inheritPolicies(Context c, DSpaceObject src, DSpaceObject dest) throws SQLException, AuthorizeException {
        List<ResourcePolicy> policies = this.getPolicies(c, src);
        ArrayList<ResourcePolicy> nonAdminPolicies = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy rp : policies) {
            if (rp.getAction() == 11) continue;
            nonAdminPolicies.add(rp);
        }
        this.addPolicies(c, nonAdminPolicies, dest);
    }

    @Override
    public void switchPoliciesAction(Context context, DSpaceObject dso, int fromAction, int toAction) throws SQLException, AuthorizeException {
        List<ResourcePolicy> rps = this.getPoliciesActionFilter(context, dso, fromAction);
        for (ResourcePolicy rp : rps) {
            rp.setAction(toAction);
        }
        this.resourcePolicyService.update(context, rps);
    }

    @Override
    public void addPolicies(Context c, List<ResourcePolicy> policies, DSpaceObject dest) throws SQLException, AuthorizeException {
        LinkedList<ResourcePolicy> newPolicies = new LinkedList<ResourcePolicy>();
        for (ResourcePolicy srp : policies) {
            ResourcePolicy rp = (ResourcePolicy)this.resourcePolicyService.create(c);
            rp.setdSpaceObject(dest);
            rp.setAction(srp.getAction());
            rp.setEPerson(srp.getEPerson());
            rp.setGroup(srp.getGroup());
            rp.setStartDate(srp.getStartDate());
            rp.setEndDate(srp.getEndDate());
            rp.setRpName(srp.getRpName());
            rp.setRpDescription(srp.getRpDescription());
            rp.setRpType(srp.getRpType());
            newPolicies.add(rp);
        }
        this.resourcePolicyService.update(c, newPolicies);
    }

    @Override
    public void removeAllPolicies(Context c, DSpaceObject o) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeAllPolicies(c, o);
    }

    @Override
    public void removeAllPoliciesByDSOAndTypeNotEqualsTo(Context c, DSpaceObject o, String type) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeDsoAndTypeNotEqualsToPolicies(c, o, type);
    }

    @Override
    public void removeAllPoliciesByDSOAndType(Context c, DSpaceObject o, String type) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removePolicies(c, o, type);
    }

    @Override
    public void removePoliciesActionFilter(Context context, DSpaceObject dso, int actionID) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removePolicies(context, dso, actionID);
    }

    @Override
    public void removeGroupPolicies(Context c, Group group) throws SQLException {
        this.resourcePolicyService.removeGroupPolicies(c, group);
    }

    @Override
    public void removeGroupPolicies(Context c, DSpaceObject o, Group g) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeDsoGroupPolicies(c, o, g);
    }

    @Override
    public void removeEPersonPolicies(Context c, DSpaceObject o, EPerson e) throws SQLException, AuthorizeException {
        this.resourcePolicyService.removeDsoEPersonPolicies(c, o, e);
    }

    @Override
    public List<Group> getAuthorizedGroups(Context c, DSpaceObject o, int actionID) throws SQLException {
        List<ResourcePolicy> policies = this.getPoliciesActionFilter(c, o, actionID);
        ArrayList<Group> groups = new ArrayList<Group>();
        for (ResourcePolicy resourcePolicy : policies) {
            if (resourcePolicy.getGroup() == null) continue;
            groups.add(resourcePolicy.getGroup());
        }
        return groups;
    }

    @Override
    public boolean isAnIdenticalPolicyAlreadyInPlace(Context c, DSpaceObject o, ResourcePolicy rp) throws SQLException {
        return this.isAnIdenticalPolicyAlreadyInPlace(c, o, rp.getGroup(), rp.getAction(), rp.getID());
    }

    @Override
    public boolean isAnIdenticalPolicyAlreadyInPlace(Context c, DSpaceObject dso, Group group, int action, int policyID) throws SQLException {
        return this.findByTypeIdGroupAction(c, dso, group, action, policyID) != null;
    }

    @Override
    public ResourcePolicy findByTypeIdGroupAction(Context c, DSpaceObject dso, Group group, int action, int policyID) throws SQLException {
        List<ResourcePolicy> policies = this.resourcePolicyService.find(c, dso, group, action, policyID);
        if (CollectionUtils.isNotEmpty(policies)) {
            return policies.iterator().next();
        }
        return null;
    }

    @Override
    public void generateAutomaticPolicies(Context context, Date embargoDate, String reason, DSpaceObject dso, Collection owningCollection) throws SQLException, AuthorizeException {
        if (embargoDate != null || embargoDate == null && dso instanceof Bitstream) {
            List<Group> authorizedGroups = this.getAuthorizedGroups(context, owningCollection, 10);
            this.removeAllPoliciesByDSOAndType(context, dso, ResourcePolicy.TYPE_CUSTOM);
            boolean isAnonymousInPlace = false;
            for (Group g : authorizedGroups) {
                if (!StringUtils.equals((String)g.getName(), (String)"Anonymous")) continue;
                isAnonymousInPlace = true;
            }
            if (!isAnonymousInPlace) {
                for (Group g : authorizedGroups) {
                    ResourcePolicy rp = this.createOrModifyPolicy(null, context, null, g, null, embargoDate, 0, reason, dso);
                    if (rp == null) continue;
                    this.resourcePolicyService.update(context, rp);
                }
            } else {
                ResourcePolicy rp = this.createOrModifyPolicy(null, context, null, this.groupService.findByName(context, "Anonymous"), null, embargoDate, 0, reason, dso);
                if (rp != null) {
                    this.resourcePolicyService.update(context, rp);
                }
            }
        }
    }

    @Override
    public ResourcePolicy createResourcePolicy(Context context, DSpaceObject dso, Group group, EPerson eperson, int type, String rpType) throws SQLException, AuthorizeException {
        if (group == null && eperson == null) {
            throw new IllegalArgumentException("We need at least an eperson or a group in order to create a resource policy.");
        }
        ResourcePolicy myPolicy = (ResourcePolicy)this.resourcePolicyService.create(context);
        myPolicy.setdSpaceObject(dso);
        myPolicy.setAction(type);
        myPolicy.setGroup(group);
        myPolicy.setEPerson(eperson);
        myPolicy.setRpType(rpType);
        this.resourcePolicyService.update(context, myPolicy);
        return myPolicy;
    }

    @Override
    public ResourcePolicy createOrModifyPolicy(ResourcePolicy policy, Context context, String name, Group group, EPerson ePerson, Date embargoDate, int action, String reason, DSpaceObject dso) throws AuthorizeException, SQLException {
        ResourcePolicy policyTemp;
        int policyID = -1;
        if (policy != null) {
            policyID = policy.getID();
        }
        if ((policyTemp = this.findByTypeIdGroupAction(context, dso, group, action, policyID)) != null) {
            policy = policyTemp;
            policy.setRpType(ResourcePolicy.TYPE_CUSTOM);
        }
        if (policy == null) {
            policy = this.createResourcePolicy(context, dso, group, ePerson, action, ResourcePolicy.TYPE_CUSTOM);
        }
        policy.setGroup(group);
        policy.setEPerson(ePerson);
        if (embargoDate != null) {
            policy.setStartDate(embargoDate);
        } else {
            policy.setStartDate(null);
            policy.setEndDate(null);
        }
        policy.setRpName(name);
        policy.setRpDescription(reason);
        return policy;
    }
}

