/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.dspace.content.MetadataSchema;
import org.dspace.core.ReloadableEntity;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name="metadatafieldregistry")
public class MetadataField
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="metadata_field_id", nullable=false, unique=true)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadatafieldregistry_seq")
    @SequenceGenerator(name="metadatafieldregistry_seq", sequenceName="metadatafieldregistry_seq", allocationSize=1, initialValue=1)
    private Integer id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="metadata_schema_id", nullable=false)
    private MetadataSchema metadataSchema;
    @Column(name="element", length=64)
    private String element;
    @Column(name="qualifier", length=64)
    private String qualifier = null;
    @Column(name="scope_note", columnDefinition="text")
    private String scopeNote;

    protected MetadataField() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getScopeNote() {
        return this.scopeNote;
    }

    public void setScopeNote(String scopeNote) {
        this.scopeNote = scopeNote;
    }

    public MetadataSchema getMetadataSchema() {
        return this.metadataSchema;
    }

    public void setMetadataSchema(MetadataSchema metadataSchema) {
        this.metadataSchema = metadataSchema;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
        if (this.getClass() != objClass) {
            return false;
        }
        MetadataField other = (MetadataField)obj;
        if (this.getID() != other.getID()) {
            return false;
        }
        return this.getMetadataSchema().equals(other.getMetadataSchema());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getID();
        hash = 47 * hash + this.getMetadataSchema().getID();
        return hash;
    }

    public String toString(char separator) {
        if (this.qualifier == null) {
            return this.getMetadataSchema().getName() + separator + this.element;
        }
        return this.getMetadataSchema().getName() + separator + this.element + separator + this.qualifier;
    }

    public String toString() {
        return this.toString('_');
    }
}

