/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.disseminate;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.disseminate.service.CitationDocumentService;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CitationDocumentServiceImpl
implements CitationDocumentService,
InitializingBean {
    private static Logger log = Logger.getLogger(CitationDocumentServiceImpl.class);
    protected final Set<String> VALID_TYPES = new HashSet<String>(2);
    protected final Set<String> PDF_MIMES = new HashSet<String>(2);
    protected final Set<String> RASTER_MIMES = new HashSet<String>();
    protected final Set<String> SVG_MIMES = new HashSet<String>();
    protected List<String> citationEnabledCollectionsList;
    protected File tempDir;
    protected String[] header1;
    protected String[] header2;
    protected String[] fields;
    protected String footer;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected HandleService handleService;
    protected Boolean citationEnabledGlobally = null;
    protected Boolean citationAsFirstPage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        String footerConfig;
        this.SVG_MIMES.add("image/jpeg");
        this.SVG_MIMES.add("image/pjpeg");
        this.SVG_MIMES.add("image/png");
        this.SVG_MIMES.add("image/gif");
        this.SVG_MIMES.add("image/svg");
        this.SVG_MIMES.add("image/svg+xml");
        this.PDF_MIMES.add("application/pdf");
        this.PDF_MIMES.add("application/x-pdf");
        this.VALID_TYPES.addAll(this.PDF_MIMES);
        String[] citationEnabledCollections = this.configurationService.getArrayProperty("citation-page.enabled_collections");
        this.citationEnabledCollectionsList = Arrays.asList(citationEnabledCollections);
        String[] citationEnabledCommunities = this.configurationService.getArrayProperty("citation-page.enabled_communities");
        if (this.citationEnabledCollectionsList == null) {
            this.citationEnabledCollectionsList = new ArrayList<String>();
        }
        if (citationEnabledCommunities != null && citationEnabledCommunities.length > 0) {
            Context context = null;
            try {
                context = new Context();
                for (String communityString : citationEnabledCommunities) {
                    DSpaceObject dsoCommunity = this.handleService.resolveToObject(context, communityString.trim());
                    if (dsoCommunity instanceof Community) {
                        Community community = (Community)dsoCommunity;
                        List<Collection> collections = this.communityService.getAllCollections(context, community);
                        for (Collection collection : collections) {
                            this.citationEnabledCollectionsList.add(collection.getHandle());
                        }
                        continue;
                    }
                    log.error((Object)("Invalid community for citation.enabled_communities, value:" + communityString.trim()));
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
            finally {
                if (context != null) {
                    context.abort();
                }
            }
        }
        this.header1 = this.configurationService.getArrayProperty("citation-page.header1");
        if (this.header1 == null || this.header1.length == 0) {
            this.header1 = new String[]{"DSpace Institution", ""};
        }
        this.header2 = this.configurationService.getArrayProperty("citation-page.header2");
        if (this.header2 == null || this.header2.length == 0) {
            this.header2 = new String[]{"DSpace Repository", "http://dspace.org"};
        }
        this.fields = this.configurationService.getArrayProperty("citation-page.fields");
        if (this.fields == null || this.fields.length == 0) {
            this.fields = new String[]{"dc.date.issued", "dc.title", "dc.creator", "dc.contributor.author", "dc.publisher", "_line_", "dc.identifier.citation", "dc.identifier.uri"};
        }
        this.footer = StringUtils.isNotBlank((String)(footerConfig = this.configurationService.getProperty("citation-page.footer"))) ? footerConfig : "Downloaded from DSpace Repository, DSpace Institution's institutional repository";
        String tempDirString = this.configurationService.getProperty("dspace.dir") + File.separator + "temp";
        this.tempDir = new File(tempDirString);
        if (!this.tempDir.exists()) {
            boolean success = this.tempDir.mkdir();
            if (success) {
                log.info((Object)("Created temp directory at: " + tempDirString));
            } else {
                log.info((Object)("Unable to create temp directory at: " + tempDirString));
            }
        }
    }

    protected CitationDocumentServiceImpl() {
    }

    protected boolean isCitationEnabledGlobally() {
        if (this.citationEnabledGlobally == null) {
            this.citationEnabledGlobally = this.configurationService.getBooleanProperty("citation-page.enable_globally", false);
        }
        return this.citationEnabledGlobally;
    }

    protected boolean isCitationEnabledThroughCollection(Context context, Bitstream bitstream) throws SQLException {
        if (this.citationEnabledCollectionsList.size() == 0) {
            return false;
        }
        DSpaceObject owningDSO = this.bitstreamService.getParentObject(context, bitstream);
        if (owningDSO instanceof Item) {
            Item item = (Item)owningDSO;
            List<Collection> collections = item.getCollections();
            for (Collection collection : collections) {
                if (!this.citationEnabledCollectionsList.contains(collection.getHandle())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean isCitationEnabledForBitstream(Bitstream bitstream, Context context) throws SQLException {
        boolean adminUser;
        if ((this.isCitationEnabledGlobally() || this.isCitationEnabledThroughCollection(context, bitstream)) && !(adminUser = this.authorizeService.isAdmin(context)) && this.canGenerateCitationVersion(context, bitstream)) {
            return true;
        }
        return false;
    }

    protected Boolean isCitationFirstPage() {
        if (this.citationAsFirstPage == null) {
            this.citationAsFirstPage = this.configurationService.getBooleanProperty("citation-page.citation_as_first_page", true);
        }
        return this.citationAsFirstPage;
    }

    @Override
    public boolean canGenerateCitationVersion(Context context, Bitstream bitstream) throws SQLException {
        return this.VALID_TYPES.contains(bitstream.getFormat(context).getMIMEType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File makeCitedDocument(Context context, Bitstream bitstream) throws IOException, SQLException, AuthorizeException {
        PDDocument document = new PDDocument();
        PDDocument sourceDocument = new PDDocument();
        try {
            Item item = (Item)this.bitstreamService.getParentObject(context, bitstream);
            sourceDocument = PDDocument.load((InputStream)this.bitstreamService.retrieve(context, bitstream));
            PDPage coverPage = new PDPage(PDRectangle.LETTER);
            this.generateCoverPage(context, document, coverPage, item);
            this.addCoverPageToDocument(document, sourceDocument, coverPage);
            document.save(this.tempDir.getAbsolutePath() + "/bitstream.cover.pdf");
            File file = new File(this.tempDir.getAbsolutePath() + "/bitstream.cover.pdf");
            return file;
        }
        finally {
            sourceDocument.close();
            document.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCoverPage(Context context, PDDocument document, PDPage coverPage, Item item) throws IOException {
        try (PDPageContentStream contentStream = new PDPageContentStream(document, coverPage);){
            int ypos = 760;
            int xpos = 30;
            int xwidth = 550;
            int ygap = 20;
            PDType1Font fontHelvetica = PDType1Font.HELVETICA;
            PDType1Font fontHelveticaBold = PDType1Font.HELVETICA_BOLD;
            PDType1Font fontHelveticaOblique = PDType1Font.HELVETICA_OBLIQUE;
            contentStream.setNonStrokingColor(Color.BLACK);
            String[][] content = new String[][]{this.header1};
            this.drawTable(coverPage, contentStream, ypos, xpos, content, (PDFont)fontHelveticaBold, 11, false);
            String[][] content2 = new String[][]{this.header2};
            this.drawTable(coverPage, contentStream, ypos -= ygap, xpos, content2, (PDFont)fontHelveticaBold, 11, false);
            contentStream.fillRect((float)xpos, (float)(ypos -= ygap), (float)xwidth, 1.0f);
            contentStream.closeAndStroke();
            String[][] content3 = new String[][]{{this.getOwningCommunity(context, item), this.getOwningCollection(item)}};
            this.drawTable(coverPage, contentStream, ypos, xpos, content3, (PDFont)fontHelvetica, 9, false);
            contentStream.fillRect((float)xpos, (float)(ypos -= ygap), (float)xwidth, 1.0f);
            contentStream.closeAndStroke();
            ypos -= ygap * 2;
            for (String field : this.fields) {
                field = field.trim();
                PDType1Font font = fontHelvetica;
                int fontSize = 11;
                if (field.contains("title")) {
                    fontSize = 26;
                    ypos -= ygap;
                } else if (field.contains("creator") || field.contains("contributor")) {
                    fontSize = 16;
                }
                if (field.equals("_line_")) {
                    contentStream.fillRect((float)xpos, (float)ypos, (float)xwidth, 1.0f);
                    contentStream.closeAndStroke();
                    ypos -= ygap;
                } else if (StringUtils.isNotEmpty((String)this.itemService.getMetadata(item, field))) {
                    ypos = this.drawStringWordWrap(coverPage, contentStream, this.itemService.getMetadata(item, field), xpos, ypos, (PDFont)font, fontSize);
                }
                if (!field.contains("title")) continue;
                ypos -= ygap;
            }
            contentStream.beginText();
            contentStream.setFont((PDFont)fontHelveticaOblique, 11.0f);
            contentStream.moveTextPositionByAmount((float)xpos, (float)ypos);
            contentStream.drawString(this.footer);
            contentStream.endText();
        }
    }

    protected void addCoverPageToDocument(PDDocument document, PDDocument sourceDocument, PDPage coverPage) {
        PDPageTree sourcePageList = sourceDocument.getDocumentCatalog().getPages();
        if (this.isCitationFirstPage().booleanValue()) {
            document.addPage(coverPage);
            for (PDPage sourcePage : sourcePageList) {
                document.addPage(sourcePage);
            }
        } else {
            for (PDPage sourcePage : sourcePageList) {
                document.addPage(sourcePage);
            }
            document.addPage(coverPage);
        }
    }

    @Override
    public int drawStringWordWrap(PDPage page, PDPageContentStream contentStream, String text, int startX, int startY, PDFont pdfFont, float fontSize) throws IOException {
        float leading = 1.5f * fontSize;
        PDRectangle mediabox = page.getMediaBox();
        float margin = 72.0f;
        float width = mediabox.getWidth() - 2.0f * margin;
        ArrayList<String> lines = new ArrayList<String>();
        int lastSpace = -1;
        while (text.length() > 0) {
            int spaceIndex = text.indexOf(32, lastSpace + 1);
            if (spaceIndex < 0) {
                lines.add(text);
                text = "";
                continue;
            }
            String subString = text.substring(0, spaceIndex);
            float size = fontSize * pdfFont.getStringWidth(subString) / 1000.0f;
            if (size > width) {
                if (lastSpace < 0) {
                    lastSpace = spaceIndex;
                }
                subString = text.substring(0, lastSpace);
                lines.add(subString);
                text = text.substring(lastSpace).trim();
                lastSpace = -1;
                continue;
            }
            lastSpace = spaceIndex;
        }
        contentStream.beginText();
        contentStream.setFont(pdfFont, fontSize);
        contentStream.moveTextPositionByAmount((float)startX, (float)startY);
        int currentY = startY;
        for (String line : lines) {
            contentStream.drawString(line);
            currentY = (int)((float)currentY - leading);
            contentStream.moveTextPositionByAmount(0.0f, -leading);
        }
        contentStream.endText();
        return currentY;
    }

    @Override
    public String getOwningCommunity(Context context, Item item) {
        try {
            List<Community> comms = this.itemService.getCommunities(context, item);
            if (comms.size() > 0) {
                return comms.get(0).getName();
            }
            return " ";
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            return e.getMessage();
        }
    }

    @Override
    public String getOwningCollection(Item item) {
        return item.getOwningCollection().getName();
    }

    @Override
    public String getAllMetadataSeparated(Item item, String metadataKey) {
        List<MetadataValue> dcValues = this.itemService.getMetadataByMetadataString(item, metadataKey);
        ArrayList<String> valueArray = new ArrayList<String>();
        for (MetadataValue dcValue : dcValues) {
            if (!StringUtils.isNotBlank((String)dcValue.getValue())) continue;
            valueArray.add(dcValue.getValue());
        }
        return StringUtils.join((Object[])valueArray.toArray(), (String)"; ");
    }

    @Override
    public void drawTable(PDPage page, PDPageContentStream contentStream, float y, float margin, String[][] content, PDFont font, int fontSize, boolean cellBorders) throws IOException {
        int i;
        int rows = content.length;
        int cols = content[0].length;
        float rowHeight = 20.0f;
        float tableWidth = page.getMediaBox().getWidth() - 2.0f * margin;
        float tableHeight = 20.0f * (float)rows;
        float colWidth = tableWidth / (float)cols;
        float cellMargin = 5.0f;
        if (cellBorders) {
            float nexty = y;
            for (int i2 = 0; i2 <= rows; ++i2) {
                contentStream.drawLine(margin, nexty, margin + tableWidth, nexty);
                nexty -= 20.0f;
            }
            float nextx = margin;
            for (i = 0; i <= cols; ++i) {
                contentStream.drawLine(nextx, y, nextx, y - tableHeight);
                nextx += colWidth;
            }
        }
        contentStream.setFont(font, (float)fontSize);
        float textx = margin + 5.0f;
        float texty = y - 15.0f;
        for (i = 0; i < content.length; ++i) {
            for (int j = 0; j < content[i].length; ++j) {
                String text = content[i][j];
                contentStream.beginText();
                contentStream.moveTextPositionByAmount(textx, texty);
                contentStream.drawString(text);
                contentStream.endText();
                textx += colWidth;
            }
            texty -= 20.0f;
            textx = margin + 5.0f;
        }
    }
}

